/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.io;

import com.mojang.authlib.GameProfile;
import io.github.thecsdev.betterstats.api.util.io.IEditableStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IllegalHeaderException;
import io.github.thecsdev.betterstats.api.util.io.StatsProviderIO;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.exceptions.UnsupportedFileVersionException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import org.jetbrains.annotations.Nullable;

public final class RAMStatsProvider
implements IEditableStatsProvider {
    @Nullable
    protected class_2561 displayName;
    @Nullable
    protected GameProfile gameProfile;
    protected final Object2IntMap<class_3445<?>> statMap = Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap());
    protected final Object2IntMap<class_2960> playerBadgeStatMap = Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap());

    public RAMStatsProvider() {
        this.statMap.defaultReturnValue(0);
        this.playerBadgeStatMap.defaultReturnValue(0);
    }

    public RAMStatsProvider(class_2540 buffer, boolean releaseBuffer) throws NullPointerException, IllegalHeaderException, UnsupportedFileVersionException {
        this();
        try {
            StatsProviderIO.read(Objects.requireNonNull(buffer), this);
        }
        finally {
            if (releaseBuffer && buffer.refCnt() > 0) {
                buffer.release();
            }
        }
    }

    @Override
    public final class_2561 getDisplayName() {
        return this.displayName;
    }

    @Override
    public final void setDisplayName(class_2561 displayName) {
        if (displayName == null) {
            displayName = TextUtils.literal((String)"-");
        }
        this.displayName = displayName;
    }

    @Override
    public final GameProfile getGameProfile() {
        return this.gameProfile;
    }

    @Override
    public final void setGameProfile(@Nullable GameProfile playerProfile) {
        this.gameProfile = playerProfile;
    }

    @Override
    public final int getStatValue(class_3445<?> stat) {
        return this.statMap.getInt(stat);
    }

    @Override
    public final void setStatValue(class_3445<?> stat, int value) throws NullPointerException {
        if (value < 1) {
            this.statMap.removeInt(stat);
        } else {
            this.statMap.put(Objects.requireNonNull(stat), value);
        }
    }

    @Override
    public final int getPlayerBadgeValue(class_2960 badgeId) {
        return this.playerBadgeStatMap.getInt((Object)badgeId);
    }

    @Override
    public final void setPlayerBadgeValue(class_2960 badgeId, int value) throws NullPointerException {
        if (value < 1) {
            this.playerBadgeStatMap.removeInt((Object)badgeId);
        } else {
            this.playerBadgeStatMap.put((Object)Objects.requireNonNull(badgeId), value);
        }
    }

    public final Object2IntMap<class_3445<?>> getStatMap() {
        return this.statMap;
    }

    public final Object2IntMap<class_2960> getPlayerBadgeStatMap() {
        return this.playerBadgeStatMap;
    }
}

