/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.panel;

import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.api.client.gui.panel.BSComponentPanel;
import io.github.thecsdev.betterstats.api.client.gui.widget.ScrollBarWidget;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.api.client.util.StatFilterSettings;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TScrollBarWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class StatsTabPanel
extends BSComponentPanel {
    public static final class_2561 TXT_NO_STATS_YET = TextUtils.translatable((String)"betterstats.client.gui.stats.panel.statstabpanel.no_stats_yet", (Object[])new Object[0]);
    public static final class_2960 FILTER_ID_SCROLL_CACHE = new class_2960(BetterStats.getModID(), "stats_scroll_cache");
    protected final StatsTabPanelProxy proxy;
    @Nullable
    protected TPanelElement panel;
    @Nullable
    protected TScrollBarWidget scroll_panel;

    public StatsTabPanel(int x, int y, int width, int height, StatsTabPanelProxy proxy) throws NullPointerException {
        super(x, y, width, height);
        this.proxy = Objects.requireNonNull(proxy);
    }

    public final StatsTabPanelProxy getProxy() {
        return this.proxy;
    }

    @ApiStatus.Internal
    public final double getVerticalScrollBarValue() {
        return this.scroll_panel != null ? this.scroll_panel.getValue() : 0.0;
    }

    protected final void init() {
        StatFilterSettings fil = this.getProxy().getFilterSettings();
        this.panel = new TPanelElement(0, 0, this.getWidth() - 8, this.getHeight());
        this.panel.setScrollFlags(4);
        this.panel.setScrollPadding(10);
        this.panel.setSmoothScroll(true);
        this.panel.setBackgroundColor(0);
        this.panel.setOutlineColor(0);
        this.addChild((TElement)this.panel, true);
        this.scroll_panel = new ScrollBarWidget(this.panel.getWidth(), 0, 8, this.panel.getHeight(), this.panel);
        this.addChild((TElement)this.scroll_panel, true);
        this.panel.eScrolledVertically.register((__, val) -> fil.setProperty(FILTER_ID_SCROLL_CACHE, new Double[]{this.scroll_panel.getValue()}));
        StatsTab selTab = this.proxy.getSelectedStatsTab();
        if (selTab == null) {
            return;
        }
        final IStatsProvider statsProvider = this.proxy.getStatsProvider();
        final StatFilterSettings filterSettings = this.proxy.getFilterSettings();
        selTab.initStats(new StatsTab.StatsInitContext(){

            @Override
            public IStatsProvider getStatsProvider() {
                return statsProvider;
            }

            @Override
            public TPanelElement getStatsPanel() {
                return StatsTabPanel.this.panel;
            }

            @Override
            public StatFilterSettings getFilterSettings() {
                return filterSettings;
            }
        });
        if (this.panel.getChildren().size() == 0) {
            this.init_noStatsLabel(this.panel);
        } else {
            this.scroll_panel.setValue(((Double)fil.getPropertyOrDefault(FILTER_ID_SCROLL_CACHE, 0.0)).doubleValue());
        }
    }

    @ApiStatus.Internal
    private final TLabelElement init_noStatsLabel(TPanelElement panel) {
        int sp = panel.getScrollPadding();
        TLabelElement lbl = new TLabelElement(sp, sp, panel.getWidth() - sp * 2, panel.getHeight() - sp * 2);
        lbl.setText(TXT_NO_STATS_YET);
        lbl.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
        panel.addChild((TElement)lbl, true);
        return lbl;
    }

    public static interface StatsTabPanelProxy {
        public IStatsProvider getStatsProvider();

        public StatsTab getSelectedStatsTab();

        public StatFilterSettings getFilterSettings();
    }
}

