/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.thecsdev.tcdcommons.api.command.argument.StatArgumentType;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.command.PlayerBadgeCommand;
import io.github.thecsdev.tcdcommons.mixin.hooks.AccessorStatHandler;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1657;
import net.minecraft.class_2164;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class StatisticsCommand {
    public static final String TEXT_EDIT_OUTPUT = "commands.statistics.edit.output";
    public static final class_2561 TEXT_CLEAR_KICK = TextUtils.translatable((String)"commands.statistics.clear.kick", (Object[])new Object[0]);
    public static final String TEXT_CLEAR_OUTPUT = "commands.statistics.clear.output";
    public static final String TEXT_QUERY_OUTPUT = "commands.statistics.query.output";

    private StatisticsCommand() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 cra) {
        LiteralArgumentBuilder statistics = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"statistics").requires(scs -> scs.method_9259(2))).then(StatisticsCommand.statistics_edit(cra))).then(StatisticsCommand.statistics_clear())).then(StatisticsCommand.statistics_query(cra));
        LiteralArgumentBuilder stats = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stats").requires(scs -> scs.method_9259(2))).then(StatisticsCommand.statistics_edit(cra))).then(StatisticsCommand.statistics_clear())).then(StatisticsCommand.statistics_query(cra));
        dispatcher.register(statistics);
        dispatcher.register(stats);
    }

    private static ArgumentBuilder<class_2168, ?> statistics_edit(class_7157 cra) {
        return class_2170.method_9247((String)"edit").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"stat_type", (ArgumentType)class_7733.method_45603((class_7157)cra, (class_5321)class_7924.field_41226)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"stat", (ArgumentType)StatArgumentType.stat()).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> StatisticsCommand.execute_edit((CommandContext<class_2168>)ctx, true))))).then(class_2170.method_9247((String)"increase").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> StatisticsCommand.execute_edit((CommandContext<class_2168>)ctx, false)))))));
    }

    private static ArgumentBuilder<class_2168, ?> statistics_clear() {
        return class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(ctx -> StatisticsCommand.execute_clear((CommandContext<class_2168>)ctx)));
    }

    private static ArgumentBuilder<class_2168, ?> statistics_query(class_7157 cra) {
        return class_2170.method_9247((String)"query").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"stat_type", (ArgumentType)class_7733.method_45603((class_7157)cra, (class_5321)class_7924.field_41226)).then(class_2170.method_9244((String)"stat", (ArgumentType)StatArgumentType.stat()).executes(ctx -> StatisticsCommand.execute_query((CommandContext<class_2168>)ctx)))));
    }

    private static int execute_edit(CommandContext<class_2168> context, boolean setOrIncrease) {
        try {
            Collection arg_targets = class_2186.method_9312(context, (String)"targets");
            class_3448 arg_stat_type = (class_3448)class_7733.method_45602(context, (String)"stat_type", (class_5321)class_7924.field_41226).comp_349();
            class_2960 arg_stat = class_2232.method_9443(context, (String)"stat");
            int arg_value = IntegerArgumentType.getInteger(context, (String)"value");
            Object stat_object = arg_stat_type.method_14959().method_17966(arg_stat).orElse(null);
            Objects.requireNonNull(stat_object, "Registry entry '" + arg_stat + "' does not exist for registry '" + arg_stat_type.method_14959() + "'.");
            class_3445 stat = arg_stat_type.method_14956(stat_object);
            AtomicInteger affected = new AtomicInteger();
            for (class_3222 target : arg_targets) {
                if (target == null) continue;
                if (setOrIncrease) {
                    target.method_14248().method_15023((class_1657)target, stat, arg_value);
                } else {
                    target.method_14248().method_15022((class_1657)target, stat, arg_value);
                }
                affected.incrementAndGet();
                target.method_14248().method_14910(target);
            }
            ((class_2168)context.getSource()).method_9226(() -> TextUtils.translatable((String)TEXT_EDIT_OUTPUT, (Object[])new Object[]{"[" + class_7923.field_41193.method_10221((Object)arg_stat_type) + " / " + arg_stat + "]", Integer.toString(affected.get())}), false);
            return affected.get();
        }
        catch (CommandSyntaxException | IllegalStateException | NullPointerException | class_2164 e) {
            PlayerBadgeCommand.handleError(context, (Throwable)e);
            return -1;
        }
    }

    private static int execute_clear(CommandContext<class_2168> context) {
        try {
            Collection targets = class_2186.method_9312(context, (String)"targets");
            AtomicInteger affected = new AtomicInteger();
            for (class_3222 target : targets) {
                if (target == null) continue;
                ((AccessorStatHandler)target.method_14248()).getStatMap().clear();
                affected.incrementAndGet();
                target.field_13987.method_14367((class_2561)TextUtils.literal((String)"").method_10852(TEXT_CLEAR_KICK).method_27693("\n\n[EN]: Your statistics were cleared, which requires you to disconnect and re-join."));
            }
            ((class_2168)context.getSource()).method_9226(() -> TextUtils.translatable((String)TEXT_CLEAR_OUTPUT, (Object[])new Object[]{Integer.toString(affected.get())}), false);
            return affected.get();
        }
        catch (CommandSyntaxException | class_2164 e) {
            PlayerBadgeCommand.handleError(context, (Throwable)e);
            return -1;
        }
    }

    private static int execute_query(CommandContext<class_2168> context) {
        try {
            class_3222 arg_target = class_2186.method_9315(context, (String)"target");
            if (arg_target == null) {
                throw new class_2164((class_2561)TextUtils.literal((String)"Player not found."));
            }
            class_3448 arg_stat_type = (class_3448)class_7733.method_45602(context, (String)"stat_type", (class_5321)class_7924.field_41226).comp_349();
            class_2960 arg_stat = class_2232.method_9443(context, (String)"stat");
            Object stat_object = arg_stat_type.method_14959().method_17966(arg_stat).orElse(null);
            Objects.requireNonNull(stat_object, "Registry entry '" + arg_stat + "' does not exist for registry '" + arg_stat_type.method_14959() + "'.");
            class_3445 stat = arg_stat_type.method_14956(stat_object);
            int statValue = arg_target.method_14248().method_15025(stat);
            ((class_2168)context.getSource()).method_9226(() -> TextUtils.translatable((String)TEXT_QUERY_OUTPUT, (Object[])new Object[]{arg_target.method_5476(), "[" + class_7923.field_41193.method_10221((Object)arg_stat_type) + " / " + arg_stat + "]", Integer.toString(statValue)}), false);
            return statValue;
        }
        catch (CommandSyntaxException | class_2164 e) {
            PlayerBadgeCommand.handleError(context, (Throwable)e);
            return -1;
        }
    }
}

