/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.mixin;

import io.github.lucaargolo.kibe.blocks.miscellaneous.Elevator;
import io.github.lucaargolo.kibe.items.ItemCompendiumKt;
import io.github.lucaargolo.kibe.items.miscellaneous.Glider;
import io.github.lucaargolo.kibe.items.miscellaneous.SleepingBag;
import io.github.lucaargolo.kibe.utils.SlimeBounceHandler;
import io.github.lucaargolo.kibe.utils.SpikeHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Shadow
    public abstract class_1799 method_5998(class_1268 var1);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(at={@At(value="HEAD")}, method={"swingHand(Lnet/minecraft/util/Hand;)V"}, cancellable=true)
    private void swingHand(class_1268 hand, CallbackInfo info) {
        class_1799 stack = this.method_5998(hand);
        if (stack.method_7909() instanceof Glider && Glider.Companion.isEnabled(stack)) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isSleepingInBed"}, cancellable=true)
    private void isSleepingInBed(CallbackInfoReturnable<Boolean> info) {
        if (SleepingBag.Companion.getPlayersSleeping().contains((Object)this)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"jump"})
    private void jump(CallbackInfo info) {
        class_2338 pos = this.method_24515();
        class_2248 block = this.method_37908().method_8320(pos.method_10074()).method_26204();
        if (block instanceof Elevator && this.method_37908().method_8320(pos).method_26220((class_1922)this.method_37908(), pos).method_1110()) {
            while (pos.method_10264() < this.method_37908().method_31600()) {
                if (this.method_37908().method_8320(pos.method_10084()).method_26204().equals(block) && Elevator.Companion.isElevatorValid(this.method_37908(), pos.method_10084())) {
                    this.method_37908().method_8396(null, pos, class_3417.field_15134, class_3419.field_15245, 0.5f, this.method_37908().field_9229.method_43057() * 0.25f + 0.6f);
                    this.method_20620(this.method_19538().field_1352, (double)pos.method_10084().method_10264() + 1.15, this.method_19538().field_1350);
                    break;
                }
                pos = pos.method_10084();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleFallDamage"})
    private void handleFallDamage(float fallDistance, float damageMultiplier, class_1282 source, CallbackInfoReturnable<Boolean> info) {
        class_1657 player;
        if (this instanceof class_1657 && (player = (class_1657)this).method_6118(class_1304.field_6166).method_7909() == ItemCompendiumKt.getSLIME_BOOTS()) {
            if (!this.method_5715() && fallDistance > 2.0f) {
                this.field_6017 = 0.0f;
                if (this.method_37908().field_9236) {
                    this.method_18800(this.method_18798().field_1352, this.method_18798().field_1351 * -0.9, this.method_18798().field_1350);
                    this.field_6007 = true;
                    this.method_24830(false);
                    double f = 0.9500000000000001;
                    this.method_18800(this.method_18798().field_1352 / f, this.method_18798().field_1351, this.method_18798().field_1350 / f);
                } else {
                    info.cancel();
                }
                this.method_5783(class_3417.field_15095, 1.0f, 1.0f);
                SlimeBounceHandler.Companion.addBounceHandler((class_1309)player, this.method_18798().field_1351);
            } else if (!this.method_37908().field_9236 && this.method_5715() && fallDistance > 5.0f) {
                this.field_6017 = 5.0f;
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"shouldDropLoot"}, cancellable=true)
    private void shouldDropLoot(CallbackInfoReturnable<Boolean> cir) {
        class_1309 livingEntity = (class_1309)this;
        if (SpikeHelper.INSTANCE.shouldCancelLootDrop(livingEntity)) {
            cir.setReturnValue((Object)false);
        }
    }
}

