/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.registry.RegistryDataProvider;
import net.darkhax.darkutilities.Content;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;

public class DarkUtilsCommon {
    public static final List<BiFunction<class_1657, Predicate<class_1799>, Boolean>> charmResolvers = new ArrayList<BiFunction<class_1657, Predicate<class_1799>, Boolean>>();
    private static DarkUtilsCommon instance;
    public final Content content = new Content();

    public DarkUtilsCommon() {
        Services.REGISTRIES.loadContent((RegistryDataProvider)this.content);
        Services.EVENTS.addItemTooltipListener(this::addDescriptionTooltips);
        charmResolvers.add(DarkUtilsCommon::hasItemInVanillaInventory);
    }

    public static DarkUtilsCommon getInstance() {
        if (instance == null) {
            instance = new DarkUtilsCommon();
        }
        return instance;
    }

    private void addDescriptionTooltips(class_1799 stack, List<class_2561> tooltip, class_1836 flag) {
        class_2561 description = this.content.tooltipCache.get(stack.method_7909());
        if (description != null) {
            tooltip.add(description);
        }
    }

    public static boolean hasItem(class_1297 entity, Supplier<class_1792> item) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return charmResolvers.stream().anyMatch(func -> (Boolean)func.apply(player, arg_0 -> DarkUtilsCommon.lambda$hasItem$0((Supplier)item, arg_0)));
        }
        return false;
    }

    private static boolean hasItemInVanillaInventory(class_1657 player, Predicate<class_1799> predicate) {
        for (class_1799 stack : player.method_31548().field_7547) {
            if (!predicate.test(stack)) continue;
            return true;
        }
        for (class_1304 slotType : class_1304.values()) {
            if (!predicate.test(player.method_6118(slotType))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$hasItem$0(Supplier item, class_1799 s) {
        return s.method_31574((class_1792)item.get());
    }
}

