/*
 * Decompiled with CFR 0.152.
 */
package com.shmove.cat_jam.mixin;

import com.shmove.cat_jam.cat_jam;
import com.shmove.cat_jam.helpers.JammingEntity;
import com.shmove.cat_jam.helpers.discs.DiscPlayback;
import net.minecraft.class_1297;
import net.minecraft.class_1451;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1451.class})
public class CatEntityMixin
implements JammingEntity {
    @Unique
    private class_2338 musicSourceBlock = null;
    @Unique
    private Integer musicSourceEntityID = null;
    @Unique
    private boolean catJamming = false;
    @Unique
    private DiscPlayback discPlayback = null;
    @Unique
    private int nodTick = -1;
    @Unique
    private int slightNodTick = -1;

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void jamTick(CallbackInfo ci) {
        class_1297 musicSourceEntity;
        class_1451 meow = (class_1451)this;
        if (!meow.method_37908().field_9236) {
            return;
        }
        if (!(this.musicSourceBlock == null || this.musicSourceBlock.method_19769((class_2374)meow.method_19538(), 3.46) && cat_jam.isSourcePlayingAtPos(this.musicSourceBlock))) {
            this.resetJammingInfo();
        }
        if (!(this.musicSourceEntityID == null || (musicSourceEntity = meow.method_37908().method_8469(this.musicSourceEntityID.intValue())) != null && musicSourceEntity.method_24516((class_1297)meow, 3.46) && musicSourceEntity.method_5805() && cat_jam.isSourcePlayingFromEntity(this.musicSourceEntityID))) {
            this.resetJammingInfo();
        }
        if (!this.catJamming) {
            this.findNewMusicSource();
        }
        if (this.catJamming) {
            this.updateNod();
            this.updateNodAnim();
        }
    }

    @Override
    public void resetJammingInfo() {
        this.musicSourceBlock = null;
        this.musicSourceEntityID = null;
        this.discPlayback = null;
        this.catJamming = false;
        this.nodTick = -1;
        this.slightNodTick = -1;
    }

    private void findNewMusicSource() {
        boolean FOUND_ENTITY_SOURCE;
        class_1451 meow = (class_1451)this;
        class_2338 nearbyBlockSource = cat_jam.getClosestListenableSourcePos(meow.method_19538());
        class_1297 nearbyEntitySource = cat_jam.getClosestListenableSourceEntity(meow.method_19538());
        boolean FOUND_BLOCK_SOURCE = nearbyBlockSource != null;
        boolean bl = FOUND_ENTITY_SOURCE = nearbyEntitySource != null;
        if (!FOUND_BLOCK_SOURCE && !FOUND_ENTITY_SOURCE) {
            return;
        }
        if (FOUND_BLOCK_SOURCE && FOUND_ENTITY_SOURCE) {
            double entityDist;
            double blockDist = nearbyBlockSource.method_19770((class_2374)meow.method_19538());
            if (blockDist < (entityDist = nearbyEntitySource.method_5858((class_1297)meow))) {
                this.updateMusicSource(nearbyBlockSource);
            } else {
                this.updateMusicSource(nearbyEntitySource.method_5628());
            }
        } else if (FOUND_BLOCK_SOURCE) {
            this.updateMusicSource(nearbyBlockSource);
        } else if (FOUND_ENTITY_SOURCE) {
            this.updateMusicSource(nearbyEntitySource.method_5628());
        }
    }

    @Override
    public void updateMusicSource(class_2338 sourcePos) {
        class_1451 meow = (class_1451)this;
        if (!meow.method_6181()) {
            return;
        }
        this.musicSourceBlock = sourcePos;
        this.discPlayback = cat_jam.getDiscPlaybackAtPos(sourcePos);
        this.catJamming = true;
        meow.method_37908().method_8406((class_2394)class_2398.field_11224, meow.method_23317(), meow.method_23318() + 0.3, meow.method_23321(), 0.0, 0.0, 0.0);
    }

    @Override
    public void updateMusicSource(Integer sourceEntityID) {
        class_1451 meow = (class_1451)this;
        if (!meow.method_6181()) {
            return;
        }
        this.musicSourceEntityID = sourceEntityID;
        this.discPlayback = cat_jam.getDiscPlaybackFromEntity(sourceEntityID);
        this.catJamming = true;
        meow.method_37908().method_8406((class_2394)class_2398.field_11224, meow.method_23317(), meow.method_23318() + 0.3, meow.method_23321(), 0.0, 0.0, 0.0);
    }

    private void updateNod() {
        if (this.discPlayback.anticipateBeat(2) && this.discPlayback.isNodBeat()) {
            if (this.nodTick >= 0) {
                return;
            }
            this.nodTick = 0;
        } else if (this.discPlayback.anticipateBeat(1) && this.discPlayback.isSlightNodBeat()) {
            if (this.slightNodTick >= 0) {
                return;
            }
            this.slightNodTick = 0;
        }
    }

    private void updateNodAnim() {
        int nodAnimTickLength = 8;
        int slightNodAnimTickLength = 6;
        if (this.nodTick >= 0) {
            if (this.nodTick < 7) {
                ++this.nodTick;
            } else if (this.nodTick == 7) {
                this.nodTick = -1;
            }
        }
        if (this.slightNodTick >= 0) {
            if (this.slightNodTick < 5) {
                ++this.slightNodTick;
            } else if (this.slightNodTick == 5) {
                this.slightNodTick = -1;
            }
        }
    }

    @Override
    public int getNodTick() {
        return this.nodTick;
    }

    @Override
    public int getSlightNodTick() {
        return this.slightNodTick;
    }
}

