/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.mixin.common;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import me.steven.indrev.api.IRPlayerEntityExtension;
import me.steven.indrev.items.energy.IREnergyItem;
import me.steven.indrev.items.energy.IRGamerAxeItem;
import me.steven.indrev.tools.modular.ArmorModule;
import me.steven.indrev.utils.EnergyutilsKt;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import team.reborn.energy.api.EnergyStorage;

@Mixin(value={class_1657.class})
public abstract class MixinPlayerEntity
extends class_1309
implements IRPlayerEntityExtension {
    private boolean indrev_regenerating = false;
    private double indrev_shield = 0.0;
    private final Object2IntMap<ArmorModule> appliedEffects = new Object2IntOpenHashMap();

    protected MixinPlayerEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"getBlockBreakingSpeed"}, at={@At(value="HEAD")}, cancellable=true)
    private void indrev_checkEnergyTool(class_2680 block, CallbackInfoReturnable<Float> cir) {
        class_1657 player = (class_1657)this;
        class_1661 inventory2 = player.method_31548();
        class_1799 itemStack = (class_1799)inventory2.field_7547.get(inventory2.field_7545);
        class_1792 item = itemStack.method_7909();
        EnergyStorage itemIo = EnergyutilsKt.energyOf(itemStack);
        if (itemIo != null && item instanceof IREnergyItem) {
            class_2487 tag;
            long amount2 = itemIo.getAmount();
            if (item instanceof IRGamerAxeItem && (tag = itemStack.method_7948()).method_10545("Active") && !tag.method_10577("Active")) {
                cir.setReturnValue((Object)Float.valueOf(0.2f));
                return;
            }
            if (amount2 < 1L) {
                cir.setReturnValue((Object)Float.valueOf(0.2f));
            }
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="RETURN")})
    private void indrev_writeShieldToPlayerTag(class_2487 tag, CallbackInfo ci) {
        tag.method_10549("indrev:shield", this.indrev_shield);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="RETURN")})
    private void indrev_readShieldToPlayerTag(class_2487 tag, CallbackInfo ci) {
        this.indrev_shield = tag.method_10574("indrev:shield");
    }

    @Override
    public double getShieldDurability() {
        return this.indrev_shield;
    }

    @Override
    public void setShieldDurability(double shieldDurability) {
        this.indrev_shield = shieldDurability;
    }

    @Override
    public double getMaxShieldDurability() {
        Iterator iterator = this.method_5661().iterator();
        double shield2 = 0.0;
        while (iterator.hasNext()) {
            class_1799 next = (class_1799)iterator.next();
            shield2 += (double)(ArmorModule.PROTECTION.getLevel(next) * 25);
        }
        return shield2;
    }

    @Override
    @NotNull
    public Map<ArmorModule, Integer> getAppliedModules() {
        return this.appliedEffects;
    }

    @Override
    public boolean isApplied(@NotNull ArmorModule module) {
        return this.appliedEffects.containsKey((Object)module);
    }

    @Override
    public void applyModule(@NotNull ArmorModule module, int level) {
        this.appliedEffects.put((Object)module, level);
    }

    @Override
    public int getAppliedLevel(@NotNull ArmorModule module) {
        return this.appliedEffects.getOrDefault((Object)module, 0);
    }

    @Override
    public void setRegenerating(boolean isRegenerating) {
        this.indrev_regenerating = isRegenerating;
    }

    @Override
    public boolean isRegenerating() {
        return this.indrev_regenerating;
    }
}

