/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.networks;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.steven.indrev.networks.EndpointData;
import me.steven.indrev.networks.Network;
import me.steven.indrev.networks.NetworkState;
import me.steven.indrev.networks.Node;
import me.steven.indrev.networks.ServoNetworkState;
import me.steven.indrev.networks.client.ClientNetworkInfo;
import me.steven.indrev.networks.client.ClientServoNetworkInfo;
import me.steven.indrev.networks.client.node.ClientServoNodeInfo;
import me.steven.indrev.networks.energy.EnergyNetwork;
import me.steven.indrev.networks.factory.FactoriesKt;
import me.steven.indrev.networks.factory.NetworkFactory;
import me.steven.indrev.networks.fluid.FluidNetwork;
import me.steven.indrev.networks.fluid.FluidNetworkState;
import me.steven.indrev.networks.item.ItemNetwork;
import me.steven.indrev.networks.item.ItemNetworkState;
import me.steven.indrev.utils.AccessorextensionsKt;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u0000 ?2\u00020\u0001:\u0002?@BG\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u001a\b\u0002\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0011H\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019J/\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001dH\u0004\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010\"\u001a\u00020!H\u0004\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b$\u0010\u0019J\u0017\u0010%\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0004H&\u00a2\u0006\u0004\b%\u0010&R)\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010'\u001a\u0004\b(\u0010)R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010*\u001a\u0004\b+\u0010,R,\u00100\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.0-8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R\u001f\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0000048\u0006\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108R\u001b\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00109\u001a\u0004\b:\u0010;R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010<\u001a\u0004\b=\u0010>\u00a8\u0006A"}, d2={"Lme/steven/indrev/networks/Network;", "", "Lme/steven/indrev/networks/Network$Type;", "type", "Lnet/minecraft/class_3218;", "world", "", "Lnet/minecraft/class_2338;", "pipes", "", "Ljava/util/EnumSet;", "Lnet/minecraft/class_2350;", "containers", "<init>", "(Lme/steven/indrev/networks/Network$Type;Lnet/minecraft/class_3218;Ljava/util/Set;Ljava/util/Map;)V", "blockPos", "direction", "", "appendContainer", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_2350;)V", "Lnet/minecraft/class_2248;", "block", "appendPipe", "(Lnet/minecraft/class_2248;Lnet/minecraft/class_2338;)V", "buildQueue", "()V", "source", "", "count", "Lit/unimi/dsi/fastutil/longs/LongOpenHashSet;", "s", "find", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_2338;ILit/unimi/dsi/fastutil/longs/LongOpenHashSet;)V", "", "isQueueValid", "()Z", "remove", "tick", "(Lnet/minecraft/class_3218;)V", "Ljava/util/Map;", "getContainers", "()Ljava/util/Map;", "Ljava/util/Set;", "getPipes", "()Ljava/util/Set;", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;", "", "Lme/steven/indrev/networks/Node;", "queue", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;", "getQueue", "()Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;", "Lme/steven/indrev/networks/NetworkState;", "state", "Lme/steven/indrev/networks/NetworkState;", "getState", "()Lme/steven/indrev/networks/NetworkState;", "Lme/steven/indrev/networks/Network$Type;", "getType", "()Lme/steven/indrev/networks/Network$Type;", "Lnet/minecraft/class_3218;", "getWorld", "()Lnet/minecraft/class_3218;", "Companion", "Type", "indrev"})
@SourceDebugExtension(value={"SMAP\nNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Network.kt\nme/steven/indrev/networks/Network\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,158:1\n215#2,2:159\n13309#3,2:161\n*S KotlinDebug\n*F\n+ 1 Network.kt\nme/steven/indrev/networks/Network\n*L\n48#1:159,2\n54#1:161,2\n*E\n"})
public abstract class Network {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Type<?> type;
    @NotNull
    private final class_3218 world;
    @NotNull
    private final Set<class_2338> pipes;
    @NotNull
    private final Map<class_2338, EnumSet<class_2350>> containers;
    @NotNull
    private final NetworkState<? extends Network> state;
    @NotNull
    private final Object2ObjectOpenHashMap<class_2338, List<Node>> queue;
    @NotNull
    private static final class_2350[] DIRECTIONS = class_2350.values();

    public Network(@NotNull Type<?> type, @NotNull class_3218 world, @NotNull Set<class_2338> pipes, @NotNull Map<class_2338, EnumSet<class_2350>> containers) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(pipes, (String)"pipes");
        Intrinsics.checkNotNullParameter(containers, (String)"containers");
        this.type = type;
        this.world = world;
        this.pipes = pipes;
        this.containers = containers;
        this.state = this.type.getNetworkState(this.world);
        this.queue = new Object2ObjectOpenHashMap(this.containers.size());
    }

    public /* synthetic */ Network(Type type, class_3218 class_32182, Set set, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            set = (Set)new ObjectOpenHashSet();
        }
        if ((n & 8) != 0) {
            map = (Map)new Object2ObjectOpenHashMap();
        }
        this(type, class_32182, set, map);
    }

    @NotNull
    public final Type<?> getType() {
        return this.type;
    }

    @NotNull
    public final class_3218 getWorld() {
        return this.world;
    }

    @NotNull
    public final Set<class_2338> getPipes() {
        return this.pipes;
    }

    @NotNull
    public final Map<class_2338, EnumSet<class_2350>> getContainers() {
        return this.containers;
    }

    @NotNull
    public final NetworkState<? extends Network> getState() {
        return this.state;
    }

    @NotNull
    protected final Object2ObjectOpenHashMap<class_2338, List<Node>> getQueue() {
        return this.queue;
    }

    protected final boolean isQueueValid() {
        if (this.queue.isEmpty() && !this.containers.isEmpty()) {
            this.buildQueue();
        }
        return !((Map)this.queue).isEmpty();
    }

    protected final void buildQueue() {
        this.queue.clear();
        Map<class_2338, EnumSet<class_2350>> $this$forEach$iv = this.containers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<class_2338, EnumSet<class_2350>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_2338, EnumSet<class_2350>> element$iv;
            Map.Entry<class_2338, EnumSet<class_2350>> entry = element$iv = iterator.next();
            boolean bl = false;
            class_2338 pos = entry.getKey();
            this.find(pos, pos, 0, new LongOpenHashSet());
        }
    }

    protected final void find(@NotNull class_2338 source, @NotNull class_2338 blockPos, int count, @NotNull LongOpenHashSet s2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
        class_2350[] $this$forEach$iv = DIRECTIONS;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            class_2350 element$iv;
            class_2350 dir = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            class_2338 offset = blockPos.method_10093(dir.method_10153());
            if (this.pipes.contains(offset) && s2.add(offset.method_10063())) {
                Intrinsics.checkNotNull((Object)offset);
                this.find(source, offset, count + 1, s2);
            }
            if (Intrinsics.areEqual((Object)source, (Object)offset) || !this.containers.containsKey(offset)) continue;
            EnumSet<class_2350> enumSet = this.containers.get(offset);
            Intrinsics.checkNotNull(enumSet);
            if (!enumSet.contains(dir)) continue;
            List list = (List)this.queue.computeIfAbsent((Object)source, arg_0 -> Network.find$lambda$2$lambda$1(this, arg_0));
            Intrinsics.checkNotNull((Object)offset);
            list.add(new Node(source, offset, count, dir));
        }
    }

    public abstract void tick(@NotNull class_3218 var1);

    public void remove() {
        this.state.remove(this);
    }

    public void appendPipe(@NotNull class_2248 block, @NotNull class_2338 blockPos) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        this.pipes.add(blockPos);
        this.state.set(blockPos, this);
    }

    public void appendContainer(@NotNull class_2338 blockPos, @NotNull class_2350 direction) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        this.containers.computeIfAbsent(blockPos, arg_0 -> Network.appendContainer$lambda$3(appendContainer.1.INSTANCE, arg_0)).add(direction);
        this.state.set(blockPos, this);
    }

    private static final ArrayList find$lambda$2$lambda$1(Network this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new ArrayList(this$0.containers.size());
    }

    private static final EnumSet appendContainer$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (EnumSet)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u000b\u001a\u00020\n\"\b\b\u0000\u0010\u0005*\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ-\u0010\r\u001a\u00020\n\"\b\b\u0000\u0010\u0005*\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\fR\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lme/steven/indrev/networks/Network$Companion;", "", "<init>", "()V", "Lme/steven/indrev/networks/Network;", "T", "Lme/steven/indrev/networks/NetworkState;", "state", "Lnet/minecraft/class_2338;", "pos", "", "handleBreak", "(Lme/steven/indrev/networks/NetworkState;Lnet/minecraft/class_2338;)V", "handleUpdate", "", "Lnet/minecraft/class_2350;", "DIRECTIONS", "[Lnet/minecraft/class_2350;", "getDIRECTIONS", "()[Lnet/minecraft/class_2350;", "indrev"})
    @SourceDebugExtension(value={"SMAP\nNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Network.kt\nme/steven/indrev/networks/Network$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,158:1\n13309#2,2:159\n*S KotlinDebug\n*F\n+ 1 Network.kt\nme/steven/indrev/networks/Network$Companion\n*L\n89#1:159,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2350[] getDIRECTIONS() {
            return DIRECTIONS;
        }

        public final <T extends Network> void handleBreak(@NotNull NetworkState<T> state, @NotNull class_2338 pos) {
            Intrinsics.checkNotNullParameter(state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Network network = (Network)state.getNetworksByPos().get(pos.method_10063());
            if (network != null) {
                network.remove();
            }
            class_2350[] $this$forEach$iv = this.getDIRECTIONS();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                class_2350 element$iv;
                class_2350 it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                class_2338 offset = pos.method_10093(it);
                Intrinsics.checkNotNull((Object)offset);
                Companion.handleUpdate(state, offset);
            }
        }

        public final <T extends Network> void handleUpdate(@NotNull NetworkState<T> state, @NotNull class_2338 pos) {
            Intrinsics.checkNotNullParameter(state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Network network = (Network)state.getNetworksByPos().get(pos.method_10063());
            if (network != null) {
                network.remove();
            }
            state.queueUpdate(pos.method_10063(), true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 \u0019*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003:\u0001\u0019B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\bH&\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\t\u001a\u00020\bH&\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00128&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lme/steven/indrev/networks/Network$Type;", "Lme/steven/indrev/networks/Network;", "T", "", "", "key", "<init>", "(Ljava/lang/String;)V", "Lnet/minecraft/class_3218;", "world", "Lme/steven/indrev/networks/client/ClientNetworkInfo;", "createClientNetworkInfo", "(Lnet/minecraft/class_3218;)Lme/steven/indrev/networks/client/ClientNetworkInfo;", "createEmpty", "(Lnet/minecraft/class_3218;)Lme/steven/indrev/networks/Network;", "Lme/steven/indrev/networks/NetworkState;", "getNetworkState", "(Lnet/minecraft/class_3218;)Lme/steven/indrev/networks/NetworkState;", "Lme/steven/indrev/networks/factory/NetworkFactory;", "getFactory", "()Lme/steven/indrev/networks/factory/NetworkFactory;", "factory", "Ljava/lang/String;", "getKey", "()Ljava/lang/String;", "Companion", "indrev"})
    @SourceDebugExtension(value={"SMAP\nNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Network.kt\nme/steven/indrev/networks/Network$Type\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,158:1\n215#2:159\n215#2,2:160\n216#2:162\n*S KotlinDebug\n*F\n+ 1 Network.kt\nme/steven/indrev/networks/Network$Type\n*L\n112#1:159\n114#1:160,2\n112#1:162\n*E\n"})
    public static abstract class Type<T extends Network> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String key;
        @NotNull
        private static final Type<EnergyNetwork> ENERGY = new Type<EnergyNetwork>(){
            @NotNull
            private final NetworkFactory<EnergyNetwork> factory;
            {
                this.factory = FactoriesKt.getENERGY_NET_FACTORY();
            }

            @NotNull
            public NetworkFactory<EnergyNetwork> getFactory() {
                return this.factory;
            }

            @NotNull
            public EnergyNetwork createEmpty(@NotNull class_3218 world) {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                return new EnergyNetwork(world, null, null, 6, null);
            }

            @NotNull
            public NetworkState<EnergyNetwork> getNetworkState(@NotNull class_3218 world) {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                return AccessorextensionsKt.getEnergyNetworkState(world);
            }
        };
        @NotNull
        private static final Type<FluidNetwork> FLUID = new Type<FluidNetwork>(){
            @NotNull
            private final NetworkFactory<FluidNetwork> factory;
            {
                this.factory = FactoriesKt.getFLUID_NET_FACTORY();
            }

            @NotNull
            public NetworkFactory<FluidNetwork> getFactory() {
                return this.factory;
            }

            @NotNull
            public FluidNetwork createEmpty(@NotNull class_3218 world) {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                return new FluidNetwork(world, null, null, 6, null);
            }

            @NotNull
            public FluidNetworkState getNetworkState(@NotNull class_3218 world) {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                return AccessorextensionsKt.getFluidNetworkState(world);
            }
        };
        @NotNull
        private static final Type<ItemNetwork> ITEM = new Type<ItemNetwork>(){
            @NotNull
            private final NetworkFactory<ItemNetwork> factory;
            {
                this.factory = FactoriesKt.getITEM_NET_FACTORY();
            }

            @NotNull
            public NetworkFactory<ItemNetwork> getFactory() {
                return this.factory;
            }

            @NotNull
            public ItemNetwork createEmpty(@NotNull class_3218 world) {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                return new ItemNetwork(world, null, null, 6, null);
            }

            @NotNull
            public ItemNetworkState getNetworkState(@NotNull class_3218 world) {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                return AccessorextensionsKt.getItemNetworkState(world);
            }
        };

        public Type(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public abstract NetworkFactory<T> getFactory();

        @NotNull
        public abstract T createEmpty(@NotNull class_3218 var1);

        @NotNull
        public abstract NetworkState<T> getNetworkState(@NotNull class_3218 var1);

        @Nullable
        public ClientNetworkInfo<?> createClientNetworkInfo(@NotNull class_3218 world) {
            ClientServoNetworkInfo clientServoNetworkInfo;
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            NetworkState<T> state = this.getNetworkState(world);
            if (!(state instanceof ServoNetworkState)) {
                return null;
            }
            ClientServoNetworkInfo it = clientServoNetworkInfo = new ClientServoNetworkInfo();
            boolean bl = false;
            Map $this$forEach$iv = (Map)((ServoNetworkState)state).getEndpointData();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl2 = false;
                Long pos = (Long)entry.getKey();
                Object2ObjectOpenHashMap data = (Object2ObjectOpenHashMap)entry.getValue();
                Intrinsics.checkNotNull((Object)pos);
                ClientServoNodeInfo info = new ClientServoNodeInfo(pos, (Object2ObjectOpenHashMap<class_2350, EndpointData.Type>)new Object2ObjectOpenHashMap());
                Intrinsics.checkNotNull((Object)data);
                Map $this$forEach$iv2 = (Map)data;
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv2;
                    Map.Entry entry2 = element$iv2 = iterator2.next();
                    boolean bl3 = false;
                    class_2350 dir = (class_2350)entry2.getKey();
                    EndpointData endpointData = (EndpointData)entry2.getValue();
                    ((Map)info.getServos()).put(dir, endpointData.getType());
                }
                ((Map)it.getPipes()).put(pos, info);
            }
            return clientServoNetworkInfo;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00068\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u000b\u001a\u0004\b\u0010\u0010\rR\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u0013\u0010\r\u00a8\u0006\u0014"}, d2={"Lme/steven/indrev/networks/Network$Type$Companion;", "", "<init>", "()V", "", "string", "Lme/steven/indrev/networks/Network$Type;", "valueOf", "(Ljava/lang/String;)Lme/steven/indrev/networks/Network$Type;", "Lme/steven/indrev/networks/energy/EnergyNetwork;", "ENERGY", "Lme/steven/indrev/networks/Network$Type;", "getENERGY", "()Lme/steven/indrev/networks/Network$Type;", "Lme/steven/indrev/networks/fluid/FluidNetwork;", "FLUID", "getFLUID", "Lme/steven/indrev/networks/item/ItemNetwork;", "ITEM", "getITEM", "indrev"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Type<EnergyNetwork> getENERGY() {
                return ENERGY;
            }

            @NotNull
            public final Type<FluidNetwork> getFLUID() {
                return FLUID;
            }

            @NotNull
            public final Type<ItemNetwork> getITEM() {
                return ITEM;
            }

            @NotNull
            public final Type<?> valueOf(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"string");
                return switch (string) {
                    case "indrev_networks" -> this.getENERGY();
                    case "indrev_fluid_networks" -> this.getFLUID();
                    case "indrev_item_networks" -> this.getITEM();
                    default -> throw new IllegalArgumentException("Unknown network type " + string);
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

