/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.networks.item;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import me.steven.indrev.api.machines.Tier;
import me.steven.indrev.blocks.machine.pipes.ItemPipeBlock;
import me.steven.indrev.config.IRConfig;
import me.steven.indrev.networks.EndpointData;
import me.steven.indrev.networks.Network;
import me.steven.indrev.networks.NetworkState;
import me.steven.indrev.networks.Node;
import me.steven.indrev.networks.ServoNetworkState;
import me.steven.indrev.networks.item.ItemFilterData;
import me.steven.indrev.networks.item.ItemNetworkState;
import me.steven.indrev.utils.HelperextensionsKt;
import me.steven.indrev.utils.ItemutilsKt;
import me.steven.indrev.utils.ReusableArrayDeque;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u001a\b\u0002\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J;\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJE\u0010%\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b%\u0010&JE\u0010'\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b'\u0010&R2\u0010+\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001b0)0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0014\u00100\u001a\u00020-8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0016\u00102\u001a\u0002018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103R\"\u00105\u001a\u0002048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b5\u00106\u001a\u0004\b7\u00108\"\u0004\b9\u0010:\u00a8\u0006;"}, d2={"Lme/steven/indrev/networks/item/ItemNetwork;", "Lme/steven/indrev/networks/Network;", "Lnet/minecraft/class_3218;", "world", "", "Lnet/minecraft/class_2338;", "pipes", "", "Ljava/util/EnumSet;", "Lnet/minecraft/class_2350;", "containers", "<init>", "(Lnet/minecraft/class_3218;Ljava/util/Set;Ljava/util/Map;)V", "Lnet/minecraft/class_2248;", "block", "blockPos", "", "appendPipe", "(Lnet/minecraft/class_2248;Lnet/minecraft/class_2338;)V", "pos", "Lme/steven/indrev/networks/EndpointData;", "data", "Lme/steven/indrev/networks/item/ItemFilterData;", "filter", "", "Lme/steven/indrev/networks/Node;", "nodes", "Lme/steven/indrev/utils/ReusableArrayDeque;", "getQueue", "(Lnet/minecraft/class_2338;Lme/steven/indrev/networks/EndpointData;Lme/steven/indrev/networks/item/ItemFilterData;Ljava/util/List;)Lme/steven/indrev/utils/ReusableArrayDeque;", "tick", "(Lnet/minecraft/class_3218;)V", "dir", "queue", "Lme/steven/indrev/networks/item/ItemNetworkState;", "state", "filterData", "tickOutput", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_2350;Lme/steven/indrev/utils/ReusableArrayDeque;Lme/steven/indrev/networks/item/ItemNetworkState;Lme/steven/indrev/networks/EndpointData;Lme/steven/indrev/networks/item/ItemFilterData;)V", "tickRetriever", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;", "Ljava/util/EnumMap;", "Lme/steven/indrev/networks/EndpointData$Mode;", "deques", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;", "", "getMaxCableTransfer", "()J", "maxCableTransfer", "", "ticks", "I", "Lme/steven/indrev/api/machines/Tier;", "tier", "Lme/steven/indrev/api/machines/Tier;", "getTier", "()Lme/steven/indrev/api/machines/Tier;", "setTier", "(Lme/steven/indrev/api/machines/Tier;)V", "indrev"})
@SourceDebugExtension(value={"SMAP\nItemNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemNetwork.kt\nme/steven/indrev/networks/item/ItemNetwork\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ReusableArrayDeque.kt\nme/steven/indrev/utils/ReusableArrayDeque\n*L\n1#1,150:1\n215#2:151\n216#2:154\n1855#3,2:152\n24#4,2:155\n24#4,2:157\n*S KotlinDebug\n*F\n+ 1 ItemNetwork.kt\nme/steven/indrev/networks/item/ItemNetwork\n*L\n56#1:151\n56#1:154\n60#1:152,2\n87#1:155,2\n92#1:157,2\n*E\n"})
public final class ItemNetwork
extends Network {
    @NotNull
    private Tier tier;
    @NotNull
    private final Object2ObjectOpenHashMap<class_2338, EnumMap<EndpointData.Mode, ReusableArrayDeque<Node>>> deques;
    private int ticks;

    public ItemNetwork(@NotNull class_3218 world, @NotNull Set<class_2338> pipes, @NotNull Map<class_2338, EnumSet<class_2350>> containers) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(pipes, (String)"pipes");
        Intrinsics.checkNotNullParameter(containers, (String)"containers");
        super(Network.Type.Companion.getITEM(), world, pipes, containers);
        this.tier = Tier.MK1;
        this.deques = new Object2ObjectOpenHashMap();
    }

    public /* synthetic */ ItemNetwork(class_3218 class_32182, Set set, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = (Set)new ObjectOpenHashSet();
        }
        if ((n & 4) != 0) {
            map = (Map)new Object2ObjectOpenHashMap();
        }
        this(class_32182, set, map);
    }

    @NotNull
    public final Tier getTier() {
        return this.tier;
    }

    public final void setTier(@NotNull Tier tier) {
        Intrinsics.checkNotNullParameter((Object)((Object)tier), (String)"<set-?>");
        this.tier = tier;
    }

    private final long getMaxCableTransfer() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.tier.ordinal()]) {
            case 1 -> IRConfig.INSTANCE.getCables().getItemPipeMk1();
            case 2 -> IRConfig.INSTANCE.getCables().getItemPipeMk2();
            case 3 -> IRConfig.INSTANCE.getCables().getItemPipeMk3();
            default -> IRConfig.INSTANCE.getCables().getItemPipeMk4();
        };
    }

    @Override
    public void tick(@NotNull class_3218 world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        int n = this.ticks;
        this.ticks = n + 1;
        if (this.ticks % 20 != 0) {
            return;
        }
        NetworkState<ItemNetwork> networkState = Network.Type.Companion.getITEM().getNetworkState(world);
        Intrinsics.checkNotNull(networkState, (String)"null cannot be cast to non-null type me.steven.indrev.networks.item.ItemNetworkState");
        ItemNetworkState state = (ItemNetworkState)networkState;
        if (this.getContainers().isEmpty()) {
            return;
        }
        if (this.getQueue().isEmpty()) {
            this.buildQueue();
        }
        if (!((Map)this.getQueue()).isEmpty()) {
            Map<class_2338, EnumSet<class_2350>> $this$forEach$iv = this.getContainers();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<class_2338, EnumSet<class_2350>>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                List list;
                Map.Entry<class_2338, EnumSet<class_2350>> element$iv;
                Map.Entry<class_2338, EnumSet<class_2350>> entry = element$iv = iterator.next();
                boolean bl = false;
                class_2338 pos = entry.getKey();
                EnumSet<class_2350> directions = entry.getValue();
                if (!HelperextensionsKt.isLoaded((class_1937)world, pos) || (List)this.getQueue().get((Object)pos) == null) continue;
                Intrinsics.checkNotNull((Object)list);
                List nodes = list;
                Iterable $this$forEach$iv2 = directions;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    EndpointData data;
                    class_2350 dir = (class_2350)element$iv2;
                    boolean bl2 = false;
                    ServoNetworkState servoNetworkState = state;
                    class_2338 class_23382 = pos.method_10093(dir);
                    Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"offset(...)");
                    class_2350 class_23502 = dir.method_10153();
                    Intrinsics.checkNotNullExpressionValue((Object)class_23502, (String)"getOpposite(...)");
                    if (ServoNetworkState.getEndpointData$default(servoNetworkState, class_23382, class_23502, false, 4, null) == null) continue;
                    class_2338 class_23383 = pos.method_10093(dir);
                    Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"offset(...)");
                    class_2350 class_23503 = dir.method_10153();
                    Intrinsics.checkNotNullExpressionValue((Object)class_23503, (String)"getOpposite(...)");
                    ItemFilterData filterData = ItemNetworkState.getFilterData$default(state, class_23383, class_23503, false, 4, null);
                    if (data.getType() == EndpointData.Type.INPUT) continue;
                    ReusableArrayDeque<Node> deque = this.getQueue(pos, data, filterData, nodes);
                    if (data.getType() == EndpointData.Type.OUTPUT) {
                        Intrinsics.checkNotNull((Object)dir);
                        this.tickOutput(pos, dir, deque, state, data, filterData);
                    } else if (data.getType() == EndpointData.Type.RETRIEVER) {
                        Intrinsics.checkNotNull((Object)dir);
                        this.tickRetriever(pos, dir, deque, state, data, filterData);
                    }
                    deque.resetHead();
                }
            }
        }
    }

    private final ReusableArrayDeque<Node> getQueue(class_2338 pos, EndpointData data, ItemFilterData filter2, List<Node> nodes) {
        ReusableArrayDeque<Node> this_$iv;
        boolean $i$f$apply;
        Function1<Object[], Unit> transform$iv;
        ReusableArrayDeque<Node> queue;
        EnumMap queuesByNodes = (EnumMap)this.deques.get((Object)pos);
        if (queuesByNodes == null) {
            queuesByNodes = new EnumMap(EndpointData.Mode.class);
            ((Map)this.deques).put(pos, queuesByNodes);
        }
        if ((queue = (ReusableArrayDeque<Node>)((Object)queuesByNodes.get((Object)data.getMode()))) == null) {
            ReusableArrayDeque<Node> reusableArrayDeque = queue = new ReusableArrayDeque<Node>((Collection)nodes);
            EndpointData.Mode mode = data.getMode();
            Intrinsics.checkNotNull((Object)((Object)mode));
            transform$iv = mode.getItemSorter(this.getWorld(), data.getType(), (Function1<? super ItemVariant, Boolean>)((Function1)new Function1<ItemVariant, Boolean>(filter2){
                final /* synthetic */ ItemFilterData $filter;
                {
                    this.$filter = $filter;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ItemVariant it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$filter.matches(it);
                }
            }));
            $i$f$apply = false;
            transform$iv.invoke((Object)this_$iv.getElementData());
            ((Map)queuesByNodes).put(data.getMode(), queue);
        }
        if (data.getMode() == EndpointData.Mode.ROUND_ROBIN || data.getMode() == EndpointData.Mode.RANDOM) {
            this_$iv = queue;
            EndpointData.Mode mode = data.getMode();
            Intrinsics.checkNotNull((Object)((Object)mode));
            transform$iv = mode.getItemSorter(this.getWorld(), data.getType(), (Function1<? super ItemVariant, Boolean>)((Function1)new Function1<ItemVariant, Boolean>(filter2){
                final /* synthetic */ ItemFilterData $filter;
                {
                    this.$filter = $filter;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ItemVariant it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$filter.matches(it);
                }
            }));
            $i$f$apply = false;
            transform$iv.invoke((Object)this_$iv.getElementData());
        }
        return queue;
    }

    private final void tickOutput(class_2338 pos, class_2350 dir, ReusableArrayDeque<Node> queue, ItemNetworkState state, EndpointData data, ItemFilterData filterData) {
        Storage<ItemVariant> extractable = ItemutilsKt.itemStorageOf(this.getWorld(), pos, dir);
        Ref.LongRef remaining = new Ref.LongRef();
        remaining.element = this.getMaxCableTransfer();
        while (!((Collection)((Object)queue)).isEmpty() && remaining.element > 0L) {
            Node node = queue.removeFirst();
            class_2338 targetPos = node.component2();
            class_2350 targetDir = node.component4();
            if (!HelperextensionsKt.isLoaded((class_1937)this.getWorld(), targetPos)) continue;
            ServoNetworkState servoNetworkState = state;
            class_2338 class_23382 = targetPos.method_10093(targetDir);
            Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"offset(...)");
            class_2350 class_23502 = targetDir.method_10153();
            Intrinsics.checkNotNullExpressionValue((Object)class_23502, (String)"getOpposite(...)");
            EndpointData targetData = ServoNetworkState.getEndpointData$default(servoNetworkState, class_23382, class_23502, false, 4, null);
            boolean input = targetData == null || targetData.getType() == EndpointData.Type.INPUT;
            if (!input) continue;
            class_2338 class_23383 = targetPos.method_10093(targetDir);
            Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"offset(...)");
            class_2350 class_23503 = targetDir.method_10153();
            Intrinsics.checkNotNullExpressionValue((Object)class_23503, (String)"getOpposite(...)");
            ItemFilterData targetFilterData = ItemNetworkState.getFilterData$default(state, class_23383, class_23503, false, 4, null);
            ItemNetwork.tickOutput$doMove(this, targetPos, targetDir, extractable, remaining, filterData, targetFilterData);
        }
    }

    private final void tickRetriever(class_2338 pos, class_2350 dir, ReusableArrayDeque<Node> queue, ItemNetworkState state, EndpointData data, ItemFilterData filterData) {
        Storage<ItemVariant> insertable = ItemutilsKt.itemStorageOf(this.getWorld(), pos, dir);
        Ref.LongRef remaining = new Ref.LongRef();
        remaining.element = this.getMaxCableTransfer();
        while (!((Collection)((Object)queue)).isEmpty() && remaining.element > 0L) {
            EndpointData targetData;
            Node node = queue.removeFirst();
            class_2338 targetPos = node.component2();
            class_2350 targetDir = node.component4();
            if (!HelperextensionsKt.isLoaded((class_1937)this.getWorld(), targetPos)) continue;
            ServoNetworkState servoNetworkState = state;
            class_2338 class_23382 = targetPos.method_10093(targetDir);
            Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"offset(...)");
            class_2350 class_23502 = targetDir.method_10153();
            Intrinsics.checkNotNullExpressionValue((Object)class_23502, (String)"getOpposite(...)");
            EndpointData endpointData = targetData = ServoNetworkState.getEndpointData$default(servoNetworkState, class_23382, class_23502, false, 4, null);
            boolean isRetriever = (endpointData != null ? endpointData.getType() : null) == EndpointData.Type.RETRIEVER;
            if (isRetriever) continue;
            class_2338 class_23383 = targetPos.method_10093(targetDir);
            Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"offset(...)");
            class_2350 class_23503 = targetDir.method_10153();
            Intrinsics.checkNotNullExpressionValue((Object)class_23503, (String)"getOpposite(...)");
            ItemFilterData targetFilterData = ItemNetworkState.getFilterData$default(state, class_23383, class_23503, false, 4, null);
            ItemNetwork.tickRetriever$doMove$4(this, targetPos, targetDir, insertable, remaining, filterData, targetFilterData);
        }
    }

    @Override
    public void appendPipe(@NotNull class_2248 block, @NotNull class_2338 blockPos) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        ItemPipeBlock itemPipeBlock = block instanceof ItemPipeBlock ? (ItemPipeBlock)block : null;
        if (itemPipeBlock == null) {
            return;
        }
        ItemPipeBlock cable = itemPipeBlock;
        this.tier = cable.getTier();
        super.appendPipe(block, blockPos);
    }

    private static final boolean tickOutput$doMove$lambda$2(ItemFilterData $filterData, ItemFilterData $targetFilterData, ItemVariant it) {
        Intrinsics.checkNotNullParameter((Object)$filterData, (String)"$filterData");
        Intrinsics.checkNotNullParameter((Object)$targetFilterData, (String)"$targetFilterData");
        Intrinsics.checkNotNull((Object)it);
        return $filterData.matches(it) && $targetFilterData.matches(it);
    }

    private static final void tickOutput$doMove(ItemNetwork this$0, class_2338 targetPos, class_2350 targetDir, Storage<ItemVariant> extractable, Ref.LongRef remaining, ItemFilterData $filterData, ItemFilterData targetFilterData) {
        Storage<ItemVariant> insertable = ItemutilsKt.itemStorageOf(this$0.getWorld(), targetPos, targetDir);
        long moved = StorageUtil.move(extractable, insertable, arg_0 -> ItemNetwork.tickOutput$doMove$lambda$2($filterData, targetFilterData, arg_0), (long)remaining.element, null);
        remaining.element -= moved;
        if (moved > 0L && remaining.element > 0L) {
            ItemNetwork.tickOutput$doMove(this$0, targetPos, targetDir, extractable, remaining, $filterData, targetFilterData);
        }
    }

    private static final boolean tickRetriever$doMove$4$lambda$3(ItemFilterData $filterData, ItemFilterData $targetFilterData, ItemVariant it) {
        Intrinsics.checkNotNullParameter((Object)$filterData, (String)"$filterData");
        Intrinsics.checkNotNullParameter((Object)$targetFilterData, (String)"$targetFilterData");
        Intrinsics.checkNotNull((Object)it);
        return $filterData.matches(it) && $targetFilterData.matches(it);
    }

    private static final void tickRetriever$doMove$4(ItemNetwork this$0, class_2338 targetPos, class_2350 targetDir, Storage<ItemVariant> insertable, Ref.LongRef remaining, ItemFilterData $filterData, ItemFilterData targetFilterData) {
        Storage<ItemVariant> extractable = ItemutilsKt.itemStorageOf(this$0.getWorld(), targetPos, targetDir);
        long moved = StorageUtil.move(extractable, insertable, arg_0 -> ItemNetwork.tickRetriever$doMove$4$lambda$3($filterData, targetFilterData, arg_0), (long)remaining.element, null);
        remaining.element -= moved;
        if (moved > 0L && remaining.element > 0L) {
            ItemNetwork.tickRetriever$doMove$4(this$0, targetPos, targetDir, insertable, remaining, $filterData, targetFilterData);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Tier.values().length];
            try {
                nArray[Tier.MK1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tier.MK2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tier.MK3.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

