/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.registry;

import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.steven.indrev.api.machines.Tier;
import me.steven.indrev.blocks.machine.DrillHeadModel;
import me.steven.indrev.blocks.models.PumpPipeBakedModel;
import me.steven.indrev.blocks.models.pipes.BasePipeModel;
import me.steven.indrev.blocks.models.pipes.CableModel;
import me.steven.indrev.blocks.models.pipes.FluidPipeModel;
import me.steven.indrev.blocks.models.pipes.ItemPipeModel;
import me.steven.indrev.items.models.TankItemBakedModel;
import me.steven.indrev.registry.MachineRegistry;
import me.steven.indrev.utils.EmptyModel;
import me.steven.indrev.utils.HiddenitemsKt;
import me.steven.indrev.utils.UtilsKt;
import net.fabricmc.fabric.api.client.model.ExtraModelProvider;
import net.fabricmc.fabric.api.client.model.ModelProviderContext;
import net.fabricmc.fabric.api.client.model.ModelVariantProvider;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J#\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0012\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lme/steven/indrev/registry/IRModelManagers;", "Lnet/fabricmc/fabric/api/client/model/ModelVariantProvider;", "Lnet/fabricmc/fabric/api/client/model/ExtraModelProvider;", "<init>", "()V", "Lnet/minecraft/class_1091;", "resourceId", "Lnet/fabricmc/fabric/api/client/model/ModelProviderContext;", "ctx", "Lnet/minecraft/class_1100;", "loadModelVariant", "(Lnet/minecraft/class_1091;Lnet/fabricmc/fabric/api/client/model/ModelProviderContext;)Lnet/minecraft/class_1100;", "Lnet/minecraft/class_3300;", "manager", "Ljava/util/function/Consumer;", "Lnet/minecraft/class_2960;", "out", "", "provideExtraModels", "(Lnet/minecraft/class_3300;Ljava/util/function/Consumer;)V", "", "Lme/steven/indrev/blocks/models/pipes/CableModel;", "CABLE_MODELS", "[Lme/steven/indrev/blocks/models/pipes/CableModel;", "Lme/steven/indrev/blocks/models/pipes/FluidPipeModel;", "FLUID_PIPE_MODELS", "[Lme/steven/indrev/blocks/models/pipes/FluidPipeModel;", "Lme/steven/indrev/blocks/models/pipes/ItemPipeModel;", "ITEM_PIPE_MODELS", "[Lme/steven/indrev/blocks/models/pipes/ItemPipeModel;", "indrev"})
public final class IRModelManagers
implements ModelVariantProvider,
ExtraModelProvider {
    @NotNull
    public static final IRModelManagers INSTANCE = new IRModelManagers();
    @NotNull
    private static final CableModel[] CABLE_MODELS;
    @NotNull
    private static final ItemPipeModel[] ITEM_PIPE_MODELS;
    @NotNull
    private static final FluidPipeModel[] FLUID_PIPE_MODELS;

    private IRModelManagers() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public class_1100 loadModelVariant(@NotNull class_1091 resourceId, @Nullable ModelProviderContext ctx) {
        class_1100 class_11002;
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        if (!Intrinsics.areEqual((Object)resourceId.method_12836(), (Object)"indrev")) {
            return null;
        }
        String path = resourceId.method_12832();
        String variant = resourceId.method_4740();
        class_2960 id = new class_2960(resourceId.method_12836(), resourceId.method_12832());
        if (HiddenitemsKt.hide(id)) {
            class_11002 = EmptyModel.INSTANCE;
            return class_11002;
        } else if (Intrinsics.areEqual((Object)path, (Object)"drill_head")) {
            String string = resourceId.method_4740();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVariant(...)");
            class_11002 = new DrillHeadModel(string);
            return class_11002;
        } else if (Intrinsics.areEqual((Object)path, (Object)"pump_pipe")) {
            class_11002 = new PumpPipeBakedModel();
            return class_11002;
        } else if (Intrinsics.areEqual((Object)path, (Object)"tank") && Intrinsics.areEqual((Object)variant, (Object)"inventory")) {
            class_11002 = new TankItemBakedModel();
            return class_11002;
        } else {
            Intrinsics.checkNotNull((Object)path);
            if (StringsKt.startsWith$default((String)path, (String)"cable_mk", (boolean)false, (int)2, null)) {
                class_11002 = CABLE_MODELS[Integer.parseInt(String.valueOf(StringsKt.last((CharSequence)path))) - 1];
                return class_11002;
            } else if (StringsKt.startsWith$default((String)path, (String)"item_pipe_mk", (boolean)false, (int)2, null)) {
                class_11002 = ITEM_PIPE_MODELS[Integer.parseInt(String.valueOf(StringsKt.last((CharSequence)path))) - 1];
                return class_11002;
            } else if (StringsKt.startsWith$default((String)path, (String)"fluid_pipe_mk", (boolean)false, (int)2, null)) {
                class_11002 = FLUID_PIPE_MODELS[Integer.parseInt(String.valueOf(StringsKt.last((CharSequence)path))) - 1];
                return class_11002;
            } else {
                if (!MachineRegistry.Companion.getMAP().containsKey(id)) return null;
                MachineRegistry machineRegistry = MachineRegistry.Companion.getMAP().get(id);
                Object object = machineRegistry;
                if (machineRegistry == null) return null;
                Map<Tier, Function1<String, class_1100>> map = ((MachineRegistry)object).getModelProvider();
                object = map;
                if (map == null) return null;
                Integer n = StringsKt.toIntOrNull((String)String.valueOf(StringsKt.last((CharSequence)path)));
                Function1 function1 = (Function1)object.get((Object)Tier.values()[(n != null ? n : 4) - 1]);
                object = function1;
                if (function1 == null) return null;
                String string = id.method_12832();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                class_11002 = (class_1100)object.invoke((Object)StringsKt.replace$default((String)string, (String)"_creative", (String)"_mk4", (boolean)false, (int)4, null));
            }
        }
        return class_11002;
    }

    public void provideExtraModels(@Nullable class_3300 manager, @NotNull Consumer<class_2960> out) {
        Intrinsics.checkNotNullParameter(out, (String)"out");
        out.accept((class_2960)new class_1091(UtilsKt.identifier("drill_head"), "stone"));
        out.accept((class_2960)new class_1091(UtilsKt.identifier("drill_head"), "iron"));
        out.accept((class_2960)new class_1091(UtilsKt.identifier("drill_head"), "diamond"));
        out.accept((class_2960)new class_1091(UtilsKt.identifier("drill_head"), "netherite"));
        out.accept((class_2960)new class_1091(UtilsKt.identifier("pump_pipe"), ""));
        out.accept((class_2960)new class_1091(UtilsKt.identifier("composting"), ""));
    }

    static {
        BasePipeModel[] basePipeModelArray = new CableModel[]{new CableModel(Tier.MK1), new CableModel(Tier.MK2), new CableModel(Tier.MK3), new CableModel(Tier.MK4)};
        CABLE_MODELS = basePipeModelArray;
        basePipeModelArray = new ItemPipeModel[]{new ItemPipeModel(Tier.MK1), new ItemPipeModel(Tier.MK2), new ItemPipeModel(Tier.MK3), new ItemPipeModel(Tier.MK4)};
        ITEM_PIPE_MODELS = basePipeModelArray;
        basePipeModelArray = new FluidPipeModel[]{new FluidPipeModel(Tier.MK1), new FluidPipeModel(Tier.MK2), new FluidPipeModel(Tier.MK3), new FluidPipeModel(Tier.MK4)};
        FLUID_PIPE_MODELS = basePipeModelArray;
    }
}

