/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship.abilities;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.world.entity.projectile.Cannon;
import com.talhanation.smallships.world.entity.ship.ContainerShip;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Ability;
import com.talhanation.smallships.world.item.ModItems;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_7265;

public interface Cannonable
extends Ability {
    public float getDefaultCannonPower();

    public CannonPosition getCannonPosition(int var1);

    public byte getMaxCannonPerSide();

    default public void tickCannonShip() {
        for (Cannon cannon : this.getCannons()) {
            cannon.method_5773();
            if (!this.self().isCannonKeyPressed() || !this.canShoot()) continue;
            this.triggerCannon(cannon);
        }
    }

    default public void triggerCannon(Cannon cannon) {
        if (cannon.canShootDirection()) {
            cannon.trigger();
        }
    }

    default public void triggerCannons(class_243 shootVec, double yShootVec, class_1309 driverEntity, double speed, double accuracy) {
        if (this.canShoot()) {
            for (Cannon cannon : this.getCannons()) {
                this.triggerCannonAdvanced(cannon, shootVec, yShootVec, driverEntity, speed, accuracy);
            }
        }
    }

    default public void triggerCannonAdvanced(Cannon cannon, class_243 shootVec, double yShootVec, class_1309 driverEntity, double speed, double accuracy) {
        if (cannon.canShootDirection()) {
            cannon.trigger(shootVec, yShootVec, driverEntity, speed, accuracy);
        }
    }

    default public void defineCannonShipSynchedData() {
        this.self().method_5841().method_12784(Ship.CANNON_POWER, (Object)Float.valueOf(this.getDefaultCannonPower()));
        this.self().method_5841().method_12784(Ship.CANNON_COUNT, (Object)0);
    }

    default public void readCannonShipSaveData(class_2487 tag) {
        if (tag.method_10545("CannonCount")) {
            this.setCannonCount(tag.method_10571("CannonCount"));
            this.updateCannonCount();
        }
    }

    default public void addCannonShipSaveData(class_2487 tag) {
        tag.method_10569("CannonCount", (int)this.getCannonCount());
    }

    default public float getCannonModifier() {
        return (float)this.getCannonCount() * ((Double)SmallShipsConfig.Common.shipGeneralCannonModifier.get()).floatValue();
    }

    default public void updateCannonCount() {
        int cannons = this.getCannonCount();
        this.getCannons().clear();
        for (int i = 0; i < cannons; ++i) {
            CannonPosition cannonPosition = this.getCannonPosition(i);
            if (cannonPosition == null) continue;
            Cannon cannon = new Cannon(this.self(), cannonPosition);
            this.getCannons().add(cannon);
        }
        this.setCannonCount((byte)cannons);
    }

    default public boolean interactCannon(class_1657 player, class_1268 interactionHand) {
        class_1799 item = player.method_5998(interactionHand);
        byte cannonCount = this.getCannonCount();
        if (item.method_7909() == ModItems.CANNON && this.self() instanceof ContainerShip) {
            if (cannonCount >= this.getMaxCannonPerSide() * 2) {
                return false;
            }
            this.setCannonCount((byte)(cannonCount + 1));
            this.self().method_37908().method_43128(player, this.self().method_23317(), this.self().method_23318() + 4.0, this.self().method_23321(), class_3417.field_15191, this.self().method_5634(), 15.0f, 1.5f);
            if (!player.method_7337()) {
                item.method_7934(1);
            }
            this.updateCannonCount();
            return true;
        }
        if (item.method_7909() instanceof class_1743 && cannonCount > 0) {
            this.setCannonCount((byte)(cannonCount - 1));
            this.self().method_5706((class_1935)ModItems.CANNON);
            this.self().method_37908().method_43128(player, this.self().method_23317(), this.self().method_23318() + 4.0, this.self().method_23321(), class_3417.field_15191, this.self().method_5634(), 15.0f, 1.0f);
            return true;
        }
        return false;
    }

    default public boolean canShoot() {
        Ship ship = this.self();
        if (ship instanceof class_7265) {
            class_7265 containerEntity = (class_7265)ship;
            return containerEntity.method_42278().stream().anyMatch(itemStack -> itemStack.method_7909().equals(ModItems.CANNON_BALL));
        }
        ship = this.self().method_5642();
        if (ship instanceof class_1657) {
            class_1657 player = (class_1657)ship;
            return player.method_31548().field_7547.stream().anyMatch(itemStack -> itemStack.method_7909().equals(ModItems.CANNON_BALL));
        }
        return false;
    }

    default public void consumeCannonBall() {
        block2: {
            Object object;
            block3: {
                object = this.self();
                if (!(object instanceof class_7265)) break block3;
                class_7265 containerEntity = (class_7265)object;
                for (class_1799 itemstack : containerEntity.method_42278()) {
                    if (!itemstack.method_31574(ModItems.CANNON_BALL)) continue;
                    itemstack.method_7934(1);
                    break block2;
                }
                break block2;
            }
            object = this.self().method_5642();
            if (!(object instanceof class_1657)) break block2;
            class_1657 player = (class_1657)object;
            for (class_1799 itemstack : player.method_31548().field_7547) {
                if (!itemstack.method_31574(ModItems.CANNON_BALL)) continue;
                itemstack.method_7934(1);
                break;
            }
        }
    }

    default public class_2960 getTextureLocation() {
        return new class_2960("smallships", "textures/entity/cannon/ship_cannon.png");
    }

    default public void setCannonCount(byte x) {
        this.self().method_5841().method_12778(Ship.CANNON_COUNT, (Object)x);
    }

    default public byte getCannonCount() {
        return (Byte)this.self().method_5841().method_12789(Ship.CANNON_COUNT);
    }

    default public List<Cannon> getCannons() {
        return this.self().CANNONS;
    }

    default public void cannonShipDestroyed(class_1937 level, Ship ship) {
        for (int i = 0; i < this.getCannonCount(); ++i) {
            ship.method_5870((class_1935)ModItems.CANNON, 4);
        }
    }

    public static class CannonPosition {
        public final double x;
        public final double y;
        public final double z;
        public final boolean isRightSided;

        public CannonPosition(double x, double y, double z, boolean isRightSided) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.isRightSided = isRightSided;
        }
    }
}

