/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import com.google.gson.JsonObject;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsJsonParser;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.class_1309;

record EventSelectorAcoustics(Map<State, Acoustic> pairs) implements Acoustic
{
    public static EventSelectorAcoustics fromJson(JsonObject json, AcousticsJsonParser context) {
        Object2ObjectOpenHashMap pairs = new Object2ObjectOpenHashMap();
        for (State i : State.values()) {
            String eventName = i.getName();
            if (!json.has(eventName)) continue;
            pairs.put(i, context.solveAcoustic(json.get(eventName)));
        }
        return new EventSelectorAcoustics((Map<State, Acoustic>)pairs);
    }

    @Override
    public void playSound(SoundPlayer player, class_1309 location, State event, Options inputOptions) {
        if (this.pairs.containsKey((Object)event)) {
            this.pairs.get((Object)event).playSound(player, location, event, inputOptions);
        } else if (event.canTransition()) {
            this.playSound(player, location, event.getTransitionDestination(), inputOptions);
        }
    }
}

