/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.util;

import com.google.gson.JsonObject;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.util.MathUtil;
import java.util.Random;
import net.minecraft.class_3518;

public record Period(long min, long max) implements Options
{
    public static final Period ZERO = new Period(0L, 0L);

    public static Period of(long value) {
        return Period.of(value, value);
    }

    public static Period of(long min, long max) {
        return min == max && max == 0L ? ZERO : new Period(min, max);
    }

    public static Period fromJson(JsonObject json, String key) {
        if (json.has(key)) {
            return Period.of(json.get(key).getAsLong());
        }
        return Period.of(class_3518.method_15280((JsonObject)json, (String)(key + "_min"), (long)0L), class_3518.method_15280((JsonObject)json, (String)(key + "_max"), (long)0L));
    }

    public float random(Random rand) {
        return MathUtil.randAB(rand, this.min, this.max);
    }

    public float on(float value) {
        return MathUtil.between(this.min, this.max, value);
    }

    @Override
    public boolean containsKey(String option) {
        return "delay_min".equals(option) || "delay_max".equals(option);
    }

    @Override
    public float get(String option) {
        return "delay_min".equals(option) ? (float)this.min : ("delay_max".equals(option) ? (float)this.max : 0.0f);
    }
}

