/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.variant.WreckerVariant;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTRegistry;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.registry.variant.WreckerVariants;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1379;
import net.minecraft.class_1391;
import net.minecraft.class_1400;
import net.minecraft.class_1480;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5534;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class Wrecker
extends AbstractThievesFish<WreckerVariant> {
    private static final Predicate<class_1309> SELECTORS = livingEntity -> livingEntity.method_6046() != class_1310.field_6292 && livingEntity.method_5799() && livingEntity.method_6102();
    private static final class_2940<WreckerVariant> VARIANT = class_2945.method_12791(Wrecker.class, FOTDataSerializers.WRECKER_VARIANT);
    public static final Consumer<Int2ObjectOpenHashMap<String>> DATA_FIX_MAP = map -> {
        map.defaultReturnValue((Object)"fishofthieves:rose");
        map.put(0, (Object)"fishofthieves:rose");
        map.put(1, (Object)"fishofthieves:sun");
        map.put(2, (Object)"fishofthieves:blackcloud");
        map.put(3, (Object)"fishofthieves:snow");
        map.put(4, (Object)"fishofthieves:moon");
    };

    public Wrecker(class_1299<? extends Wrecker> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(2, (class_1352)new SwimToNearbyWreckageGoal(this, 1.25));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.25, EARTHWORMS_FOOD, false));
        if (FishOfThieves.CONFIG.general.neutralFishBehavior) {
            this.field_6201.method_6277(1, (class_1352)new class_1366((class_1314)this, 2.0, true));
            this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1588.class, 20, true, false, SELECTORS));
            this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, class_1657.class, 50, true, false, SELECTORS));
        }
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)WreckerVariants.ROSE);
    }

    @Override
    public class_2378<WreckerVariant> getRegistry() {
        return FOTRegistry.WRECKER_VARIANT;
    }

    @Override
    public void setVariant(WreckerVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    @Override
    public WreckerVariant getVariant() {
        return (WreckerVariant)this.field_6011.method_12789(VARIANT);
    }

    @Override
    public class_6880<WreckerVariant> getSpawnVariant(boolean fromBucket) {
        return this.getSpawnVariant((class_1309)this, FOTTags.FishVariant.DEFAULT_WRECKER_SPAWNS, WreckerVariants.ROSE, fromBucket);
    }

    @Override
    public Consumer<Int2ObjectOpenHashMap<String>> getDataFix() {
        return DATA_FIX_MAP;
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)FOTItems.WRECKER_BUCKET);
    }

    protected class_3414 method_6002() {
        return FOTSoundEvents.WRECKER_DEATH;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FOTSoundEvents.WRECKER_HURT;
    }

    protected class_3414 method_6457() {
        return FOTSoundEvents.WRECKER_FLOP;
    }

    public class_4048 method_18377(class_4050 pose) {
        return this.isTrophy() ? super.method_18377(pose) : class_4048.method_18385((float)0.275f, (float)0.25f);
    }

    protected float method_18394(class_4050 pose, class_4048 size) {
        return this.isTrophy() ? 0.34f : 0.175f;
    }

    @Override
    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        spawnData = super.method_5943(level, difficulty, reason, spawnData, dataTag);
        if (this.isTrophy()) {
            this.method_5996(class_5134.field_23721).method_6192(2.5);
        }
        return spawnData;
    }

    @Override
    public void setTrophy(boolean trophy) {
        if (trophy) {
            this.method_5996(class_5134.field_23721).method_6192(2.5);
        }
        super.setTrophy(trophy);
    }

    @Override
    public boolean isFood(class_1799 itemStack) {
        return EARTHWORMS_FOOD.method_8093(itemStack);
    }

    public static boolean checkSpawnRules(class_1299<? extends class_1480> entityType, class_5425 level, class_3730 mobSpawnType, class_2338 blockPos, class_5819 random) {
        boolean isWater = level.method_8316(blockPos).method_15767(class_3486.field_15517) && level.method_8320(blockPos).method_27852(class_2246.field_10382);
        return isWater && TerrainUtils.isInFeature(level.method_8410(), blockPos, FOTTags.Structures.WRECKERS_SPAWN_IN);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 3.0).method_26868(class_5134.field_23717, 10.0).method_26868(class_5134.field_23721, 1.5).method_26868(class_5134.field_23722, 0.01);
    }

    static class SwimToNearbyWreckageGoal
    extends class_1379 {
        SwimToNearbyWreckageGoal(Wrecker wrecker, double speedModifier) {
            super((class_1314)wrecker, speedModifier);
        }

        @Nullable
        protected class_243 method_6302() {
            class_2338 wreckagePos = ((class_3218)this.field_6566.method_37908()).method_8487(FOTTags.Structures.WRECKERS_LOCATED, this.field_6566.method_24515(), 32, false);
            if (this.field_6566.method_37908().field_9229.method_43057() < 0.3f) {
                return class_5534.method_31527((class_1314)this.field_6566, (int)10, (int)7);
            }
            if (wreckagePos != null) {
                return class_243.method_24953((class_2382)wreckagePos);
            }
            return super.method_6302();
        }
    }
}

