/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.util;

import com.bawnorton.allthetrims.AllTheTrims;
import com.bawnorton.allthetrims.config.Config;
import dev.architectury.platform.Platform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public abstract class DebugHelper {
    public static void createDebugFile(String directory, String filename, String content) {
        if (!Config.getInstance().debug.booleanValue()) {
            return;
        }
        try {
            Path gameDir = Platform.getGameFolder();
            File debugDir = gameDir.resolve("att-debug").resolve(directory).toFile();
            debugDir.mkdirs();
            File debugFile = debugDir.toPath().resolve(filename.replace("/", "_").replace(":", "_")).toFile();
            debugFile.createNewFile();
            FileWriter writer = new FileWriter(debugFile);
            IOUtils.copy((InputStream)IOUtils.toInputStream((String)content, (String)"UTF-8"), (Writer)writer, (String)"UTF-8");
            ((Writer)writer).close();
        }
        catch (IOException e) {
            AllTheTrims.LOGGER.error("Failed to create debug file: " + filename, e);
        }
    }

    public static void saveLayeredTexture(BufferedImage image, String path) {
        if (!Config.getInstance().debug.booleanValue()) {
            return;
        }
        try {
            Path gameDir = Platform.getGameFolder();
            File debugDir = gameDir.resolve("att-debug").resolve("textures").toFile();
            debugDir.mkdirs();
            File debugFile = debugDir.toPath().resolve(path.replace("/", "_").replace(":", "_")).toFile();
            debugFile.createNewFile();
            ImageIO.write((RenderedImage)image, "png", debugFile);
        }
        catch (IOException e) {
            AllTheTrims.LOGGER.error("Failed to create debug image: " + path, e);
        }
    }

    public static void savePalette(BufferedImage image, String path) {
        if (!Config.getInstance().debug.booleanValue()) {
            return;
        }
        try {
            Path gameDir = Platform.getGameFolder();
            File debugDir = gameDir.resolve("att-debug").resolve("palettes").toFile();
            debugDir.mkdirs();
            File debugFile = debugDir.toPath().resolve(path.replace("/", "_").replace(":", "_")).toFile();
            debugFile.createNewFile();
            ImageIO.write((RenderedImage)image, "png", debugFile);
        }
        catch (IOException e) {
            AllTheTrims.LOGGER.error("Failed to create debug image: " + path, e);
        }
    }

    static {
        try {
            Path gameDir = Platform.getGameFolder();
            File debugDir = gameDir.resolve("att-debug").toFile();
            if (debugDir.exists()) {
                debugDir.delete();
            }
            debugDir.mkdirs();
        }
        catch (Exception e) {
            AllTheTrims.LOGGER.error("Failed to create debug directory", e);
        }
    }
}

