/*
 * Decompiled with CFR 0.152.
 */
package fuzs.blockrunner.world.level.block.data;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.blockrunner.BlockRunner;
import fuzs.blockrunner.init.ModRegistry;
import fuzs.blockrunner.network.S2CBlockSpeedMessage;
import fuzs.blockrunner.world.level.block.data.SpeedHolderValue;
import fuzs.puzzleslib.api.config.v3.json.JsonConfigFileUtil;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_3518;
import net.minecraft.class_4013;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class BlockSpeedManager
implements class_4013 {
    public static final BlockSpeedManager INSTANCE = new BlockSpeedManager();
    public static final String SCHEMA_VERSION = String.valueOf(2);
    public static final UUID SPEED_MODIFIER_BLOCK_SPEED_UUID = UUID.fromString("23237052-61AD-11EB-AE93-0242AC130002");
    private static final String CONFIG_FILE_NAME = "blockrunner.json";
    private static final Set<SpeedHolderValue> DEFAULT_BLOCK_SPEEDS = new SpeedHolderValue.Builder().add((class_6862<class_2248>)class_3481.field_15465, 1.15).add(class_2246.field_10194, 1.35).add(ModRegistry.VERY_SLOW_BLOCKS_BLOCK_TAG, 0.45).add(ModRegistry.SLOW_BLOCKS_BLOCK_TAG, 0.65).add(ModRegistry.SLIGHTLY_SLOW_BLOCKS_BLOCK_TAG, 0.85).add(ModRegistry.SLIGHTLY_QUICK_BLOCKS_BLOCK_TAG, 1.15).add(ModRegistry.QUICK_BLOCKS_BLOCK_TAG, 1.35).add(ModRegistry.VERY_QUICK_BLOCKS_BLOCK_TAG, 1.55).build();
    private final Set<SpeedHolderValue> blockSpeedValues = Sets.newHashSet();
    private Map<class_2248, Double> blockSpeeds;

    public void onPlayerLoggedIn(class_1657 player) {
        if (ModLoaderEnvironment.INSTANCE.isServer()) {
            BlockRunner.NETWORK.sendTo((MessageV2)new S2CBlockSpeedMessage(this.serialize(this.blockSpeedValues)), (class_3222)player);
        }
    }

    public void method_14491(class_3300 resourceManager) {
        JsonConfigFileUtil.getAndLoad((String)CONFIG_FILE_NAME, this::serialize, this::deserialize);
        if (ModLoaderEnvironment.INSTANCE.isServer() && Proxy.INSTANCE.getGameServer() != null) {
            BlockRunner.NETWORK.sendToAll((MessageV2)new S2CBlockSpeedMessage(this.serialize(this.blockSpeedValues)));
        }
    }

    private void dissolve() {
        if (this.blockSpeeds == null) {
            HashMap blockSpeeds = Maps.newHashMap();
            try {
                for (SpeedHolderValue value : this.blockSpeedValues) {
                    value.addValues(blockSpeeds);
                }
            }
            catch (Exception e) {
                BlockRunner.LOGGER.error(e.getMessage());
                blockSpeeds.clear();
            }
            this.blockSpeeds = blockSpeeds;
        }
    }

    public boolean hasBlockSpeed(class_2248 block) {
        this.dissolve();
        return this.blockSpeeds.containsKey(block);
    }

    public double getSpeedFactor(class_2248 block) {
        this.dissolve();
        return this.blockSpeeds.getOrDefault(block, 1.0);
    }

    private void serialize(File jsonFile) {
        JsonConfigFileUtil.saveToFile((File)jsonFile, (JsonElement)this.serialize(DEFAULT_BLOCK_SPEEDS));
    }

    private JsonObject serialize(Set<SpeedHolderValue> values) {
        JsonObject jsonElements = new JsonObject();
        jsonElements.addProperty("schemaVersion", SCHEMA_VERSION);
        for (SpeedHolderValue value : values) {
            value.serialize(jsonElements);
        }
        return jsonElements;
    }

    private void deserialize(FileReader reader) {
        this.deserialize((JsonObject)JsonConfigFileUtil.GSON.fromJson((Reader)reader, JsonObject.class));
    }

    public void deserialize(JsonObject jsonObject) {
        this.blockSpeedValues.clear();
        this.blockSpeeds = null;
        IdentityHashMap blockSpeedValues = Maps.newIdentityHashMap();
        String schemaVersion = class_3518.method_15253((JsonObject)jsonObject, (String)"schema_version", (String)"1");
        if (!schemaVersion.equals(SCHEMA_VERSION)) {
            BlockRunner.LOGGER.warn("Outdated config schema! Config might not work correctly. Current schema is {}.", (Object)SCHEMA_VERSION);
            blockSpeedValues.put(class_3481.field_15465, new SpeedHolderValue.TagValue((class_6862<class_2248>)class_3481.field_15465, 1.15));
            blockSpeedValues.put(class_2246.field_10194, new SpeedHolderValue.BlockValue(class_2246.field_10194, 1.35));
        }
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("schemaVersion")) continue;
            double speedValue = ((JsonElement)entry.getValue()).getAsDouble();
            if (key.startsWith("#")) {
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(key.substring(1)));
                blockSpeedValues.put(tag, new SpeedHolderValue.TagValue((class_6862<class_2248>)tag, speedValue));
                continue;
            }
            class_2960 resourcelocation = class_2960.method_12829((String)key);
            if (resourcelocation != null && class_7923.field_41175.method_10250(resourcelocation)) {
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(resourcelocation);
                blockSpeedValues.put(block, new SpeedHolderValue.BlockValue(block, speedValue));
                continue;
            }
            BlockRunner.LOGGER.warn("Unknown block type '{}', valid types are: {}", resourcelocation != null ? resourcelocation : key, (Object)Joiner.on((String)", ").join((Iterable)class_7923.field_41175.method_10235()));
        }
        this.blockSpeedValues.addAll(blockSpeedValues.values());
    }
}

