/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens.skin;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5244;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_922;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.screens.ETFConfigScreen;
import traben.entity_texture_features.config.screens.skin.ETFConfigScreenSkinToolOutcome;
import traben.entity_texture_features.config.screens.skin.ETFConfigScreenSkinToolPixelSelection;
import traben.entity_texture_features.texture_features.ETFManager;
import traben.entity_texture_features.texture_features.texture_handlers.ETFPlayerTexture;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFConfigScreenSkinTool
extends ETFConfigScreen {
    public Boolean originalEnableBlinking;
    public Integer originalBlinkLength;
    public ETFPlayerTexture thisETFPlayerTexture = null;
    public class_1011 currentEditorSkin = null;
    public boolean flipView = false;
    class_4185 printSkinFileButton = null;
    class_4185 villagerNoseButton = null;
    class_4185 coatButton = null;
    class_4185 coatLengthButton = null;
    class_4185 blinkButton = null;
    class_4185 blinkHeightButton = null;
    class_4185 emissiveButton = null;
    class_4185 emissiveSelectButton = null;
    class_4185 enchantButton = null;
    class_4185 enchantSelectButton = null;
    class_4185 capeButton = null;
    class_4185 transparencyButton = null;

    protected ETFConfigScreenSkinTool(class_437 parent) {
        super(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_features.title"), parent);
    }

    public static int getPixelColour(int choice) {
        switch (choice) {
            case 1: {
                return -65281;
            }
            case 2: {
                return -256;
            }
            case 3: {
                return -16776961;
            }
            case 4: {
                return -16711936;
            }
            case 5: {
                return -16760705;
            }
            case 6: {
                return -65536;
            }
            case 7: {
                return -16744449;
            }
            case 8: {
                return -14483457;
            }
        }
        return 0;
    }

    private void onExit() {
        ETFClientCommon.ETFConfigData.enableBlinking = this.originalEnableBlinking;
        ETFClientCommon.ETFConfigData.blinkLength = this.originalBlinkLength;
        if (class_310.method_1551().field_1724 != null) {
            ETFManager.getInstance().PLAYER_TEXTURE_MAP.removeEntryOnly(class_310.method_1551().field_1724.method_5667());
            ETFManager.getInstance().ENTITY_BLINK_TIME.put((Object)class_310.method_1551().field_1724.method_5667(), 0L);
        }
        this.thisETFPlayerTexture = null;
    }

    @Override
    public void method_25419() {
        this.onExit();
        super.method_25419();
    }

    protected void method_25426() {
        super.method_25426();
        if (this.originalEnableBlinking == null && this.originalBlinkLength == null) {
            this.originalEnableBlinking = ETFClientCommon.ETFConfigData.enableBlinking;
            this.originalBlinkLength = ETFClientCommon.ETFConfigData.blinkLength;
            ETFClientCommon.ETFConfigData.blinkLength = 10;
            ETFClientCommon.ETFConfigData.enableBlinking = true;
        }
        if (class_310.method_1551().field_1724 != null && this.thisETFPlayerTexture == null) {
            this.thisETFPlayerTexture = ETFManager.getInstance().PLAYER_TEXTURE_MAP.get(class_310.method_1551().field_1724.method_5667());
            if (this.thisETFPlayerTexture == null) {
                ETFPlayerTexture etfPlayerTexture = new ETFPlayerTexture();
                ETFManager.getInstance().PLAYER_TEXTURE_MAP.put(class_310.method_1551().field_1724.method_5667(), etfPlayerTexture);
                this.thisETFPlayerTexture = etfPlayerTexture;
            }
        }
        if (this.currentEditorSkin == null) {
            this.currentEditorSkin = ETFUtils2.emptyNativeImage(64, 64);
            class_1011 skin = ETFPlayerTexture.clientPlayerOriginalSkinImageForTool;
            if (skin != null) {
                this.currentEditorSkin.method_4317(ETFPlayerTexture.clientPlayerOriginalSkinImageForTool);
            } else {
                this.onExit();
                ETFUtils2.logError("could not load tool as skin could not be loaded");
                Objects.requireNonNull(this.field_22787).method_1507(this.parent);
            }
        }
        this.method_37063((class_364)this.getETFButton(this.field_22789 / 2 - 210, (int)((double)this.field_22790 * 0.9), 200, 20, class_5244.field_24335, button -> {
            this.onExit();
            Objects.requireNonNull(this.field_22787).method_1507(this.parent);
        }));
        this.method_37063((class_364)this.getETFButton((int)((double)this.field_22789 * 0.024), (int)((double)this.field_22790 * 0.2), 20, 20, class_2561.method_30163((String)"\u27f3"), button -> {
            this.flipView = !this.flipView;
        }));
        this.printSkinFileButton = this.getETFButton(this.field_22789 / 2 + 10, (int)((double)this.field_22790 * 0.9), 200, 20, ETFVersionDifferenceHandler.getTextFromTranslation("selectWorld.edit.save"), button -> {
            boolean result = false;
            if (class_310.method_1551().field_1724 != null) {
                result = this.printPlayerSkinCopy();
            }
            this.onExit();
            Objects.requireNonNull(this.field_22787).method_1507((class_437)new ETFConfigScreenSkinToolOutcome(this.parent, result, this.currentEditorSkin));
        });
        this.method_37063((class_364)this.printSkinFileButton);
        if (class_310.method_1551().field_1724 != null) {
            this.method_37063((class_364)this.getETFButton((int)((double)this.field_22789 * 0.25), (int)((double)this.field_22790 * 0.2), (int)((double)this.field_22789 * 0.42), 20, this.thisETFPlayerTexture.hasFeatures ? ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.remove_features") : ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.add_features"), button -> {
                if (this.thisETFPlayerTexture.hasFeatures) {
                    this.applyExistingOverlayToSkin(new class_2960("entity_texture_features:textures/skin_feature_remove.png"));
                } else {
                    this.applyExistingOverlayToSkin(new class_2960("entity_texture_features:textures/skin_feature_printout.png"));
                }
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.method_25355(this.thisETFPlayerTexture.hasFeatures ? ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.remove_features") : ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.add_features"));
                this.updateButtons();
            }));
            this.villagerNoseButton = this.getETFButton((int)((double)this.field_22789 * 0.25), (int)((double)this.field_22790 * 0.7), (int)((double)this.field_22789 * 0.2), 20, class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.button").getString() + this.thisETFPlayerTexture.noseType.getButtonText().getString())), button -> {
                int colour = this.thisETFPlayerTexture.noseType.next().getNosePixelColour();
                this.currentEditorSkin.method_4305(53, 17, colour);
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.method_25355(class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.button").getString() + this.thisETFPlayerTexture.noseType.getButtonText().getString())));
            }, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.tooltip"));
            this.capeButton = this.getETFButton((int)((double)this.field_22789 * 0.47), (int)((double)this.field_22790 * 0.7), (int)((double)this.field_22789 * 0.2), 20, class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.cape.button").getString() + this.thisETFPlayerTexture.capeType.getButtonText().getString())), button -> {
                CapeType cape = this.thisETFPlayerTexture.capeType.next();
                button.method_25355(class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.cape.button").getString() + cape.getButtonText().getString())));
                this.currentEditorSkin.method_4305(53, 16, cape.getCapePixelColour());
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                this.updateButtons();
            }, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.cape.tooltip"));
            this.transparencyButton = this.getETFButton((int)((double)this.field_22789 * 0.695), (int)((double)this.field_22790 * 0.7), (int)((double)this.field_22789 * 0.275), 20, class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.transparency.button").getString() + ETFConfigScreenSkinTool.booleanAsOnOff(!this.thisETFPlayerTexture.wasForcedSolid))), button -> {
                button.method_25355(class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.transparency.button").getString() + ETFConfigScreenSkinTool.booleanAsOnOff(this.thisETFPlayerTexture.wasForcedSolid))));
                this.currentEditorSkin.method_4305(53, 18, ETFConfigScreenSkinTool.getPixelColour(this.thisETFPlayerTexture.wasForcedSolid ? 0 : 1));
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                this.updateButtons();
            }, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.transparency.tooltip"));
            this.coatButton = this.getETFButton((int)((double)this.field_22789 * 0.25), (int)((double)this.field_22790 * 0.3), (int)((double)this.field_22789 * 0.42), 20, CoatStyle.get(this.thisETFPlayerTexture.coatStyle).getTitle(), button -> {
                CoatStyle coat = CoatStyle.get(this.thisETFPlayerTexture.coatStyle).next();
                button.method_25355(coat.getTitle());
                this.currentEditorSkin.method_4305(52, 17, coat.getCoatPixelColour());
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                this.updateButtons();
            }, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.tooltip"));
            this.coatLengthButton = this.getETFButton((int)((double)this.field_22789 * 0.695), (int)((double)this.field_22790 * 0.3), (int)((double)this.field_22789 * 0.275), 20, class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_length.title").getString() + this.thisETFPlayerTexture.coatLength)), button -> {
                int lengthChoice = this.thisETFPlayerTexture.coatLength == 8 ? 1 : this.thisETFPlayerTexture.coatLength + 1;
                this.currentEditorSkin.method_4305(52, 18, ETFConfigScreenSkinTool.getPixelColour(lengthChoice));
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.method_25355(class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_length.title").getString() + this.thisETFPlayerTexture.coatLength)));
            }, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_length.tooltip"));
            this.blinkButton = this.getETFButton((int)((double)this.field_22789 * 0.25), (int)((double)this.field_22790 * 0.4), (int)((double)this.field_22789 * 0.42), 20, BlinkType.get(this.thisETFPlayerTexture.blinkType).getTitle(), button -> {
                BlinkType blink = BlinkType.get(this.thisETFPlayerTexture.blinkType).next();
                button.method_25355(blink.getTitle());
                if (blink != BlinkType.NONE && blink != BlinkType.WHOLE_FACE_TWO && blink != BlinkType.WHOLE_FACE) {
                    this.currentEditorSkin.method_4305(52, 19, ETFConfigScreenSkinTool.getPixelColour(0));
                } else if (this.currentEditorSkin.method_4315(52, 19) > blink.getMaxEyePixelHeight()) {
                    this.currentEditorSkin.method_4305(52, 19, ETFConfigScreenSkinTool.getPixelColour(blink.getMaxEyePixelHeight()));
                }
                this.currentEditorSkin.method_4305(52, 16, blink.getBlinkPixelColour());
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                this.updateButtons();
            }, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.tooltip"));
            this.blinkHeightButton = this.getETFButton((int)((double)this.field_22789 * 0.695), (int)((double)this.field_22790 * 0.4), (int)((double)this.field_22789 * 0.275), 20, class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_height.title").getString() + this.thisETFPlayerTexture.blinkHeight)), button -> {
                int heightChoice = this.thisETFPlayerTexture.blinkHeight == BlinkType.get(this.thisETFPlayerTexture.blinkType).getMaxEyePixelHeight() ? 1 : this.thisETFPlayerTexture.blinkHeight + 1;
                this.currentEditorSkin.method_4305(52, 19, ETFConfigScreenSkinTool.getPixelColour(heightChoice));
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.method_25355(class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_height.title").getString() + this.thisETFPlayerTexture.blinkHeight)));
            }, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_height.tooltip"));
            this.emissiveButton = this.getETFButton((int)((double)this.field_22789 * 0.25), (int)((double)this.field_22790 * 0.5), (int)((double)this.field_22789 * 0.42), 20, class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.emissive_enable.button").getString() + (this.currentEditorSkin.method_4315(1, 17) == ETFConfigScreenSkinTool.getPixelColour(1) ? class_5244.field_24332 : class_5244.field_24333).getString())), button -> {
                if (this.thisETFPlayerTexture.hasEmissives) {
                    this.currentEditorSkin.method_4305(1, 17, 0);
                } else {
                    this.currentEditorSkin.method_4305(1, 17, ETFConfigScreenSkinTool.getPixelColour(1));
                }
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.method_25355(class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.emissive_enable.button").getString() + (this.currentEditorSkin.method_4315(1, 17) == ETFConfigScreenSkinTool.getPixelColour(1) ? class_5244.field_24332 : class_5244.field_24333).getString())));
                this.updateButtons();
            }, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.emissive_enable.tooltip"));
            this.emissiveSelectButton = this.getETFButton((int)((double)this.field_22789 * 0.695), (int)((double)this.field_22790 * 0.5), (int)((double)this.field_22789 * 0.275), 20, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.emissive_select.button"), button -> Objects.requireNonNull(this.field_22787).method_1507((class_437)new ETFConfigScreenSkinToolPixelSelection(this, ETFConfigScreenSkinToolPixelSelection.SelectionMode.EMISSIVE)));
            this.enchantButton = this.getETFButton((int)((double)this.field_22789 * 0.25), (int)((double)this.field_22790 * 0.6), (int)((double)this.field_22789 * 0.42), 20, class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.enchant_enable.button").getString() + (this.currentEditorSkin.method_4315(1, 18) == ETFConfigScreenSkinTool.getPixelColour(2) ? class_5244.field_24332 : class_5244.field_24333).getString())), button -> {
                if (this.thisETFPlayerTexture.hasEnchant) {
                    this.currentEditorSkin.method_4305(1, 18, 0);
                } else {
                    this.currentEditorSkin.method_4305(1, 18, ETFConfigScreenSkinTool.getPixelColour(2));
                }
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.method_25355(class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.enchant_enable.button").getString() + (this.currentEditorSkin.method_4315(1, 18) == ETFConfigScreenSkinTool.getPixelColour(2) ? class_5244.field_24332 : class_5244.field_24333).getString())));
                this.updateButtons();
            }, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.enchant_enable.tooltip"));
            this.enchantSelectButton = this.getETFButton((int)((double)this.field_22789 * 0.695), (int)((double)this.field_22790 * 0.6), (int)((double)this.field_22789 * 0.275), 20, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.enchant_select.button"), button -> Objects.requireNonNull(this.field_22787).method_1507((class_437)new ETFConfigScreenSkinToolPixelSelection(this, ETFConfigScreenSkinToolPixelSelection.SelectionMode.ENCHANTED)));
            this.updateButtons();
            this.method_37063((class_364)this.villagerNoseButton);
            this.method_37063((class_364)this.coatButton);
            this.method_37063((class_364)this.coatLengthButton);
            this.method_37063((class_364)this.blinkButton);
            this.method_37063((class_364)this.blinkHeightButton);
            this.method_37063((class_364)this.emissiveButton);
            this.method_37063((class_364)this.emissiveSelectButton);
            this.method_37063((class_364)this.enchantButton);
            this.method_37063((class_364)this.enchantSelectButton);
            this.method_37063((class_364)this.capeButton);
            this.method_37063((class_364)this.transparencyButton);
        }
    }

    private void updateButtons() {
        boolean activeFeatures = this.thisETFPlayerTexture.hasFeatures;
        if (this.villagerNoseButton != null) {
            this.villagerNoseButton.field_22763 = activeFeatures;
            this.villagerNoseButton.method_25355(class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.button").getString() + this.thisETFPlayerTexture.noseType.getButtonText().getString())));
        }
        if (this.coatButton != null) {
            this.coatButton.field_22763 = activeFeatures;
            this.coatButton.method_25355(CoatStyle.get(this.thisETFPlayerTexture.coatStyle).getTitle());
        }
        if (this.coatLengthButton != null) {
            this.coatLengthButton.field_22763 = activeFeatures && CoatStyle.get(this.thisETFPlayerTexture.coatStyle) != CoatStyle.NONE;
            this.coatLengthButton.method_25355(class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_length.title").getString() + this.thisETFPlayerTexture.coatLength)));
        }
        if (this.blinkButton != null) {
            this.blinkButton.field_22763 = activeFeatures;
            this.blinkButton.method_25355(BlinkType.get(this.thisETFPlayerTexture.blinkType).getTitle());
        }
        if (this.blinkHeightButton != null) {
            this.blinkHeightButton.field_22763 = activeFeatures && BlinkType.get(this.thisETFPlayerTexture.blinkType) != BlinkType.NONE && BlinkType.get(this.thisETFPlayerTexture.blinkType) != BlinkType.WHOLE_FACE_TWO && BlinkType.get(this.thisETFPlayerTexture.blinkType) != BlinkType.WHOLE_FACE;
            this.blinkHeightButton.method_25355(class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_height.title").getString() + this.thisETFPlayerTexture.blinkHeight)));
        }
        if (this.emissiveButton != null) {
            this.emissiveButton.field_22763 = activeFeatures;
            this.emissiveButton.method_25355(class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.emissive_enable.button").getString() + (this.currentEditorSkin.method_4315(1, 17) == ETFConfigScreenSkinTool.getPixelColour(1) ? class_5244.field_24332 : class_5244.field_24333).getString())));
        }
        if (this.emissiveSelectButton != null) {
            boolean bl = this.emissiveSelectButton.field_22763 = activeFeatures && this.currentEditorSkin.method_4315(1, 17) == ETFConfigScreenSkinTool.getPixelColour(1);
        }
        if (this.enchantButton != null) {
            this.enchantButton.field_22763 = activeFeatures;
            this.enchantButton.method_25355(class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.enchant_enable.button").getString() + (this.currentEditorSkin.method_4315(1, 18) == ETFConfigScreenSkinTool.getPixelColour(2) ? class_5244.field_24332 : class_5244.field_24333).getString())));
        }
        if (this.enchantSelectButton != null) {
            boolean bl = this.enchantSelectButton.field_22763 = activeFeatures && this.currentEditorSkin.method_4315(1, 18) == ETFConfigScreenSkinTool.getPixelColour(2);
        }
        if (this.capeButton != null) {
            this.capeButton.field_22763 = activeFeatures;
            this.capeButton.method_25355(class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.cape.button").getString() + this.thisETFPlayerTexture.capeType.getButtonText().getString())));
        }
        if (this.transparencyButton != null) {
            this.transparencyButton.field_22763 = activeFeatures;
            this.transparencyButton.method_25355(class_2561.method_30163((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.transparency.button").getString() + ETFConfigScreenSkinTool.booleanAsOnOff(!this.thisETFPlayerTexture.wasForcedSolid))));
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (class_310.method_1551() != null) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                int blinkModifierBySystemTimeInTicks = (int)(System.currentTimeMillis() / 50L % (long)(30 + ETFClientCommon.ETFConfigData.blinkLength * 2));
                ETFManager.getInstance().ENTITY_BLINK_TIME.put((Object)player.method_5667(), player.method_37908().method_8510() + (long)blinkModifierBySystemTimeInTicks - (long)(15 + ETFClientCommon.ETFConfigData.blinkLength));
                int height = (int)((double)this.field_22790 * 0.75);
                int playerX = (int)((double)this.field_22789 * 0.14);
                this.drawEntity(playerX, height, (int)((double)this.field_22790 * 0.3), -mouseX + playerX, (float)((double)(-mouseY) + (double)this.field_22790 * 0.3), (class_1309)player);
            } else {
                context.method_27535(this.field_22793, class_2561.method_30163((String)"Player is null for some reason!"), this.field_22789 / 7, (int)((double)this.field_22790 * 0.4), 0xFFFFFF);
                context.method_27535(this.field_22793, class_2561.method_30163((String)"Cannot load player to render!"), this.field_22789 / 7, (int)((double)this.field_22790 * 0.45), 0xFFFFFF);
            }
        }
        context.method_27535(this.field_22793, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.crouch_message"), this.field_22789 / 40, (int)((double)this.field_22790 * 0.8), 0x555555);
        context.method_27535(this.field_22793, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_message"), this.field_22789 / 40, (int)((double)this.field_22790 * 0.1), 0x555555);
    }

    public void applyExistingOverlayToSkin(class_2960 overlayTexture) {
        if (ETFVersionDifferenceHandler.isFabric() == ETFVersionDifferenceHandler.isThisModLoaded("fabric")) {
            class_1011 skinFeatureImage = ETFUtils2.getNativeImageElseNull(overlayTexture);
            try {
                for (int x = 0; x < this.currentEditorSkin.method_4307(); ++x) {
                    for (int y = 0; y < this.currentEditorSkin.method_4323(); ++y) {
                        assert (skinFeatureImage != null);
                        if (skinFeatureImage.method_4315(x, y) == 0) continue;
                        this.currentEditorSkin.method_4305(x, y, skinFeatureImage.method_4315(x, y));
                    }
                }
            }
            catch (Exception e) {
                ETFUtils2.logMessage("Skin feature layout could not be applied to a copy of your skin. Error written to log.", false);
                ETFUtils2.logError(e.toString(), false);
            }
        } else {
            ETFUtils2.logError("Fabric API required for skin processing, cancelling.", false);
        }
    }

    public boolean printPlayerSkinCopy() {
        if (ETFVersionDifferenceHandler.isFabric() == ETFVersionDifferenceHandler.isThisModLoaded("fabric") && ETFClientCommon.CONFIG_DIR != null) {
            Path outputDirectory = Path.of(ETFClientCommon.CONFIG_DIR.getParent(), "\\ETF_player_skin_printout.png");
            try {
                this.currentEditorSkin.method_4314(outputDirectory);
                ETFUtils2.logMessage(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.print_skin.result.success").getString(), false);
                return true;
            }
            catch (Exception e) {
                ETFUtils2.logError(e.toString(), false);
            }
        }
        return false;
    }

    public void drawEntity(int x, int y, int size, float mouseX, float mouseY, class_1309 entity) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float g = (float)Math.atan(mouseY / 40.0f);
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_22904((double)x, (double)y, 1050.0);
        matrixStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 matrixStack2 = new class_4587();
        matrixStack2.method_22904(0.0, 0.0, 1000.0);
        matrixStack2.method_22905((float)size, (float)size, (float)size);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        matrixStack2.method_22907(quaternionf);
        float h = entity.field_6283;
        float i = entity.method_36454();
        float j = entity.method_36455();
        float k = entity.field_6259;
        float l = entity.field_6241;
        entity.field_6283 = (this.flipView ? 0.0f : 180.0f) + f * 20.0f;
        entity.method_36456((this.flipView ? 0.0f : 180.0f) + f * 40.0f);
        entity.method_36457(-g * 20.0f);
        entity.field_6241 = entity.method_36454();
        entity.field_6259 = entity.method_36454();
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        quaternionf2.conjugate();
        entityRenderDispatcher.method_24196(quaternionf2);
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack2, (class_4597)immediate, 0xF000F0));
        immediate.method_22993();
        class_4597.class_4598 immediate2 = class_310.method_1551().method_22940().method_23000();
        RenderSystem.runAsFancy(() -> {
            class_897 bob;
            class_1921 layer;
            class_4588 vertexC;
            class_2960 emissive;
            if (this.thisETFPlayerTexture != null && this.thisETFPlayerTexture.etfTextureOfFinalBaseSkin != null && entity instanceof class_742 && (emissive = this.thisETFPlayerTexture.etfTextureOfFinalBaseSkin.getEmissiveIdentifierOfCurrentState()) != null && (vertexC = immediate.getBuffer(layer = class_1921.method_23580((class_2960)emissive))) != null && (bob = entityRenderDispatcher.method_3953((class_1297)entity)) instanceof class_922) {
                ((class_922)bob).method_4038().method_2828(matrixStack, vertexC, 0xF000F2, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        });
        immediate2.method_22993();
        entityRenderDispatcher.method_3948(true);
        entity.field_6283 = h;
        entity.method_36456(i);
        entity.method_36457(j);
        entity.field_6259 = k;
        entity.field_6241 = l;
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }

    public static enum NoseType {
        VILLAGER(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.villager")),
        VILLAGER_TEXTURED(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.villager2")),
        TEXTURED_1(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.textured.1")),
        TEXTURED_2(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.textured.2")),
        TEXTURED_3(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.textured.3")),
        TEXTURED_4(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.textured.4")),
        TEXTURED_5(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.textured.5")),
        NONE(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.none"));

        private final class_2561 buttonText;

        private NoseType(class_2561 buttonText) {
            this.buttonText = buttonText;
        }

        public class_2561 getButtonText() {
            return this.buttonText;
        }

        public NoseType next() {
            switch (this) {
                case NONE: {
                    return VILLAGER;
                }
                case VILLAGER: {
                    return VILLAGER_TEXTURED;
                }
                case VILLAGER_TEXTURED: {
                    return TEXTURED_1;
                }
                case TEXTURED_1: {
                    return TEXTURED_2;
                }
                case TEXTURED_2: {
                    return TEXTURED_3;
                }
                case TEXTURED_3: {
                    return TEXTURED_4;
                }
                case TEXTURED_4: {
                    return TEXTURED_5;
                }
            }
            return NONE;
        }

        public int getNosePixelColour() {
            switch (this) {
                case VILLAGER: {
                    return ETFConfigScreenSkinTool.getPixelColour(1);
                }
                case VILLAGER_TEXTURED: {
                    return ETFConfigScreenSkinTool.getPixelColour(7);
                }
                case TEXTURED_1: {
                    return ETFConfigScreenSkinTool.getPixelColour(2);
                }
                case TEXTURED_2: {
                    return ETFConfigScreenSkinTool.getPixelColour(3);
                }
                case TEXTURED_3: {
                    return ETFConfigScreenSkinTool.getPixelColour(4);
                }
                case TEXTURED_4: {
                    return ETFConfigScreenSkinTool.getPixelColour(5);
                }
                case TEXTURED_5: {
                    return ETFConfigScreenSkinTool.getPixelColour(6);
                }
            }
            return 0;
        }
    }

    public static enum CapeType {
        OPTIFINE(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.cape.optifine")),
        MINECRAFT_CAPES_NET(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.cape.minecraftcapes")),
        ETF(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.cape.etf")),
        CUSTOM(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.cape.custom")),
        NONE(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.cape.none"));

        private final class_2561 buttonText;

        private CapeType(class_2561 buttonText) {
            this.buttonText = buttonText;
        }

        public class_2561 getButtonText() {
            return this.buttonText;
        }

        public CapeType next() {
            switch (this) {
                case NONE: {
                    return ETF;
                }
                case ETF: {
                    return CUSTOM;
                }
                case CUSTOM: {
                    return MINECRAFT_CAPES_NET;
                }
                case MINECRAFT_CAPES_NET: {
                    return OPTIFINE;
                }
            }
            return NONE;
        }

        public int getCapePixelColour() {
            switch (this) {
                case CUSTOM: {
                    return ETFConfigScreenSkinTool.getPixelColour(1);
                }
                case OPTIFINE: {
                    return ETFConfigScreenSkinTool.getPixelColour(3);
                }
                case MINECRAFT_CAPES_NET: {
                    return ETFConfigScreenSkinTool.getPixelColour(2);
                }
                case ETF: {
                    return ETFConfigScreenSkinTool.getPixelColour(4);
                }
            }
            return 0;
        }
    }

    public static enum CoatStyle {
        COPIED_THIN_TOP,
        MOVED_THIN_TOP,
        COPIED_FAT_TOP,
        MOVED_FAT_TOP,
        COPIED_THIN,
        MOVED_THIN,
        COPIED_FAT,
        MOVED_FAT,
        NONE;


        public static CoatStyle get(int id) {
            switch (id) {
                case 1: {
                    return COPIED_THIN_TOP;
                }
                case 2: {
                    return MOVED_THIN_TOP;
                }
                case 3: {
                    return COPIED_FAT_TOP;
                }
                case 4: {
                    return MOVED_FAT_TOP;
                }
                case 5: {
                    return COPIED_THIN;
                }
                case 6: {
                    return MOVED_THIN;
                }
                case 7: {
                    return COPIED_FAT;
                }
                case 8: {
                    return MOVED_FAT;
                }
            }
            return NONE;
        }

        public class_2561 getTitle() {
            switch (this) {
                case COPIED_THIN_TOP: {
                    return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.1");
                }
                case MOVED_THIN_TOP: {
                    return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.2");
                }
                case COPIED_FAT_TOP: {
                    return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.3");
                }
                case MOVED_FAT_TOP: {
                    return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.4");
                }
                case COPIED_THIN: {
                    return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.5");
                }
                case MOVED_THIN: {
                    return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.6");
                }
                case COPIED_FAT: {
                    return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.7");
                }
                case MOVED_FAT: {
                    return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.8");
                }
            }
            return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.none");
        }

        public int getCoatPixelColour() {
            switch (this) {
                case COPIED_THIN_TOP: {
                    return -65281;
                }
                case MOVED_THIN_TOP: {
                    return -256;
                }
                case COPIED_FAT_TOP: {
                    return -16776961;
                }
                case MOVED_FAT_TOP: {
                    return -16711936;
                }
                case COPIED_THIN: {
                    return -16760705;
                }
                case MOVED_THIN: {
                    return -65536;
                }
                case COPIED_FAT: {
                    return -16744449;
                }
                case MOVED_FAT: {
                    return -14483457;
                }
            }
            return 0;
        }

        public CoatStyle next() {
            switch (this) {
                case NONE: {
                    return COPIED_THIN_TOP;
                }
                case COPIED_THIN_TOP: {
                    return MOVED_THIN_TOP;
                }
                case MOVED_THIN_TOP: {
                    return COPIED_FAT_TOP;
                }
                case COPIED_FAT_TOP: {
                    return MOVED_FAT_TOP;
                }
                case MOVED_FAT_TOP: {
                    return COPIED_THIN;
                }
                case COPIED_THIN: {
                    return MOVED_THIN;
                }
                case MOVED_THIN: {
                    return COPIED_FAT;
                }
                case COPIED_FAT: {
                    return MOVED_FAT;
                }
            }
            return NONE;
        }
    }

    public static enum BlinkType {
        ONE_PIXEL,
        TWO_PIXEL,
        FOUR_PIXEL,
        WHOLE_FACE,
        WHOLE_FACE_TWO,
        NONE;


        public static BlinkType get(int id) {
            switch (id) {
                case 3: {
                    return ONE_PIXEL;
                }
                case 4: {
                    return TWO_PIXEL;
                }
                case 5: {
                    return FOUR_PIXEL;
                }
                case 1: {
                    return WHOLE_FACE;
                }
                case 2: {
                    return WHOLE_FACE_TWO;
                }
            }
            return NONE;
        }

        public class_2561 getTitle() {
            switch (this) {
                case ONE_PIXEL: {
                    return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.1");
                }
                case TWO_PIXEL: {
                    return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.2");
                }
                case FOUR_PIXEL: {
                    return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.4");
                }
                case WHOLE_FACE: {
                    return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.whole.1");
                }
                case WHOLE_FACE_TWO: {
                    return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.whole.2");
                }
            }
            return ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.none");
        }

        public int getBlinkPixelColour() {
            switch (this) {
                case ONE_PIXEL: {
                    return ETFConfigScreenSkinTool.getPixelColour(3);
                }
                case TWO_PIXEL: {
                    return ETFConfigScreenSkinTool.getPixelColour(4);
                }
                case FOUR_PIXEL: {
                    return ETFConfigScreenSkinTool.getPixelColour(5);
                }
                case WHOLE_FACE: {
                    return ETFConfigScreenSkinTool.getPixelColour(1);
                }
                case WHOLE_FACE_TWO: {
                    return ETFConfigScreenSkinTool.getPixelColour(2);
                }
            }
            return 0;
        }

        public int getMaxEyePixelHeight() {
            switch (this) {
                case ONE_PIXEL: {
                    return 8;
                }
                case TWO_PIXEL: {
                    return 7;
                }
                case FOUR_PIXEL: {
                    return 5;
                }
            }
            return 1;
        }

        public BlinkType next() {
            switch (this) {
                case NONE: {
                    return ONE_PIXEL;
                }
                case ONE_PIXEL: {
                    return TWO_PIXEL;
                }
                case TWO_PIXEL: {
                    return FOUR_PIXEL;
                }
                case FOUR_PIXEL: {
                    return WHOLE_FACE;
                }
                case WHOLE_FACE: {
                    return WHOLE_FACE_TWO;
                }
            }
            return NONE;
        }
    }
}

