/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_features.property_reading;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.texture_features.ETFManager;
import traben.entity_texture_features.texture_features.property_reading.RandomPropertyRule;
import traben.entity_texture_features.texture_features.property_reading.properties.RandomProperties;
import traben.entity_texture_features.texture_features.property_reading.properties.generic_properties.SimpleIntegerArrayProperty;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.entity_texture_features.utils.entity_wrappers.ETFEntity;

public abstract class RandomPropertiesFileHandler {
    public static void processNewOptiFinePropertiesFile(ETFEntity entity, class_2960 vanillaIdentifier, class_2960 properties) {
        block25: {
            ETFManager manager = ETFManager.getInstance();
            try {
                Properties props = ETFUtils2.readAndReturnPropertiesElseNull(properties);
                if (props != null) {
                    List<RandomPropertyRule> allCasesForTexture;
                    if (props.containsKey("vanillaBrightnessOverride")) {
                        int tryNumber;
                        String value = props.getProperty("vanillaBrightnessOverride").trim();
                        try {
                            tryNumber = Integer.parseInt(value.replaceAll("\\D", ""));
                        }
                        catch (NumberFormatException e) {
                            tryNumber = 0;
                        }
                        if (tryNumber >= 16) {
                            tryNumber = 15;
                        }
                        if (tryNumber < 0) {
                            tryNumber = 0;
                        }
                        manager.ENTITY_TYPE_VANILLA_BRIGHTNESS_OVERRIDE_VALUE.put(entity.getType(), tryNumber);
                    }
                    if (entity.isZombiePiglin() && props.containsKey("showHiddenModelParts") && "true".equals(props.getProperty("showHiddenModelParts"))) {
                        manager.zombiePiglinRightEarEnabled = true;
                    }
                    if (props.containsKey("suppressParticles") && "true".equals(props.getProperty("suppressParticles"))) {
                        manager.ENTITY_TYPE_IGNORE_PARTICLES.add(entity.getType());
                    }
                    if (props.containsKey("entityRenderLayerOverride")) {
                        String layer;
                        switch (layer = props.getProperty("entityRenderLayerOverride")) {
                            case "translucent": {
                                manager.ENTITY_TYPE_RENDER_LAYER.put(entity.getType(), 1);
                                break;
                            }
                            case "translucent_cull": {
                                manager.ENTITY_TYPE_RENDER_LAYER.put(entity.getType(), 2);
                                break;
                            }
                            case "end_portal": {
                                manager.ENTITY_TYPE_RENDER_LAYER.put(entity.getType(), 3);
                                break;
                            }
                            case "outline": {
                                manager.ENTITY_TYPE_RENDER_LAYER.put(entity.getType(), 4);
                            }
                        }
                    }
                    if (!(allCasesForTexture = RandomPropertiesFileHandler.getAllValidPropertyObjects(props, vanillaIdentifier, "skins", "textures")).isEmpty()) {
                        manager.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, allCasesForTexture);
                    } else {
                        ETFUtils2.logMessage("Ignoring properties file that failed to load any cases @ " + vanillaIdentifier, false);
                        manager.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, null);
                    }
                    break block25;
                }
                ETFUtils2.logMessage("Ignoring properties file that was null @ " + vanillaIdentifier, false);
                manager.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, null);
            }
            catch (Exception e) {
                ETFUtils2.logWarn("Ignoring properties file that caused Exception @ " + vanillaIdentifier + "\n" + e, false);
                e.printStackTrace();
                manager.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, null);
            }
        }
    }

    public static List<RandomPropertyRule> getAllValidPropertyObjects(Properties properties, class_2960 propertiesFilePath, String ... suffixToTest) {
        Set<String> propIds = properties.stringPropertyNames();
        HashSet<Integer> foundRuleNumbers = new HashSet<Integer>();
        for (String str : propIds) {
            String possibleRuleNumber;
            String[] split = str.split("\\.");
            if (split.length < 2 || split[1].isBlank() || (possibleRuleNumber = split[1].replaceAll("\\D", "")).isBlank()) continue;
            try {
                foundRuleNumbers.add(Integer.parseInt(possibleRuleNumber));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        ArrayList numbersList = new ArrayList(foundRuleNumbers);
        Collections.sort(numbersList);
        ArrayList<RandomPropertyRule> allRulesOfProperty = new ArrayList<RandomPropertyRule>();
        for (Integer ruleNumber : numbersList) {
            Integer[] suffixesOfRule = RandomPropertiesFileHandler.getSuffixes(properties, ruleNumber, suffixToTest);
            if (suffixesOfRule != null && suffixesOfRule.length != 0) {
                allRulesOfProperty.add(new RandomPropertyRule(propertiesFilePath.toString(), ruleNumber, suffixesOfRule, RandomPropertiesFileHandler.getWeights(properties, ruleNumber), RandomProperties.getAllRegisteredRandomPropertiesOfIndex(properties, ruleNumber)));
                continue;
            }
            ETFUtils2.logWarn("property number \"" + ruleNumber + ". in file \"" + propertiesFilePath + ". failed to read.");
        }
        return allRulesOfProperty;
    }

    @Nullable
    private static Integer[] getSuffixes(Properties props, int num, String ... suffixToTest) {
        return SimpleIntegerArrayProperty.getGenericIntegerSplitWithRanges(props, num, suffixToTest);
    }

    @Nullable
    private static Integer[] getWeights(Properties props, int num) {
        return SimpleIntegerArrayProperty.getGenericIntegerSplitWithRanges(props, num, "weights");
    }
}

