/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_features.property_reading.properties;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import traben.entity_texture_features.utils.entity_wrappers.ETFEntity;

public abstract class RandomProperty {
    @NotNull
    public static String readPropertiesOrThrow(Properties properties, int propertyNum, String ... propertyId) throws RandomPropertyException {
        if (propertyId.length == 0) {
            throw new IllegalArgumentException("[ETF] readPropertiesOrThrow() was given empty property id's");
        }
        for (String id : propertyId) {
            String dataFromProps;
            if (!properties.containsKey(id + "." + propertyNum) || (dataFromProps = properties.getProperty(id + "." + propertyNum).strip()).isBlank()) continue;
            return dataFromProps;
        }
        throw new RandomPropertyException("failed to read property [" + propertyId[0] + "]");
    }

    public boolean testEntity(ETFEntity entity, boolean isUpdate, Object2BooleanOpenHashMap<RandomProperty> spawnConditions) {
        try {
            if (isUpdate && !this.isPropertyUpdatable()) {
                if (spawnConditions.containsKey((Object)this)) {
                    return spawnConditions.getBoolean((Object)this);
                }
                return false;
            }
            boolean result = this.testEntityInternal(entity);
            if (!this.isPropertyUpdatable()) {
                spawnConditions.put((Object)this, result);
            }
            return result;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    protected abstract boolean testEntityInternal(ETFEntity var1);

    public boolean isPropertyUpdatable() {
        return true;
    }

    @NotNull
    public abstract String[] getPropertyIds();

    @NotNull
    public String getPropertyId() {
        return this.getPropertyIds()[0];
    }

    protected abstract String getPrintableRuleInfo();

    public String toString() {
        return this.getClass().getSimpleName() + "[Property: " + this.getPropertyId() + ", Rule: " + this.getPrintableRuleInfo() + "]";
    }

    public static class RandomPropertyException
    extends Exception {
        public RandomPropertyException(String reason) {
            super("[ETF] " + reason);
        }
    }
}

