/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_features.property_reading.properties.generic_properties;

import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.texture_features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.texture_features.property_reading.properties.generic_properties.NumberRangeFromStringArrayProperty;
import traben.entity_texture_features.utils.ETFUtils2;

public abstract class FloatRangeFromStringArrayProperty
extends NumberRangeFromStringArrayProperty<Float> {
    protected FloatRangeFromStringArrayProperty(String string) throws RandomProperty.RandomPropertyException {
        super(string);
    }

    @Override
    @Nullable
    protected NumberRangeFromStringArrayProperty.RangeTester<Float> getRangeTesterFromString(String possibleRange) {
        try {
            if (possibleRange.matches("([\\d.]+|-[\\d.]+)-([\\d.]+|-[\\d.]+)")) {
                String[] str = possibleRange.split("(?<!^|-)-");
                float small = Float.parseFloat(str[0].replaceAll("[^0-9.-]", ""));
                float big = Float.parseFloat(str[1].replaceAll("[^0-9.-]", ""));
                return value -> value.floatValue() >= small && value.floatValue() <= big;
            }
            float single = Float.parseFloat(possibleRange.replaceAll("[^0-9.-]", ""));
            return value -> value.floatValue() == single;
        }
        catch (Exception ignored) {
            ETFUtils2.logError("number or range in [" + this.getPropertyId() + "] property could not be extracted from input: " + possibleRange);
            return null;
        }
    }
}

