/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_features.property_reading.properties.generic_properties;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.texture_features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.entity_texture_features.utils.entity_wrappers.ETFEntity;

public abstract class SimpleIntegerArrayProperty
extends RandomProperty {
    private final IntOpenHashSet ARRAY;

    protected SimpleIntegerArrayProperty(Integer[] array) throws RandomProperty.RandomPropertyException {
        if (array == null || array.length == 0) {
            throw new RandomProperty.RandomPropertyException(this.getPropertyId() + " property was broken");
        }
        this.ARRAY = new IntOpenHashSet(List.of(array));
    }

    @Nullable
    public static Integer[] getGenericIntegerSplitWithRanges(Properties props, int num, String ... propertyNames) {
        if (propertyNames.length == 0) {
            throw new IllegalArgumentException("propertyNames is empty in IntegerArrayProperty");
        }
        for (String propertyName : propertyNames) {
            if (propertyName == null || propertyName.isBlank() || !props.containsKey(propertyName + "." + num)) continue;
            String dataFromProps = props.getProperty(propertyName + "." + num).strip().replaceAll("[)(]", "");
            String[] skinData = dataFromProps.split("\\s+");
            ArrayList<Integer> suffixNumbers = new ArrayList<Integer>();
            for (String data : skinData) {
                if ((data = data.strip()).replaceAll("\\D", "").isEmpty()) continue;
                try {
                    if (data.contains("-")) {
                        suffixNumbers.addAll(Arrays.asList(SimpleIntegerArrayProperty.getIntRange(data).getAllWithinRangeAsList()));
                        continue;
                    }
                    int tryNumber = Integer.parseInt(data.replaceAll("\\D", ""));
                    suffixNumbers.add(tryNumber);
                }
                catch (NumberFormatException e) {
                    ETFUtils2.logWarn("properties files number error in " + propertyName + " category");
                }
            }
            return suffixNumbers.toArray(new Integer[0]);
        }
        return null;
    }

    public static IntRange getIntRange(String rawRange) {
        String numberOnlyString = rawRange.trim().replaceAll("[^0-9-]", "");
        try {
            if (numberOnlyString.matches("(\\d+|-\\d+)-(\\d+|-\\d+)")) {
                String[] str = numberOnlyString.split("(?<!^|-)-");
                int small = Integer.parseInt(str[0]);
                int large = Integer.parseInt(str[1]);
                return new IntRange(small, large);
            }
            int single = Integer.parseInt(numberOnlyString);
            return new IntRange(single, single);
        }
        catch (Exception e) {
            return new IntRange(0, 0);
        }
    }

    @Override
    public boolean testEntityInternal(ETFEntity entity) {
        int entityInteger = this.getValueFromEntity(entity);
        return this.ARRAY.contains(entityInteger);
    }

    protected abstract int getValueFromEntity(ETFEntity var1);

    @Override
    protected String getPrintableRuleInfo() {
        return String.valueOf(this.ARRAY);
    }

    public record IntRange(int lower, int higher) {
        public boolean isWithinRange(int value) {
            return value >= this.lower && value <= this.higher;
        }

        public Integer[] getAllWithinRangeAsList() {
            if (this.lower == this.higher) {
                return new Integer[]{this.lower};
            }
            ArrayList<Integer> builder = new ArrayList<Integer>();
            for (int i = Math.min(this.lower, this.higher); i <= Math.max(this.lower, this.higher); ++i) {
                builder.add(i);
            }
            return builder.toArray(new Integer[0]);
        }
    }
}

