/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_features.property_reading.properties.optifine_properties;

import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.texture_features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.texture_features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.utils.entity_wrappers.ETFEntity;

public class BlocksProperty
extends StringArrayOrRegexProperty {
    private static final Function<Map.Entry<class_2769<?>, Comparable<?>>, String> PROPERTY_MAP_PRINTER = new Function<Map.Entry<class_2769<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<class_2769<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            class_2769<?> property = entry.getKey();
            String var10000 = property.method_11899();
            return var10000 + "=" + this.nameValue(property, entry.getValue());
        }

        private <T extends Comparable<T>> String nameValue(class_2769<T> property, Comparable<?> value) {
            return property.method_11901(value);
        }
    };

    protected BlocksProperty(Properties properties, int propertyNum) throws RandomProperty.RandomPropertyException {
        super(BlocksProperty.readPropertiesOrThrow(properties, propertyNum, "blocks", "block").replaceAll("(?<=(^| ))minecraft:", ""));
    }

    public static BlocksProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new BlocksProperty(properties, propertyNum);
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    private static String getBlockFormattedFromState(class_2680 state) {
        Object block = class_7923.field_41175.method_10221((Object)state.method_26204()).toString();
        if (!state.method_11656().isEmpty()) {
            block = (String)block + ":" + state.method_11656().entrySet().stream().map(PROPERTY_MAP_PRINTER).collect(Collectors.joining(":"));
        }
        if (((String)block).startsWith("minecraft:")) {
            return ((String)block).replaceFirst("minecraft:", "");
        }
        return block;
    }

    @Override
    protected boolean shouldForceLowerCaseCheck() {
        return true;
    }

    @Override
    public boolean testEntityInternal(ETFEntity entity) {
        String[] entityBlocks;
        class_2586 blockEntity = entity.getBlockEntity();
        if (blockEntity != null) {
            entityBlocks = new String[]{BlocksProperty.getBlockFormattedFromState(blockEntity.method_11010())};
        } else {
            if (entity.getWorld() == null || entity.getBlockPos() == null) {
                return false;
            }
            class_1937 world = entity.getWorld();
            class_2338 pos = entity.getBlockPos();
            entityBlocks = new String[]{BlocksProperty.getBlockFormattedFromState(world.method_8320(pos)), BlocksProperty.getBlockFormattedFromState(world.method_8320(pos.method_10074()))};
        }
        boolean foundAMatch = false;
        for (String block : entityBlocks) {
            if (block == null) continue;
            foundAMatch = this.MATCHER.testString(block.toLowerCase());
            if (!foundAMatch) {
                boolean foundEach = true;
                block1: for (String definition : this.ARRAY) {
                    for (String partsToFind : definition.split(":")) {
                        if (block.contains(partsToFind)) continue;
                        foundEach = false;
                        continue block1;
                    }
                }
                foundAMatch = foundEach;
            }
            if (foundAMatch) break;
        }
        return foundAMatch;
    }

    @Override
    @Nullable
    public String getValueFromEntity(ETFEntity etfEntity) {
        return null;
    }

    @Override
    public boolean isPropertyUpdatable() {
        return !ETFClientCommon.ETFConfigData.restrictBlock;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"blocks", "block"};
    }
}

