/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_features.property_reading.properties.optifine_properties;

import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.texture_features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.texture_features.property_reading.properties.generic_properties.SimpleIntegerArrayProperty;
import traben.entity_texture_features.utils.entity_wrappers.ETFEntity;

public class HeightProperty
extends SimpleIntegerArrayProperty {
    protected HeightProperty(Properties properties, int propertyNum) throws RandomProperty.RandomPropertyException {
        super(HeightProperty.getGenericIntegerSplitWithRanges(properties, propertyNum, "heights", "height"));
    }

    public static HeightProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            if (!properties.containsKey("heights." + propertyNum) && !properties.containsKey("height." + propertyNum) && (properties.containsKey("minHeight." + propertyNum) || properties.containsKey("maxHeight." + propertyNum))) {
                String min = "-64";
                String max = "319";
                if (properties.containsKey("minHeight." + propertyNum)) {
                    min = properties.getProperty("minHeight." + propertyNum).strip();
                }
                if (properties.containsKey("maxHeight." + propertyNum)) {
                    max = properties.getProperty("maxHeight." + propertyNum).strip();
                }
                properties.put("heights." + propertyNum, min + "-" + max);
            }
            return new HeightProperty(properties, propertyNum);
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    @Override
    public boolean isPropertyUpdatable() {
        return !ETFClientCommon.ETFConfigData.restrictHeight;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"heights", "height"};
    }

    @Override
    protected int getValueFromEntity(ETFEntity entity) {
        return entity.getBlockY();
    }
}

