/*
 * Decompiled with CFR 0.152.
 */
package com.spellbladenext.items.loot;

import com.spellbladenext.items.Items;
import com.spellbladenext.items.armor.Armors;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.spell_engine.api.item.ItemConfig;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_engine.api.loot.LootConfig;

public class Default {
    public static final ItemConfig itemConfig = new ItemConfig();
    public static final LootConfig lootConfig;

    @SafeVarargs
    private static <T> List<T> joinLists(List<T> ... lists) {
        return Arrays.stream(lists).flatMap(Collection::stream).collect(Collectors.toList());
    }

    static {
        for (Weapon.Entry weapon : Items.entries) {
            Default.itemConfig.weapons.put(weapon.name(), weapon.defaults());
        }
        for (Armor.Entry armor : Armors.entries) {
            Default.itemConfig.armor_sets.put(armor.name(), armor.defaults());
        }
        lootConfig = new LootConfig();
        String weapons = "weapons";
        Default.lootConfig.item_groups.put("weapons", new LootConfig.ItemGroup(List.of(Items.frost_blade.id().toString(), Items.glacial_gladius.id().toString(), Items.frost_claymore.id().toString(), Items.frost_orb.id().toString(), Items.arcane_blade.id().toString(), Items.crystal_cutlass.id().toString(), Items.arcane_claymore.id().toString(), Items.arcane_orb.id().toString(), Items.fire_blade.id().toString(), Items.flaming_falchion.id().toString(), Items.fire_claymore.id().toString(), Items.fire_orb.id().toString(), "spellblades:whirlwindoil", "spellblades:spelloil", "spellblades:smiteoil", "spellblades:monkeystaff"), 1).chance(0.5f).enchant());
        List.of("minecraft:chests/ruined_portal").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("weapons")));
        List.of("minecraft:chests/spawn_bonus_chest", "minecraft:chests/igloo_chest", "minecraft:chests/shipwreck_supply", "minecraft:chests/jungle_temple").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("weapons")));
        List.of("minecraft:chests/desert_pyramid", "minecraft:chests/bastion_bridge", "minecraft:chests/jungle_temple", "minecraft:chests/pillager_outpost", "minecraft:chests/underwater_ruin_small", "minecraft:chests/stronghold_crossing").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("weapons")));
        List.of("minecraft:chests/nether_bridge").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("weapons")));
        List.of("minecraft:chests/shipwreck_supply", "minecraft:chests/stronghold_corridor").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("weapons")));
        List.of("minecraft:chests/stronghold_library", "minecraft:chests/underwater_ruin_big", "minecraft:chests/bastion_other", "minecraft:chests/woodland_mansion", "minecraft:chests/simple_dungeon", "minecraft:chests/underwater_ruin_big.json").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("weapons")));
        List.of("minecraft:chests/end_city_treasure", "minecraft:chests/bastion_treasure", "minecraft:chests/ancient_city", "minecraft:chests/stronghold_library").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("weapons")));
    }
}

