/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIFluidsRender;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIStartup;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.ModernIndustrialization;
import aztech.modern_industrialization.blocks.forgehammer.ForgeHammerScreen;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelTooltipData;
import aztech.modern_industrialization.blocks.storage.barrel.client.BarrelTooltipComponent;
import aztech.modern_industrialization.blocks.storage.barrel.client.CreativeBarrelClientSetup;
import aztech.modern_industrialization.blocks.storage.tank.creativetank.CreativeTankClientSetup;
import aztech.modern_industrialization.datagen.MIDatagenClient;
import aztech.modern_industrialization.datagen.MIDatagenServer;
import aztech.modern_industrialization.inventory.ConfigurableInventoryPackets;
import aztech.modern_industrialization.inventory.ConfigurableInventoryS2CPacketHandlers;
import aztech.modern_industrialization.items.ConfigCardItem;
import aztech.modern_industrialization.items.RedstoneControlModuleItem;
import aztech.modern_industrialization.items.SteamDrillItem;
import aztech.modern_industrialization.items.SteamDrillTooltipComponent;
import aztech.modern_industrialization.items.armor.ClientKeyHandler;
import aztech.modern_industrialization.items.armor.HudRenderer;
import aztech.modern_industrialization.items.armor.JetpackParticleAdder;
import aztech.modern_industrialization.items.client.ClientConfigCardTooltip;
import aztech.modern_industrialization.machines.ClientMachinePackets;
import aztech.modern_industrialization.machines.MachineOverlayClient;
import aztech.modern_industrialization.machines.MachinePackets;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.init.MultiblockMachines;
import aztech.modern_industrialization.machines.models.MachineRendering;
import aztech.modern_industrialization.machines.multiblocks.MultiblockErrorHighlight;
import aztech.modern_industrialization.misc.runtime_datagen.RuntimeDataGen;
import aztech.modern_industrialization.misc.version.VersionEvents;
import aztech.modern_industrialization.pipes.MIPipesClient;
import aztech.modern_industrialization.util.TextHelper;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.impl.content.registry.FuelRegistryImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3929;
import net.minecraft.class_5272;
import net.minecraft.class_6862;

@Environment(value=EnvType.CLIENT)
public class ModernIndustrializationClient
implements ClientModInitializer {
    public void onInitializeClient() {
        MIStartup.onClientStartup();
        this.setupScreens();
        MIFluidsRender.setupFluidRenders();
        this.setupPackets();
        CreativeTankClientSetup.setupClient();
        CreativeBarrelClientSetup.setupClient();
        MachineRendering.init();
        MultiblockMachines.clientInit();
        MultiblockErrorHighlight.init();
        WorldRenderEvents.BEFORE_BLOCK_OUTLINE.register(MachineOverlayClient::onBlockOutline);
        new MIPipesClient().setupClient();
        ClientKeyHandler.setup();
        WorldRenderEvents.START.register(renderer -> JetpackParticleAdder.addJetpackParticles(class_310.method_1551()));
        ClientTickEvents.END_CLIENT_TICK.register(ClientKeyHandler::onEndTick);
        HudRenderCallback.EVENT.register(HudRenderer::onRenderHud);
        this.setupTooltips();
        VersionEvents.init();
        this.setupItemPredicates();
        if (!(FabricLoader.getInstance().isModLoaded("emi") || FabricLoader.getInstance().isModLoaded("jei") || FabricLoader.getInstance().isModLoaded("roughlyenoughitems"))) {
            ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
                if (MIConfig.getConfig().enableNoEmiMessage) {
                    client.field_1724.method_7353((class_2561)MIText.NoEmi.text().method_27692(class_124.field_1065), false);
                }
            });
        }
        ModernIndustrialization.LOGGER.info("Modern Industrialization client setup done!");
        if (MIConfig.getConfig().datagenOnStartup) {
            RuntimeDataGen.run(gen -> {
                MIDatagenClient.configure(gen, true);
                MIDatagenServer.configure(gen, true);
            });
        }
    }

    private void setupScreens() {
        class_3929.method_17542(ModernIndustrialization.SCREEN_HANDLER_MACHINE, MachineScreen::new);
        class_3929.method_17542(ModernIndustrialization.SCREEN_HANDLER_FORGE_HAMMER, ForgeHammerScreen::new);
    }

    private void setupPackets() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ConfigurableInventoryPackets.UPDATE_ITEM_SLOT, (ClientPlayNetworking.PlayChannelHandler)ConfigurableInventoryS2CPacketHandlers.UPDATE_ITEM_SLOT);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ConfigurableInventoryPackets.UPDATE_FLUID_SLOT, (ClientPlayNetworking.PlayChannelHandler)ConfigurableInventoryS2CPacketHandlers.UPDATE_FLUID_SLOT);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)MachinePackets.S2C.COMPONENT_SYNC, (ClientPlayNetworking.PlayChannelHandler)ClientMachinePackets.ON_COMPONENT_SYNC);
    }

    private void setupTooltips() {
        ItemTooltipCallback.EVENT.register((stack, context, lines) -> {
            MITooltips.attachTooltip(stack, lines);
            class_1792 item = stack.method_7909();
            if (item != null) {
                if (class_310.method_1551().field_1687 != null && !MIConfig.getConfig().disableFuelTooltips) {
                    try {
                        Integer fuelTime = (Integer)FuelRegistryImpl.INSTANCE.get((class_1935)item);
                        if (fuelTime != null && fuelTime > 0) {
                            long totalEu = (long)fuelTime.intValue() * 20L;
                            lines.add(new MITooltips.Line(MIText.BaseEuTotalStored).arg(totalEu, MITooltips.EU_PARSER).build());
                        }
                    }
                    catch (Exception e) {
                        ModernIndustrialization.LOGGER.warn("Could not show MI fuel tooltip.", (Throwable)e);
                    }
                }
                if (context.method_8035() && !MIConfig.getConfig().disableItemTagTooltips) {
                    List<class_2960> ids = item.method_40131().method_40228().map(class_6862::comp_327).sorted().toList();
                    for (class_2960 id : ids) {
                        lines.add(class_2561.method_43470((String)("#" + id)).method_10862(TextHelper.GRAY_TEXT));
                    }
                }
            }
        });
        TooltipComponentCallback.EVENT.register(data -> {
            if (data instanceof BarrelTooltipData) {
                BarrelTooltipData barrelData = (BarrelTooltipData)data;
                return new BarrelTooltipComponent(barrelData);
            }
            if (data instanceof SteamDrillItem.SteamDrillTooltipData) {
                SteamDrillItem.SteamDrillTooltipData steamDrillData = (SteamDrillItem.SteamDrillTooltipData)data;
                return new SteamDrillTooltipComponent(steamDrillData);
            }
            if (data instanceof ConfigCardItem.TooltipData) {
                ConfigCardItem.TooltipData configCardData = (ConfigCardItem.TooltipData)data;
                return new ClientConfigCardTooltip(configCardData);
            }
            return null;
        });
    }

    private void setupItemPredicates() {
        class_5272.method_27879((class_1792)MIItem.REDSTONE_CONTROL_MODULE.method_8389(), (class_2960)new MIIdentifier("redstone_control_module"), (stack, level, entity, seed) -> RedstoneControlModuleItem.isRequiresLowSignal(stack) ? 0.0f : 1.0f);
    }
}

