/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.rei;

import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.compat.viewer.impl.MachineScreenPredicateTest;
import aztech.modern_industrialization.machines.gui.MachineMenuClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.util.Rectangle;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
class MachineClickAreaHandler
implements ClickArea<MachineScreen> {
    MachineClickAreaHandler() {
    }

    public ClickArea.Result handle(ClickArea.ClickAreaContext<MachineScreen> context) {
        MachineMenuClient screenHandler = (MachineMenuClient)((MachineScreen)context.getScreen()).method_17577();
        String blockId = screenHandler.guiParams.blockId;
        List categories = ReiMachineRecipes.machineToClickAreaCategory.getOrDefault(blockId, Collections.emptyList());
        Rectangle rectangle = ReiMachineRecipes.machineToClickArea.get(blockId);
        Point point = context.getMousePosition().clone();
        point.translate(-((MachineScreen)context.getScreen()).x(), -((MachineScreen)context.getScreen()).y());
        if (categories.size() > 0 && rectangle != null && MachineClickAreaHandler.contains(rectangle, point)) {
            ClickArea.Result result = ClickArea.Result.success();
            boolean foundSome = false;
            for (ReiMachineRecipes.ClickAreaCategory cac : categories) {
                List displays;
                if (!MachineScreenPredicateTest.test(cac.predicate, (MachineScreen)context.getScreen()) || (displays = DisplayRegistry.getInstance().get(CategoryIdentifier.of((class_2960)cac.category))).size() <= 0) continue;
                result.category(CategoryIdentifier.of((class_2960)cac.category));
                foundSome = true;
            }
            return foundSome ? result : ClickArea.Result.fail();
        }
        return ClickArea.Result.fail();
    }

    private static boolean contains(Rectangle rectangle, Point mousePosition) {
        return rectangle.x() <= mousePosition.x && mousePosition.x <= rectangle.x() + rectangle.w() && rectangle.y() <= mousePosition.y && mousePosition.y <= rectangle.y() + rectangle.h();
    }
}

