/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import org.slf4j.Logger;

public class AggregateDataProvider
implements class_2405 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String name;
    private final FabricDataOutput packOutput;
    private final CompletableFuture<class_7225.class_7874> registriesFuture;
    private final List<class_2405> providers = new ArrayList<class_2405>();

    public static FabricDataGenerator.Pack.RegistryDependentFactory<AggregateDataProvider> create(String name) {
        return (packOutput, registriesFuture) -> new AggregateDataProvider(name, packOutput, registriesFuture);
    }

    private AggregateDataProvider(String name, FabricDataOutput packOutput, CompletableFuture<class_7225.class_7874> registriesFuture) {
        this.name = name;
        this.packOutput = packOutput;
        this.registriesFuture = registriesFuture;
    }

    public <T extends class_2405> T addProvider(FabricDataGenerator.Pack.Factory<T> factory) {
        class_2405 provider = factory.create(this.packOutput);
        this.providers.add(provider);
        return (T)provider;
    }

    public <T extends class_2405> T addProvider(FabricDataGenerator.Pack.RegistryDependentFactory<T> factory) {
        class_2405 provider = factory.create(this.packOutput, this.registriesFuture);
        this.providers.add(provider);
        return (T)provider;
    }

    public CompletableFuture<?> method_10319(class_7403 output) {
        LOGGER.info("Will run the following providers in parallel:" + this.providers.stream().map(provider -> "\n - Modern Industrialization/%s".formatted(provider.method_10321())).collect(Collectors.joining()));
        return CompletableFuture.allOf((CompletableFuture[])this.providers.stream().map(provider -> provider.method_10319(output)).toArray(CompletableFuture[]::new));
    }

    public String method_10321() {
        return this.name + " (aggregated)";
    }
}

