/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.debug;

import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.PipeNetworkManager;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.impl.PipeNetworks;
import aztech.modern_industrialization.stats.PlayerStatisticsData;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2246;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class DebugCommands {
    private static final SuggestionProvider<class_2168> PIPE_TYPES_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9257(PipeNetworkType.getTypes().keySet().stream(), (SuggestionsBuilder)builder);

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, context, env) -> {
            if (!MIConfig.getConfig().enableDebugCommands) {
                return;
            }
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mi").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"pipes").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9247((String)"clear").executes(ctx -> DebugCommands.clearPipes((class_2168)ctx.getSource(), class_2262.method_9696((CommandContext)ctx, (String)"pos"))))).then(class_2170.method_9247((String)"add_ghost").then(class_2170.method_9244((String)"pipe_type", (ArgumentType)class_2232.method_9441()).suggests(PIPE_TYPES_SUGGESTION_PROVIDER).executes(ctx -> DebugCommands.addGhostPipe((class_2168)ctx.getSource(), class_2262.method_9696((CommandContext)ctx, (String)"pos"), class_2232.method_9443((CommandContext)ctx, (String)"pipe_type")))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"machines").then(class_2170.method_9247((String)"claim_all").executes(ctx -> DebugCommands.claimMachines(((class_2168)ctx.getSource()).method_9207())))).then(class_2170.method_9247((String)"dump_stats").executes(ctx -> DebugCommands.dumpStats(((class_2168)ctx.getSource()).method_9207())))));
        });
    }

    private static int clearPipes(class_2168 src, class_2338 pos) {
        if (src.method_9225().method_8320(pos).method_27852(MIPipes.BLOCK_PIPE)) {
            src.method_9225().method_8501(pos, class_2246.field_10124.method_9564());
        }
        PipeNetworks networks = PipeNetworks.get(src.method_9225());
        for (PipeNetworkType type : PipeNetworkType.getTypes().values()) {
            PipeNetworkManager manager = networks.getManager(type);
            if (!manager.hasNode(pos)) continue;
            manager.removeNode(pos);
            src.method_9226(() -> class_2561.method_43470((String)"Successfully removed pipe of type %s at position %s.".formatted(type.getIdentifier(), pos)), true);
        }
        return 1;
    }

    private static int addGhostPipe(class_2168 src, class_2338 pos, class_2960 pipeType) throws CommandSyntaxException {
        PipeNetworkType type = PipeNetworkType.get(pipeType);
        if (type == null) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Unknown pipe network type: " + pipeType))).create();
        }
        PipeNetworks networks = PipeNetworks.get(src.method_9225());
        PipeNetworkManager manager = networks.getManager(type);
        if (!manager.hasNode(pos)) {
            manager.addNode(type.getNodeCtor().get(), pos, MIPipes.INSTANCE.getPipeItem((PipeNetworkType)type).defaultData.clone());
            src.method_9226(() -> class_2561.method_43470((String)"Successfully added pipe of type %s at position %s.".formatted(type.getIdentifier(), pos)), true);
        } else {
            src.method_9226(() -> class_2561.method_43470((String)"Failed to add pipe of type %s at position %s as it already existed.".formatted(type.getIdentifier(), pos)), true);
        }
        return 1;
    }

    private static int claimMachines(class_3222 player) {
        for (class_3218 level : player.field_13995.method_3738()) {
            class_3215 chunkSource = level.method_14178();
            for (Long pos : chunkSource.field_17254.field_17213.keySet()) {
                class_2818 chunk = chunkSource.method_12126(class_1923.method_8325((long)pos), class_1923.method_8332((long)pos), false);
                if (chunk == null) continue;
                for (class_2586 be : chunk.method_12214().values()) {
                    if (!(be instanceof MachineBlockEntity)) continue;
                    MachineBlockEntity machine = (MachineBlockEntity)be;
                    machine.placedBy.onPlaced((class_1309)player);
                    machine.method_5431();
                }
            }
        }
        return 1;
    }

    private static int dumpStats(class_3222 player) {
        player.method_7353((class_2561)class_2561.method_43470((String)PlayerStatisticsData.get(player.field_13995).get((class_1657)player).toTag().toString()), false);
        return 1;
    }
}

