/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2487;
import net.minecraft.class_2586;

public class EnergyComponent
implements IComponent.ServerOnly,
EnergyAccess {
    private long storedEu;
    private final Supplier<Long> capacity;
    private final class_2586 blockEntity;
    private final SnapshotParticipant<Long> participant = new SnapshotParticipant<Long>(){

        protected Long createSnapshot() {
            return EnergyComponent.this.storedEu;
        }

        protected void readSnapshot(Long snapshot) {
            EnergyComponent.this.storedEu = snapshot;
        }

        protected void onFinalCommit() {
            EnergyComponent.this.blockEntity.method_5431();
        }
    };

    public EnergyComponent(class_2586 blockEntity, Supplier<Long> capacity) {
        this.capacity = capacity;
        this.blockEntity = blockEntity;
    }

    public EnergyComponent(class_2586 blockEntity, long capacity) {
        this.capacity = () -> capacity;
        this.blockEntity = blockEntity;
    }

    @Override
    public long getEu() {
        return Math.min(this.storedEu, this.capacity.get());
    }

    @Override
    public long getCapacity() {
        return this.capacity.get();
    }

    public long getRemainingCapacity() {
        return this.capacity.get() - this.getEu();
    }

    @Override
    public void writeNbt(class_2487 tag) {
        tag.method_10544("storedEu", this.getEu());
    }

    @Override
    public void readNbt(class_2487 tag) {
        this.setEu(tag.method_10537("storedEu"), false);
    }

    private void setEu(long eu, boolean update) {
        this.storedEu = Math.min(eu, this.capacity.get());
        if (update) {
            this.blockEntity.method_5431();
        }
    }

    public long consumeEu(long max, Simulation simulation) {
        Preconditions.checkArgument((max >= 0L ? 1 : 0) != 0, (Object)"May not consume < 0 energy.");
        long ext = Math.min(max, this.getEu());
        if (simulation.isActing()) {
            this.setEu(this.getEu() - ext, true);
        }
        return ext;
    }

    public long insertEu(long max, Simulation simulation) {
        Preconditions.checkArgument((max >= 0L ? 1 : 0) != 0, (Object)"May not insert < 0 energy.");
        long ext = Math.min(max, this.capacity.get() - this.getEu());
        if (simulation.isActing()) {
            this.setEu(this.getEu() + ext, true);
        }
        return ext;
    }

    public MIEnergyStorage buildInsertable(final Predicate<CableTier> canInsert) {
        return new EnergyStorage(){

            public long insert(long maxAmount, TransactionContext transaction) {
                Preconditions.checkArgument((maxAmount >= 0L ? 1 : 0) != 0, (Object)"May not insert < 0 energy.");
                long inserted = Math.min(maxAmount, EnergyComponent.this.capacity.get() - EnergyComponent.this.getEu());
                EnergyComponent.this.participant.updateSnapshots(transaction);
                EnergyComponent.this.storedEu += inserted;
                return inserted;
            }

            public long extract(long maxAmount, TransactionContext transaction) {
                return 0L;
            }

            public boolean supportsExtraction() {
                return false;
            }

            @Override
            public boolean canConnect(CableTier cableTier) {
                return canInsert.test(cableTier);
            }
        };
    }

    public MIEnergyStorage buildExtractable(final Predicate<CableTier> canExtract) {
        return new EnergyStorage(){

            public long insert(long maxAmount, TransactionContext transaction) {
                return 0L;
            }

            public boolean supportsInsertion() {
                return false;
            }

            public long extract(long maxAmount, TransactionContext transaction) {
                Preconditions.checkArgument((maxAmount >= 0L ? 1 : 0) != 0, (Object)"May not extract < 0 energy.");
                long extracted = Math.min(maxAmount, EnergyComponent.this.getEu());
                EnergyComponent.this.participant.updateSnapshots(transaction);
                EnergyComponent.this.storedEu -= extracted;
                return extracted;
            }

            @Override
            public boolean canConnect(CableTier cableTier) {
                return canExtract.test(cableTier);
            }
        };
    }

    private abstract class EnergyStorage
    implements MIEnergyStorage {
        private EnergyStorage() {
        }

        public long getAmount() {
            return EnergyComponent.this.storedEu;
        }

        public long getCapacity() {
            return EnergyComponent.this.capacity.get();
        }
    }
}

