/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.machines.GuiComponents;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class CraftingMultiblockGui {
    public static final int X = 4;
    public static final int Y = 16;
    public static final int W = 166;
    public static final int H = 80;

    private static class Data {
        final boolean isShapeValid;
        final boolean hasActiveRecipe;
        final float progress;
        final int efficiencyTicks;
        final int maxEfficiencyTicks;
        final long currentRecipeEu;
        final long baseRecipeEu;

        private Data() {
            this(false);
        }

        private Data(boolean isShapeValid) {
            this.isShapeValid = isShapeValid;
            this.hasActiveRecipe = false;
            this.efficiencyTicks = 0;
            this.progress = 0.0f;
            this.maxEfficiencyTicks = 0;
            this.currentRecipeEu = 0L;
            this.baseRecipeEu = 0L;
        }

        private Data(float progress, int efficiencyTicks, int maxEfficiencyTicks, long currentRecipeEu, long baseRecipeEu) {
            this.efficiencyTicks = efficiencyTicks;
            this.progress = progress;
            this.maxEfficiencyTicks = maxEfficiencyTicks;
            this.isShapeValid = true;
            this.hasActiveRecipe = true;
            this.currentRecipeEu = currentRecipeEu;
            this.baseRecipeEu = baseRecipeEu;
        }
    }

    public static class Server
    implements GuiComponent.Server<Data> {
        private final CrafterComponent crafter;
        private final Supplier<Boolean> isShapeValid;
        private final Supplier<Float> progressSupplier;

        public Server(Supplier<Boolean> isShapeValid, Supplier<Float> progressSupplier, CrafterComponent crafter) {
            this.isShapeValid = isShapeValid;
            this.crafter = crafter;
            this.progressSupplier = progressSupplier;
        }

        @Override
        public Data copyData() {
            if (this.isShapeValid.get().booleanValue()) {
                if (this.crafter.hasActiveRecipe()) {
                    return new Data(this.progressSupplier.get().floatValue(), this.crafter.getEfficiencyTicks(), this.crafter.getMaxEfficiencyTicks(), this.crafter.getCurrentRecipeEu(), this.crafter.getBaseRecipeEu());
                }
                return new Data(true);
            }
            return new Data();
        }

        @Override
        public boolean needsSync(Data cachedData) {
            boolean recipe = false;
            if (this.crafter.hasActiveRecipe()) {
                recipe = this.crafter.getCurrentRecipeEu() != cachedData.currentRecipeEu || this.crafter.getBaseRecipeEu() != cachedData.baseRecipeEu;
            }
            return cachedData.isShapeValid != this.isShapeValid.get() || cachedData.hasActiveRecipe != this.crafter.hasActiveRecipe() || cachedData.progress != this.progressSupplier.get().floatValue() || this.crafter.getEfficiencyTicks() != cachedData.efficiencyTicks || this.crafter.getMaxEfficiencyTicks() != cachedData.maxEfficiencyTicks || recipe;
        }

        @Override
        public void writeInitialData(class_2540 buf) {
            this.writeCurrentData(buf);
        }

        @Override
        public void writeCurrentData(class_2540 buf) {
            if (this.isShapeValid.get().booleanValue()) {
                buf.writeBoolean(true);
                if (this.crafter.hasActiveRecipe()) {
                    buf.writeBoolean(true);
                    buf.writeFloat(this.progressSupplier.get().floatValue());
                    buf.writeInt(this.crafter.getEfficiencyTicks());
                    buf.writeInt(this.crafter.getMaxEfficiencyTicks());
                    buf.writeLong(this.crafter.getCurrentRecipeEu());
                    buf.writeLong(this.crafter.getBaseRecipeEu());
                } else {
                    buf.writeBoolean(false);
                }
            } else {
                buf.writeBoolean(false);
            }
        }

        @Override
        public class_2960 getId() {
            return GuiComponents.CRAFTING_MULTIBLOCK_GUI;
        }
    }
}

