/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlock;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlockEntity;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelItem;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.part.PartEnglishNameFormatter;
import aztech.modern_industrialization.materials.part.PartKey;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.part.PartTemplate;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import aztech.modern_industrialization.proxy.CommonProxy;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2343;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_4946;
import net.minecraft.class_7923;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class BarrelPart
implements PartKeyProvider {
    @Override
    public PartKey key() {
        return new PartKey("barrel");
    }

    public PartTemplate of(String nameOverride, String pathOverride, int stackCapacity) {
        return this.of(new PartEnglishNameFormatter.Overridden(nameOverride), Long.valueOf(stackCapacity), pathOverride);
    }

    public PartTemplate of(long stackCapacity) {
        return this.of(new PartEnglishNameFormatter.Default("Barrel"), stackCapacity, null);
    }

    private PartTemplate of(PartEnglishNameFormatter englishNameFormatter, Long stackCapacity, @Nullable String maybeOverriddenPath) {
        MutableObject bet = new MutableObject();
        PartTemplate template = new PartTemplate(englishNameFormatter, this.key()).asColumnBlock(SortOrder.BARRELS).withRegister((partContext, part, itemPath, itemId, itemTag, englishName) -> {
            BarrelBlock.BarrelStorage barrelStorageBehaviour = BarrelBlock.withStackCapacity(stackCapacity);
            class_2343 factory = (pos, state) -> new BarrelBlockEntity((class_2591)bet.getValue(), pos, state);
            BlockDefinition<BarrelBlock> blockDefinition = MIBlock.block(englishName, itemPath, MIBlock.BlockDefinitionParams.defaultStone().withBlockConstructor(s -> new BarrelBlock(factory, barrelStorageBehaviour)).withBlockItemConstructor(BarrelItem::new).withModel(class_4946.field_23038).withBlockEntityRendererItemModel().noLootTable().sortOrder(SortOrder.BARRELS.and(stackCapacity)));
            TagsToGenerate.generateTag(MITags.BARRELS, blockDefinition.method_8389(), "Barrels");
            BarrelBlock block = blockDefinition.asBlock();
            BarrelItem item = (BarrelItem)blockDefinition.method_8389();
            bet.setValue((Object)((class_2591)class_2378.method_10226((class_2378)class_7923.field_41181, (String)itemId, (Object)FabricBlockEntityTypeBuilder.create((arg_0, arg_1) -> ((class_2343)block.factory).method_10123(arg_0, arg_1), (class_2248[])new class_2248[]{block}).build(null))));
            ItemStorage.SIDED.registerSelf(new class_2591[]{(class_2591)bet.getValue()});
            CommonProxy.INSTANCE.registerPartBarrelClient(block, (class_1792)item, partContext.getMaterialName(), itemPath, (class_2591<BarrelBlockEntity>)((class_2591)bet.getValue()), partContext.get(MaterialProperty.MEAN_RGB));
        });
        if (maybeOverriddenPath != null) {
            template = template.withCustomPath(maybeOverriddenPath);
        }
        return template;
    }
}

