/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.api;

import aztech.modern_industrialization.pipes.api.PipeNetwork;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public final class PipeNetworkType
implements Comparable<PipeNetworkType> {
    private final class_2960 identifier;
    private final BiFunction<Integer, PipeNetworkData, PipeNetwork> networkCtor;
    private final Supplier<PipeNetworkNode> nodeCtor;
    private final int serialNumber;
    private final int color;
    private final boolean opensGui;
    Object renderer;
    private static Map<class_2960, PipeNetworkType> types = new HashMap<class_2960, PipeNetworkType>();
    private static int nextSerialNumber = 0;

    private PipeNetworkType(class_2960 identifier, BiFunction<Integer, PipeNetworkData, PipeNetwork> networkCtor, Supplier<PipeNetworkNode> nodeCtor, int color, boolean opensGui, int serialNumber) {
        this.identifier = identifier;
        this.networkCtor = networkCtor;
        this.nodeCtor = nodeCtor;
        this.color = color;
        this.opensGui = opensGui;
        this.serialNumber = serialNumber;
    }

    public class_2960 getIdentifier() {
        return this.identifier;
    }

    BiFunction<Integer, PipeNetworkData, PipeNetwork> getNetworkCtor() {
        return this.networkCtor;
    }

    public Supplier<PipeNetworkNode> getNodeCtor() {
        return this.nodeCtor;
    }

    public int getColor() {
        return this.color;
    }

    public boolean opensGui() {
        return this.opensGui;
    }

    public static PipeNetworkType get(class_2960 identifier) {
        return types.get(identifier);
    }

    public static Map<class_2960, PipeNetworkType> getTypes() {
        return new HashMap<class_2960, PipeNetworkType>(types);
    }

    public static PipeNetworkType register(class_2960 identifier, BiFunction<Integer, PipeNetworkData, PipeNetwork> networkCtor, Supplier<PipeNetworkNode> nodeCtor, int color, boolean opensGui) {
        PipeNetworkType type;
        PipeNetworkType previousType;
        if ((previousType = types.put(identifier, type = new PipeNetworkType(identifier, networkCtor, nodeCtor, color |= 0xFF000000, opensGui, nextSerialNumber++))) != null) {
            throw new IllegalArgumentException("Attempting to register another PipeNetworkType with the same identifier.");
        }
        return type;
    }

    @Override
    public int compareTo(PipeNetworkType o) {
        return Integer.compare(this.serialNumber, o.serialNumber);
    }
}

