/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.gui;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.client.screen.MIHandledScreen;
import aztech.modern_industrialization.pipes.gui.ConnectionTypeButton;
import aztech.modern_industrialization.pipes.gui.PriorityButton;
import aztech.modern_industrialization.pipes.gui.PriorityDisplay;
import aztech.modern_industrialization.pipes.gui.iface.ConnectionTypeInterface;
import aztech.modern_industrialization.pipes.gui.iface.PriorityInterface;
import aztech.modern_industrialization.pipes.impl.PipePackets;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public abstract class PipeScreen<SH extends class_1703>
extends MIHandledScreen<SH> {
    public PipeScreen(SH handler, class_1661 inventory, class_2561 title, int backgroundHeight) {
        super(handler, inventory, title);
        this.field_2779 = backgroundHeight;
        this.field_25270 = this.field_2779 - 94;
    }

    protected abstract class_2960 getBackgroundTexture();

    protected void method_2389(class_332 guiGraphics, float delta, int mouseX, int mouseY) {
        this.method_25420(guiGraphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_25302(this.getBackgroundTexture(), this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void addPriorityWidgets(int startX, int startY, PriorityInterface priority, String tooltipType, int channel) {
        Supplier<List<class_2561>> tooltip = () -> {
            ArrayList<class_5250> lines = new ArrayList<class_5250>();
            MIText priorityText = switch (tooltipType) {
                case "transfer" -> MIText.PriorityTransfer;
                case "insert" -> MIText.PriorityInsert;
                case "extract" -> MIText.PriorityExtract;
                default -> throw new IllegalArgumentException("tooltipType : " + tooltipType + " must be either transfer, insert or extract");
            };
            MIText priorityTextHelp = switch (tooltipType) {
                case "transfer" -> MIText.PriorityTransferHelp;
                case "insert" -> MIText.PriorityInsertHelp;
                case "extract" -> MIText.PriorityExtractHelp;
                default -> throw new IllegalArgumentException("tooltipTypeHelp : " + tooltipType + " must be either transfer, insert or extract");
            };
            lines.add(priorityText.text(priority.getPriority(channel)));
            lines.add(priorityTextHelp.text().method_10862(TextHelper.GRAY_TEXT));
            return lines;
        };
        this.addPriorityButton(startX, startY, 20, 12, "--", -10, priority, channel, tooltip);
        this.addPriorityButton(startX + 22, startY, 12, 0, "-", -1, priority, channel, tooltip);
        this.addPriorityButton(startX + 62, startY, 12, 0, "+", 1, priority, channel, tooltip);
        this.addPriorityButton(startX + 76, startY, 20, 12, "++", 10, priority, channel, tooltip);
        this.method_37063((class_364)new PriorityDisplay(startX + 34 + this.field_2776, startY + this.field_2800, 28, 12, (class_2561)class_2561.method_43470((String)""), tooltip, () -> priority.getPriority(channel), this.field_22793));
    }

    private void addPriorityButton(int x, int y, int width, int u, String text, int delta, PriorityInterface priority, int channel, Supplier<List<class_2561>> priorityTooltip) {
        this.method_37063((class_364)new PriorityButton(x + this.field_2776, y + this.field_2800, width, u, text, button -> {
            priority.incrementPriority(channel, delta);
            class_2540 buf = PacketByteBufs.create();
            buf.writeInt(this.field_2797.field_7763);
            buf.writeInt(channel);
            buf.writeInt(delta);
            ClientPlayNetworking.send((class_2960)PipePackets.INCREMENT_PRIORITY, (class_2540)buf);
        }, priorityTooltip));
    }

    protected int connectionTypeForward(ConnectionTypeInterface connectionType) {
        return (connectionType.getConnectionType() + 1) % 3;
    }

    protected int connectionTypeBackward(ConnectionTypeInterface connectionType) {
        return (connectionType.getConnectionType() + 2) % 3;
    }

    protected int connectionTypeNext(ConnectionTypeInterface connectionType) {
        if (!PipeScreen.method_25442()) {
            return this.connectionTypeForward(connectionType);
        }
        return this.connectionTypeBackward(connectionType);
    }

    protected static class_2561 getConnectionTypeText(int connectionType) {
        return switch (connectionType) {
            case 0 -> MIText.PipeConnectionTooltipInsertOnly.text();
            case 1 -> MIText.PipeConnectionTooltipInsertOrExtract.text();
            case 2 -> MIText.PipeConnectionTooltipExtractOnly.text();
            default -> throw new IllegalArgumentException("Connection Type " + connectionType + " must be either 0, 1, 2");
        };
    }

    protected void addConnectionTypeButton(int x, int y, ConnectionTypeInterface connectionType) {
        this.method_37063((class_364)new ConnectionTypeButton(x + this.field_2776, y + this.field_2800, widget -> {
            int newType = this.connectionTypeNext(connectionType);
            connectionType.setConnectionType(newType);
            class_2540 buf = PacketByteBufs.create();
            buf.writeInt(this.field_2797.field_7763);
            buf.writeInt(newType);
            ClientPlayNetworking.send((class_2960)PipePackets.SET_CONNECTION_TYPE, (class_2540)buf);
        }, () -> {
            ArrayList<Object> lines = new ArrayList<Object>();
            class_2561 component = PipeScreen.getConnectionTypeText(connectionType.getConnectionType());
            lines.add(component);
            lines.add(MIText.PipeConnectionHelp.text().method_10862(TextHelper.GRAY_TEXT));
            return lines;
        }, connectionType));
    }
}

