/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.textures.coloramp;

import aztech.modern_industrialization.textures.TextureHelper;
import aztech.modern_industrialization.textures.TextureManager;
import aztech.modern_industrialization.textures.coloramp.IColoramp;
import java.io.IOException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;

@Environment(value=EnvType.CLIENT)
public class Coloramp
implements IColoramp {
    private final int[] colors;
    private final int meanRGB;

    public Coloramp(TextureManager mtm, int meanRGB, String name) {
        block10: {
            this.colors = new int[256];
            this.meanRGB = meanRGB;
            String gradientMapPath = "modern_industrialization:textures/gradient_maps/" + name + ".png";
            if (mtm.hasAsset(gradientMapPath)) {
                try (class_1011 gradientMap = mtm.getAssetAsTexture(gradientMapPath);){
                    for (int i = 0; i < 256; ++i) {
                        int color = gradientMap.method_4315(i, 0);
                        int r = TextureHelper.getR(color);
                        int g = TextureHelper.getG(color);
                        int b = TextureHelper.getB(color);
                        this.colors[i] = r << 16 | g << 8 | b;
                    }
                    break block10;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.fillUniform();
        }
    }

    public Coloramp(int meanRGB) {
        this.colors = new int[256];
        this.meanRGB = meanRGB;
        this.fillUniform();
    }

    private void fillUniform() {
        int meanR = TextureHelper.getRrgb(this.meanRGB);
        int meanG = TextureHelper.getGrgb(this.meanRGB);
        int meanB = TextureHelper.getBrgb(this.meanRGB);
        for (int i = 0; i < 256; ++i) {
            this.colors[i] = TextureHelper.toRGB(meanR * i / 255, meanG * i / 255, meanB * i / 255);
        }
    }

    @Override
    public int getRGB(double luminance) {
        int i = (int)(luminance * 255.0);
        return this.colors[i];
    }

    @Override
    public int getMeanRGB() {
        return this.meanRGB;
    }
}

