/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen;

import de.keksuccino.drippyloadingscreen.DrippyEvents;
import de.keksuccino.drippyloadingscreen.Options;
import de.keksuccino.drippyloadingscreen.customization.DrippyOverlayScreen;
import de.keksuccino.drippyloadingscreen.customization.backgrounds.Backgrounds;
import de.keksuccino.drippyloadingscreen.customization.elements.Elements;
import de.keksuccino.drippyloadingscreen.customization.placeholders.Placeholders;
import de.keksuccino.drippyloadingscreen.platform.Services;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.screen.identifier.UniversalScreenIdentifierRegistry;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.file.FileUtils;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DrippyLoadingScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String VERSION = "3.0.2";
    public static final String MOD_LOADER = Services.PLATFORM.getPlatformName();
    public static final String MOD_ID = "drippyloadingscreen";
    public static final File MOD_DIR = DrippyLoadingScreen.createDirectory(new File(GameDirectoryUtils.getGameDirectory(), "/config/drippyloadingscreen"));
    private static Options options;
    private static boolean initialized;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (Services.PLATFORM.isOnClient()) {
            LOGGER.info("[DRIPPY LOADING SCREEN] Loading v3.0.2 in client-side mode on " + MOD_LOADER.toUpperCase() + "!");
        } else {
            LOGGER.info("[DRIPPY LOADING SCREEN] Loading v3.0.2 in server-side mode on " + MOD_LOADER.toUpperCase() + "!");
        }
        if (Services.PLATFORM.isOnClient()) {
            EventHandler.INSTANCE.registerListenersOf((Object)new DrippyEvents());
        }
    }

    public static void registerAll() {
        if (Services.PLATFORM.isOnClient()) {
            UniversalScreenIdentifierRegistry.register((String)"drippy_loading_overlay", (String)DrippyOverlayScreen.class.getName());
            ScreenCustomization.addScreenBlacklistRule(s -> s.startsWith("de.keksuccino.drippyloadingscreen.customization.backgrounds."));
            Backgrounds.registerAll();
            Placeholders.registerAll();
            Elements.registerAll();
        }
    }

    public static Options getOptions() {
        if (options == null) {
            DrippyLoadingScreen.reloadOptions();
        }
        return options;
    }

    public static void reloadOptions() {
        options = new Options();
    }

    private static File createDirectory(@NotNull File directory) {
        return FileUtils.createDirectory((File)directory);
    }

    static {
        initialized = false;
    }
}

