/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.nicguzzo.wands.config.WandsConfig;
import net.nicguzzo.wands.items.MagicBagItem;
import net.nicguzzo.wands.items.PaletteItem;
import net.nicguzzo.wands.items.WandItem;
import net.nicguzzo.wands.menues.MagicBagMenu;
import net.nicguzzo.wands.menues.PaletteMenu;
import net.nicguzzo.wands.menues.WandMenu;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.utils.WandUtils;
import net.nicguzzo.wands.wand.PlayerWand;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandProps;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WandsMod {
    public static int platform = -1;
    public static final WandsConfig config = WandsConfig.get_instance();
    public static final String MOD_ID = "wands";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Supplier<RegistrarManager> REGISTRIES = Suppliers.memoize(() -> RegistrarManager.get((String)MOD_ID));
    public static final DeferredRegister<class_1761> TABS = DeferredRegister.create((String)"wands", (class_5321)class_7924.field_44688);
    public static final RegistrySupplier<class_1761> WANDS_TAB = TABS.register("wands_tab", () -> CreativeTabRegistry.create((class_2561)class_2561.method_43471((String)"itemGroup.wands.wands_tab"), () -> new class_1799((class_1935)DIAMOND_WAND_ITEM.get())));
    public static final DeferredRegister<class_1792> ITEMS = DeferredRegister.create((String)"wands", (class_5321)class_7924.field_41197);
    public static final DeferredRegister<class_3917<?>> MENUES = DeferredRegister.create((String)"wands", (class_5321)class_7924.field_41207);
    public static final RegistrySupplier<class_1792> STONE_WAND_ITEM = ITEMS.register("stone_wand", () -> new WandItem((class_1832)class_1834.field_8927, WandsMod.config.stone_wand_limit, false, false, false, false, new class_1792.class_1793().method_7895(WandsMod.config.stone_wand_durability).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<class_1792> IRON_WAND_ITEM = ITEMS.register("iron_wand", () -> new WandItem((class_1832)class_1834.field_8923, WandsMod.config.iron_wand_limit, false, false, false, false, new class_1792.class_1793().method_7895(WandsMod.config.iron_wand_durability).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<class_1792> DIAMOND_WAND_ITEM = ITEMS.register("diamond_wand", () -> new WandItem((class_1832)class_1834.field_8930, WandsMod.config.diamond_wand_limit, true, false, false, false, new class_1792.class_1793().method_7895(WandsMod.config.diamond_wand_durability).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<class_1792> NETHERITE_WAND_ITEM = ITEMS.register("netherite_wand", () -> new WandItem((class_1832)class_1834.field_22033, WandsMod.config.netherite_wand_limit, true, true, false, true, new class_1792.class_1793().method_24359().method_7895(WandsMod.config.netherite_wand_durability).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<class_1792> CREATIVE_WAND_ITEM = ITEMS.register("creative_wand", () -> new WandItem((class_1832)class_1834.field_22033, WandsMod.config.creative_wand_limit, true, true, true, true, new class_1792.class_1793().method_24359().method_7889(1).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<class_1792> PALETTE_ITEM = ITEMS.register("palette", () -> new PaletteItem(new class_1792.class_1793().method_7889(1).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<class_1792> MAGIC_BAG_1 = ITEMS.register("magic_bag_1", () -> new MagicBagItem(0, WandsMod.config.magic_bag_1_limit, new class_1792.class_1793().method_7889(1).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<class_1792> MAGIC_BAG_2 = ITEMS.register("magic_bag_2", () -> new MagicBagItem(1, WandsMod.config.magic_bag_2_limit, new class_1792.class_1793().method_7889(1).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<class_1792> MAGIC_BAG_3 = ITEMS.register("magic_bag_3", () -> new MagicBagItem(2, Integer.MAX_VALUE, new class_1792.class_1793().method_7889(1).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<class_3917<PaletteMenu>> PALETTE_CONTAINER = MENUES.register("palette_menu", () -> MenuRegistry.ofExtended(PaletteMenu::new));
    public static final RegistrySupplier<class_3917<WandMenu>> WAND_CONTAINER = MENUES.register("wand_menu", () -> MenuRegistry.ofExtended(WandMenu::new));
    public static final RegistrySupplier<class_3917<MagicBagMenu>> MAGIC_WAND_CONTANIER = MENUES.register("magic_bag_menu", () -> MenuRegistry.ofExtended(MagicBagMenu::new));
    public static class_2960 KB_PACKET = new class_2960("wands", "key_packet");
    public static class_2960 SND_PACKET = new class_2960("wands", "sound_packet");
    public static class_2960 PALETTE_PACKET = new class_2960("wands", "palette_packet");
    public static class_2960 STATE_PACKET = new class_2960("wands", "state_packet");
    public static class_2960 WAND_PACKET = new class_2960("wands", "wand_packet");
    public static class_2960 POS_PACKET = new class_2960("wands", "pos_packet");
    public static class_2960 CONF_PACKET = new class_2960("wands", "conf_packet");
    public static class_2960 GLOBAL_SETTINGS_PACKET = new class_2960("wands", "global_settings_packet");
    public static boolean is_forge = false;

    public static void init() {
        ITEMS.register();
        MENUES.register();
        TABS.register();
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)KB_PACKET, (packet, context) -> {
            int key = packet.readInt();
            boolean shift = packet.readBoolean();
            boolean alt = packet.readBoolean();
            context.queue(() -> WandsMod.process_keys(context.getPlayer(), key, shift, alt));
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)PALETTE_PACKET, (packet, context) -> {
            boolean mode = packet.readBoolean();
            boolean rotate = packet.readBoolean();
            context.queue(() -> WandsMod.process_palette(context.getPlayer(), mode, rotate));
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)WAND_PACKET, (packet, context) -> {
            class_1799 item = packet.method_10819();
            context.queue(() -> {
                class_1799 wand_stack = context.getPlayer().method_6047();
                class_2487 tag = item.method_7969();
                if (tag != null) {
                    wand_stack.method_7980(tag);
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)POS_PACKET, (packet, context) -> {
            class_1657 player = context.getPlayer();
            if (player == null) {
                LOGGER.error("player is null");
                return;
            }
            class_1937 level = Compat.player_level(player);
            class_1799 stack = context.getPlayer().method_6047();
            if (!WandUtils.is_wand(stack)) {
                LOGGER.error("player doesn't have a wand in main hand");
                return;
            }
            Wand wand = PlayerWand.get(player);
            if (wand == null) {
                LOGGER.error("wand is null");
                return;
            }
            int d = packet.readInt();
            class_2350 side = class_2350.values()[d];
            if (!packet.readBoolean()) {
                Object p1 = null;
                LOGGER.info("needs at least 1 position");
                return;
            }
            class_2338 p1 = packet.method_10811();
            class_2338 p2 = packet.readBoolean() ? packet.method_10811() : null;
            double hit_x = packet.readDouble();
            double hit_y = packet.readDouble();
            double hit_z = packet.readDouble();
            long seed = packet.readLong();
            class_243 hit = new class_243(hit_x, hit_y, hit_z);
            context.queue(() -> {
                class_2338 pos;
                class_2680 block_state;
                if (p2 != null) {
                    block_state = level.method_8320(p2);
                    pos = p2;
                } else {
                    block_state = level.method_8320(p1);
                    pos = p1;
                }
                wand.setP1(p1);
                wand.setP2(p2);
                wand.palette.seed = seed;
                wand.do_or_preview(player, level, block_state, pos, side, hit, stack, (WandItem)stack.method_7909(), true);
                wand.clear();
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)GLOBAL_SETTINGS_PACKET, (packet, context) -> {
            boolean drop_pos = packet.readBoolean();
            context.queue(() -> {
                Wand wand;
                class_1657 player = context.getPlayer();
                if (player != null && (wand = PlayerWand.get(player)) != null) {
                    wand.drop_on_player = drop_pos;
                }
            });
        });
        PlayerEvent.PLAYER_JOIN.register(player -> {
            LOGGER.info("PLAYER_JOIN");
            Wand wand = null;
            wand = PlayerWand.get((class_1657)player);
            if (wand == null) {
                PlayerWand.add_player((class_1657)player);
                wand = PlayerWand.get((class_1657)player);
            }
            if (!Compat.player_level((class_1657)player).method_8608() && config != null) {
                class_2540 packet = new class_2540(Unpooled.buffer());
                packet.writeFloat(WandsMod.config.blocks_per_xp);
                packet.writeBoolean(WandsMod.config.destroy_in_survival_drop);
                packet.writeBoolean(WandsMod.config.survival_unenchanted_drops);
                packet.writeBoolean(WandsMod.config.allow_wand_to_break);
                packet.writeBoolean(WandsMod.config.allow_offhand_to_break);
                packet.writeBoolean(WandsMod.config.mend_tools);
                NetworkManager.sendToPlayer((class_3222)player, (class_2960)CONF_PACKET, (class_2540)packet);
                LOGGER.info("config sent");
            }
        });
        PlayerEvent.PLAYER_QUIT.register(player -> PlayerWand.remove_player((class_1657)player));
    }

    public static void send_state(class_3222 player, Wand wand) {
        class_1799 wand_stack;
        if (wand != null && player != null && !Compat.player_level((class_1657)player).method_8608() && (wand_stack = player.method_6047()).method_7909() instanceof WandItem) {
            WandProps.Mode mode = WandProps.getMode(wand_stack);
            class_2540 packet = new class_2540(Unpooled.buffer());
            int slot = 0;
            if (wand.palette.palette_slots.size() != 0) {
                slot = (wand.palette.slot + 1) % wand.palette.palette_slots.size();
            }
            float BLOCKS_PER_XP = WandsMod.config.blocks_per_xp;
            packet.writeInt(mode.ordinal());
            packet.writeInt(slot);
            packet.writeBoolean(BLOCKS_PER_XP != 0.0f);
            packet.writeInt(player.field_7520);
            packet.writeFloat(player.field_7510);
            NetworkManager.sendToPlayer((class_3222)player, (class_2960)STATE_PACKET, (class_2540)packet);
        }
    }

    public static void process_palette(class_1657 player, boolean mode, boolean rotate) {
        class_1799 item_stack = player.method_6047();
        class_1799 palette = null;
        if (!item_stack.method_7960() && item_stack.method_7909() instanceof PaletteItem) {
            palette = item_stack;
        } else {
            class_1799 offhand_stack = player.method_6079();
            if (!offhand_stack.method_7960() && offhand_stack.method_7909() instanceof PaletteItem) {
                palette = offhand_stack;
            }
        }
        if (palette != null) {
            if (mode) {
                PaletteItem.nextMode(palette);
            }
            if (rotate) {
                PaletteItem.toggleRotate(palette);
            }
        }
    }

    public static void process_keys(class_1657 player, int key, boolean shift, boolean alt) {
        Wand wand;
        class_1799 main_stack = player.method_6047();
        class_1799 offhand_stack = player.method_6079();
        boolean is_wand = main_stack.method_7909() instanceof WandItem;
        boolean is_palette = main_stack.method_7909() instanceof PaletteItem || offhand_stack.method_7909() instanceof PaletteItem;
        boolean creative = Compat.is_creative(player);
        if (is_palette && key >= 0 && key < WandKeys.values().length) {
            switch (WandKeys.values()[key]) {
                case PALETTE_MENU: {
                    if (offhand_stack.method_7909() instanceof PaletteItem) {
                        Compat.open_menu((class_3222)player, offhand_stack, 1);
                        break;
                    }
                    class_1799 mainhand_stack = player.method_6047();
                    if (!(mainhand_stack.method_7909() instanceof PaletteItem)) break;
                    Compat.open_menu((class_3222)player, mainhand_stack, 1);
                    break;
                }
                case PALETTE_MODE: {
                    if (offhand_stack.method_7960() || !(offhand_stack.method_7909() instanceof PaletteItem)) break;
                    PaletteItem.nextMode(offhand_stack);
                    player.method_7353((class_2561)Compat.literal("Palette mode: " + PaletteItem.getMode(offhand_stack)), false);
                }
            }
        }
        if (is_wand) {
            int inc;
            wand = PlayerWand.get(player);
            WandItem wand_item = (WandItem)main_stack.method_7909();
            if (wand == null) {
                return;
            }
            WandProps.Mode mode = WandProps.getMode(main_stack);
            int n = inc = shift ? 10 : 1;
            if (key >= 0 && key < WandKeys.values().length) {
                block4 : switch (WandKeys.values()[key]) {
                    case INC_SEL_BLK: {
                        WandProps.toggleFlag(main_stack, WandProps.Flag.INCSELBLOCK);
                        break;
                    }
                    case DIAGONAL_SPREAD: {
                        WandProps.toggleFlag(main_stack, WandProps.Flag.DIAGSPREAD);
                        break;
                    }
                    case TOGGLE_STAIRSLAB: {
                        WandProps.setStateMode(main_stack, WandProps.StateMode.APPLY);
                        WandProps.toggleFlag(main_stack, WandProps.Flag.STAIRSLAB);
                        break;
                    }
                    case N_INC: {
                        if (mode != WandProps.Mode.GRID) break;
                        WandProps.incGrid(main_stack, WandProps.Value.GRIDN, inc, wand_item.limit);
                        break;
                    }
                    case N_DEC: {
                        if (mode != WandProps.Mode.GRID) break;
                        WandProps.decVal(main_stack, WandProps.Value.GRIDN, inc);
                        break;
                    }
                    case M_INC: {
                        switch (mode) {
                            case DIRECTION: {
                                WandProps.incVal(main_stack, WandProps.Value.MULTIPLIER, inc);
                                break;
                            }
                            case ROW_COL: {
                                WandProps.incVal(main_stack, WandProps.Value.ROWCOLLIM, inc);
                                break;
                            }
                            case GRID: {
                                WandProps.incGrid(main_stack, WandProps.Value.GRIDM, inc, wand_item.limit);
                                break;
                            }
                            case AREA: {
                                WandProps.incVal(main_stack, WandProps.Value.AREALIM, inc);
                            }
                        }
                        break;
                    }
                    case M_DEC: {
                        switch (mode) {
                            case DIRECTION: {
                                WandProps.decVal(main_stack, WandProps.Value.MULTIPLIER, inc);
                                break;
                            }
                            case ROW_COL: {
                                WandProps.decVal(main_stack, WandProps.Value.ROWCOLLIM, inc);
                                break;
                            }
                            case GRID: {
                                WandProps.decVal(main_stack, WandProps.Value.GRIDM, inc);
                                break;
                            }
                            case AREA: {
                                WandProps.decVal(main_stack, WandProps.Value.AREALIM, inc);
                            }
                        }
                        break;
                    }
                    case ACTION: {
                        if (shift) {
                            WandProps.prevAction(main_stack);
                        } else {
                            WandProps.nextAction(main_stack);
                        }
                        player.method_7353((class_2561)Compat.literal("Wand Action: ").method_10852((class_2561)Compat.translatable(WandProps.getAction(main_stack).toString())), false);
                        break;
                    }
                    case MENU: {
                        Compat.open_menu((class_3222)player, main_stack, 0);
                        break;
                    }
                    case MODE: {
                        if (shift) {
                            WandProps.prevMode(main_stack, wand_item.can_blast);
                            break;
                        }
                        WandProps.nextMode(main_stack, wand_item.can_blast);
                        break;
                    }
                    case ORIENTATION: {
                        switch (mode) {
                            case CIRCLE: 
                            case FILL: {
                                WandProps.nextPlane(main_stack);
                                player.method_7353((class_2561)Compat.literal("Wand Plane: " + WandProps.getPlane(main_stack)), false);
                                WandsMod.send_state((class_3222)player, wand);
                                break block4;
                            }
                            case DIRECTION: 
                            case PASTE: {
                                break block4;
                            }
                        }
                        WandProps.nextOrientation(main_stack);
                        player.method_7353((class_2561)Compat.literal("Wand Orientation: ").method_10852((class_2561)Compat.translatable(WandProps.getOrientation(main_stack).toString())), false);
                        break;
                    }
                    case INVERT: {
                        WandProps.toggleFlag(main_stack, WandProps.Flag.INVERTED);
                        player.method_7353((class_2561)Compat.literal("Wand inverted: " + WandProps.getFlag(main_stack, WandProps.Flag.INVERTED)), false);
                        break;
                    }
                    case FILL: {
                        switch (wand.mode) {
                            case FILL: {
                                WandProps.toggleFlag(main_stack, WandProps.Flag.RFILLED);
                                player.method_7353((class_2561)Compat.literal("Wand fill rect: " + WandProps.getFlag(main_stack, WandProps.Flag.RFILLED)), false);
                                break;
                            }
                            case CIRCLE: {
                                WandProps.toggleFlag(main_stack, WandProps.Flag.CFILLED);
                                player.method_7353((class_2561)Compat.literal("Wand circle fill: " + WandProps.getFlag(main_stack, WandProps.Flag.CFILLED)), false);
                            }
                        }
                        break;
                    }
                    case ROTATE: {
                        WandProps.nextRotation(main_stack);
                        WandProps.setStateMode(main_stack, WandProps.StateMode.APPLY);
                        break;
                    }
                    case UNDO: {
                        if (!creative || Compat.player_level(player).method_8608() || wand == null) break;
                        int n2 = 1;
                        if (alt) {
                            n2 = 10;
                        }
                        if (shift) {
                            wand.redo(n2);
                            break;
                        }
                        wand.undo(n2);
                        break;
                    }
                    case CLEAR: {
                        if (wand != null) {
                            wand.clear();
                        }
                        if (player == null) break;
                        player.method_7353((class_2561)Compat.literal("wand cleared"), false);
                    }
                }
            }
        }
        if (!main_stack.method_7960() && main_stack.method_7909() instanceof PaletteItem && key >= 0 && key < WandKeys.values().length && Objects.requireNonNull(WandKeys.values()[key]) == WandKeys.PALETTE_MODE) {
            PaletteItem.nextMode(main_stack);
            player.method_7353((class_2561)Compat.literal("Palette mode: " + PaletteItem.getMode(main_stack)), false);
        }
        if (is_wand && key < 0) {
            wand = null;
            if (!Compat.player_level(player).method_8608() && (wand = PlayerWand.get(player)) == null) {
                PlayerWand.add_player(player);
                wand = PlayerWand.get(player);
            }
            if (wand != null) {
                wand.is_alt_pressed = alt;
                wand.is_shift_pressed = shift;
            }
        }
    }

    public static void log(String s, boolean b) {
        if (b) {
            LOGGER.info(s);
        }
    }

    public static enum WandKeys {
        MENU,
        MODE,
        ACTION,
        ORIENTATION,
        UNDO,
        INVERT,
        FILL,
        ROTATE,
        CONF,
        M_INC,
        M_DEC,
        N_INC,
        N_DEC,
        TOGGLE_STAIRSLAB,
        DIAGONAL_SPREAD,
        INC_SEL_BLK,
        PALETTE_MODE,
        PALETTE_MENU,
        CLEAR;

    }
}

