/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.wand;

import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.nicguzzo.wands.WandsMod;
import net.nicguzzo.wands.utils.WandUtils;
import net.nicguzzo.wands.wand.WandMode;
import net.nicguzzo.wands.wand.modes.AreaMode;
import net.nicguzzo.wands.wand.modes.BlastMode;
import net.nicguzzo.wands.wand.modes.CircleMode;
import net.nicguzzo.wands.wand.modes.CopyMode;
import net.nicguzzo.wands.wand.modes.DirectionMode;
import net.nicguzzo.wands.wand.modes.FillMode;
import net.nicguzzo.wands.wand.modes.GridMode;
import net.nicguzzo.wands.wand.modes.LineMode;
import net.nicguzzo.wands.wand.modes.PasteMode;
import net.nicguzzo.wands.wand.modes.RowColMode;
import net.nicguzzo.wands.wand.modes.TunnelMode;
import net.nicguzzo.wands.wand.modes.VeinMode;

public class WandProps {
    public static Mode[] modes = Mode.values();
    public static Action[] actions = Action.values();
    public static Orientation[] orientations = Orientation.values();
    public static Plane[] planes = Plane.values();
    public static class_2350.class_2351[] axes = class_2350.class_2351.values();
    public static class_2470[] rotations = class_2470.values();
    public static StateMode[] state_modes = StateMode.values();
    public static MirrorAxis[] mirrorAxes = MirrorAxis.values();

    public static boolean getFlag(class_1799 stack, Flag flag) {
        if (WandUtils.is_wand(stack)) {
            class_2487 tag = stack.method_7948();
            if (tag.method_10545(flag.toString())) {
                return tag.method_10577(flag.toString());
            }
            tag.method_10556(flag.toString(), flag.get_default());
            return flag.get_default();
        }
        return false;
    }

    public static void setFlag(class_1799 stack, Flag flag, boolean f) {
        if (WandUtils.is_wand(stack)) {
            stack.method_7948().method_10556(flag.toString(), f);
        }
    }

    public static void toggleFlag(class_1799 stack, Flag flag) {
        if (WandUtils.is_wand(stack)) {
            class_2487 tag = stack.method_7948();
            boolean b = WandProps.getFlag(stack, flag);
            tag.method_10556(flag.toString(), !b);
        }
    }

    public static void setVal(class_1799 stack, Value v, int n) {
        if (WandUtils.is_wand(stack)) {
            if (n > v.max) {
                n = v.max;
            }
            if (n < v.min) {
                n = v.min;
            }
            stack.method_7948().method_10569(v.toString(), n);
        }
    }

    public static void incVal(class_1799 stack, Value v, int inc, int max) {
        if (WandUtils.is_wand(stack)) {
            int n = stack.method_7948().method_10550(v.toString());
            if (n > v.max) {
                n = v.max;
            }
            if (n < v.min) {
                n = v.min;
            }
            if (n + inc <= max) {
                stack.method_7948().method_10569(v.toString(), n + inc);
            }
        }
    }

    public static void incVal(class_1799 stack, Value v, int inc) {
        WandProps.incVal(stack, v, inc, v.max);
    }

    public static void decVal(class_1799 stack, Value v, int inc, int min) {
        if (WandUtils.is_wand(stack)) {
            int n = stack.method_7948().method_10550(v.toString());
            if (n > v.max) {
                n = v.max;
            }
            if (n < v.min) {
                n = v.min;
            }
            if (n - inc >= min) {
                stack.method_7948().method_10569(v.toString(), n - inc);
            }
        }
    }

    public static void decVal(class_1799 stack, Value v, int dec) {
        WandProps.decVal(stack, v, dec, v.min);
    }

    public static int getVal(class_1799 stack, Value v) {
        if (!WandUtils.is_wand(stack)) {
            return -1;
        }
        int i = stack.method_7948().method_10550(v.toString());
        if (i > v.max) {
            i = v.max;
            stack.method_7948().method_10569(v.toString(), i);
        }
        if (i < v.min) {
            i = v.min;
            stack.method_7948().method_10569(v.toString(), i);
        }
        if (i < v.min) {
            return v.min;
        }
        if (i > v.max) {
            return v.max;
        }
        return i;
    }

    public static Mode getMode(class_1799 stack) {
        if (!WandUtils.is_wand(stack)) {
            return Mode.DIRECTION;
        }
        int m = stack.method_7948().method_10550("mode");
        if (m >= 0 && m < modes.length) {
            return modes[m];
        }
        return Mode.DIRECTION;
    }

    public static void setMode(class_1799 stack, Mode mode) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        stack.method_7948().method_10569("mode", mode.ordinal());
    }

    public static void nextMode(class_1799 stack, boolean can_blast) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        class_2487 tag = stack.method_7948();
        int mode = (tag.method_10550("mode") + 1) % modes.length;
        if (mode == Mode.VEIN.ordinal() && !WandsMod.config.enable_vein_mode) {
            mode = Mode.BLAST.ordinal();
        }
        if (!can_blast && mode == Mode.BLAST.ordinal() || !WandsMod.config.enable_blast_mode && mode == Mode.BLAST.ordinal()) {
            mode = Mode.DIRECTION.ordinal();
        }
        tag.method_10569("mode", mode);
    }

    public static void prevMode(class_1799 stack, boolean can_blast) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        class_2487 tag = stack.method_7948();
        int mode = tag.method_10550("mode") - 1;
        if (mode < 0) {
            mode = modes.length - 1;
        }
        if (!can_blast && mode == Mode.BLAST.ordinal() || !WandsMod.config.enable_blast_mode && mode == Mode.BLAST.ordinal()) {
            mode = Mode.BLAST.ordinal() - 1;
        }
        if (mode == Mode.VEIN.ordinal() && !WandsMod.config.enable_vein_mode) {
            mode = Mode.VEIN.ordinal() - 1;
        }
        tag.method_10569("mode", mode);
    }

    public static Orientation getOrientation(class_1799 stack) {
        if (!WandUtils.is_wand(stack)) {
            return Orientation.ROW;
        }
        return orientations[stack.method_7948().method_10550("orientation")];
    }

    public static void setOrientation(class_1799 stack, Orientation o) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        stack.method_7948().method_10569("orientation", o.ordinal());
    }

    public static void nextOrientation(class_1799 stack) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        class_2487 tag = stack.method_7948();
        int o = (tag.method_10550("orientation") + 1) % 2;
        tag.method_10569("orientation", o);
    }

    public static Plane getPlane(class_1799 stack) {
        Plane plane = Plane.XZ;
        if (!WandUtils.is_wand(stack)) {
            return plane;
        }
        int p = stack.method_7948().method_10550("plane");
        if (p >= 0 && p < planes.length) {
            plane = planes[p];
        }
        return plane;
    }

    public static void setPlane(class_1799 stack, Plane p) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        stack.method_7948().method_10569("plane", p.ordinal());
    }

    public static void nextPlane(class_1799 stack) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        class_2487 tag = stack.method_7948();
        int plane = (tag.method_10550("plane") + 1) % 3;
        tag.method_10569("plane", plane);
    }

    public static class_2470 getRotation(class_1799 stack) {
        if (!WandUtils.is_wand(stack)) {
            return class_2470.field_11467;
        }
        return rotations[stack.method_7948().method_10550("rotation")];
    }

    public static void nextRotation(class_1799 stack) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        class_2487 tag = stack.method_7948();
        int rot = (tag.method_10550("rotation") + 1) % rotations.length;
        tag.method_10569("rotation", rot);
    }

    public static void setRotation(class_1799 stack, class_2470 rot) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        stack.method_7948().method_10569("rotation", rot.ordinal());
    }

    public static Action getAction(class_1799 stack) {
        int m;
        if (WandUtils.is_wand(stack) && (m = stack.method_7948().method_10550("action")) < actions.length) {
            return actions[m];
        }
        return Action.PLACE;
    }

    public static void setAction(class_1799 stack, Action a) {
        if (WandUtils.is_wand(stack)) {
            class_2487 tag = stack.method_7948();
            if (WandsMod.config.disable_destroy_replace && (a == Action.DESTROY || a == Action.REPLACE)) {
                a = Action.PLACE;
            }
            tag.method_10569("action", a.ordinal());
        }
    }

    public static void nextAction(class_1799 stack) {
        if (WandUtils.is_wand(stack)) {
            class_2487 tag = stack.method_7948();
            int a = (tag.method_10550("action") + 1) % actions.length;
            if (WandsMod.config.disable_destroy_replace && (a == Action.DESTROY.ordinal() || a == Action.REPLACE.ordinal())) {
                a = Action.USE.ordinal();
            }
            tag.method_10569("action", a);
        }
    }

    public static void prevAction(class_1799 stack) {
        if (WandUtils.is_wand(stack)) {
            class_2487 tag = stack.method_7948();
            int a = tag.method_10550("action") - 1;
            if (a < 0) {
                a = actions.length - 1;
            }
            if (WandsMod.config.disable_destroy_replace && (a == Action.DESTROY.ordinal() || a == Action.REPLACE.ordinal())) {
                a = Action.PLACE.ordinal();
            }
            tag.method_10569("action", a);
        }
    }

    public static class_2350.class_2351 getAxis(class_1799 stack) {
        int p;
        class_2350.class_2351 axis = class_2350.class_2351.field_11052;
        if (WandUtils.is_wand(stack) && (p = stack.method_7948().method_10550("axis")) >= 0 && p < axes.length) {
            axis = axes[p];
        }
        return axis;
    }

    public static void setAxis(class_1799 stack, class_2350.class_2351 axis) {
        if (WandUtils.is_wand(stack)) {
            class_2487 tag = stack.method_7948();
            tag.method_10569("axis", axis.ordinal());
        }
    }

    public static void setAxis(class_1799 stack, int a) {
        if (stack != null && WandUtils.is_wand(stack) && !stack.method_7960()) {
            class_2487 tag = stack.method_7948();
            tag.method_10569("axis", a);
        }
    }

    public static void nextAxis(class_1799 stack) {
        if (WandUtils.is_wand(stack)) {
            class_2487 tag = stack.method_7948();
            int axis = (tag.method_10550("axis") + 1) % 3;
            tag.method_10569("axis", axis);
        }
    }

    public static StateMode getStateMode(class_1799 stack) {
        int m;
        if (WandUtils.is_wand(stack) && (m = stack.method_7948().method_10550("state_mode")) < state_modes.length) {
            return state_modes[m];
        }
        return StateMode.TARGET;
    }

    public static void setStateMode(class_1799 stack, StateMode mode) {
        if (WandUtils.is_wand(stack)) {
            class_2487 tag = stack.method_7948();
            tag.method_10569("state_mode", mode.ordinal());
        }
    }

    public static void incGrid(class_1799 stack, Value v, int n, int limit) {
        if (WandUtils.is_wand(stack)) {
            int c;
            class_2487 tag = stack.method_7948();
            if (v.coval != null && (c = stack.method_7948().method_10550(v.coval.toString())) * n <= limit) {
                int nn = stack.method_7948().method_10550(v.toString());
                tag.method_10569(v.toString(), nn + n);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Flag {
        INVERTED{

            public String toString() {
                return "inverted";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        CFILLED{

            public String toString() {
                return "cfill";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        EVEN{

            public String toString() {
                return "circle_even";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        DIAGSPREAD{

            public String toString() {
                return "diag_spread";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        MATCHSTATE{

            public String toString() {
                return "match_state";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        INCSELBLOCK{

            public String toString() {
                return "inc_sel_block";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        STAIRSLAB{

            public String toString() {
                return "stair_slab";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        RFILLED{

            public String toString() {
                return "rfill";
            }

            @Override
            public boolean get_default() {
                return true;
            }
        }
        ,
        TARGET_AIR{

            public String toString() {
                return "target_air";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        };


        public abstract boolean get_default();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Value {
        MULTIPLIER{

            public String toString() {
                return "multiplier";
            }
        }
        ,
        ROWCOLLIM{

            public String toString() {
                return "row_col_limit";
            }
        }
        ,
        AREALIM{

            public String toString() {
                return "area_limit";
            }
        }
        ,
        BLASTRAD{

            public String toString() {
                return "blast_radius";
            }
        }
        ,
        GRIDM{

            public String toString() {
                return "grid_m";
            }
        }
        ,
        GRIDN{

            public String toString() {
                return "grid_n";
            }
        }
        ,
        GRIDMS{

            public String toString() {
                return "grid_msp";
            }
        }
        ,
        GRIDNS{

            public String toString() {
                return "grid_nsp";
            }
        }
        ,
        GRIDMOFF{

            public String toString() {
                return "grid_moff";
            }
        }
        ,
        GRIDNOFF{

            public String toString() {
                return "grid_noff";
            }
        }
        ,
        MIRRORAXIS{

            public String toString() {
                return "mirror_axis";
            }
        }
        ,
        SKIPBLOCK{

            public String toString() {
                return "skip_block";
            }
        }
        ,
        TUNNEL_W{

            public String toString() {
                return "tunnel_w";
            }
        }
        ,
        TUNNEL_H{

            public String toString() {
                return "tunnel_h";
            }
        }
        ,
        TUNNEL_OX{

            public String toString() {
                return "tunnel_ox";
            }
        }
        ,
        TUNNEL_OY{

            public String toString() {
                return "tunnel_oy";
            }
        }
        ,
        TUNNEL_DEPTH{

            public String toString() {
                return "tunnel_d";
            }
        };

        public int def = 0;
        public int min = 0;
        public int max = 2048;
        public Value coval = null;

        static {
            Value.MULTIPLIER.def = 1;
            Value.MULTIPLIER.min = 1;
            Value.MULTIPLIER.max = 16;
            Value.ROWCOLLIM.def = 0;
            Value.ROWCOLLIM.min = 0;
            Value.BLASTRAD.def = 4;
            Value.BLASTRAD.min = 4;
            Value.BLASTRAD.max = 16;
            Value.GRIDM.coval = GRIDN;
            Value.GRIDN.coval = GRIDM;
            Value.GRIDM.min = 1;
            Value.GRIDN.min = 1;
            Value.MIRRORAXIS.min = 0;
            Value.MIRRORAXIS.max = 2;
            Value.SKIPBLOCK.max = 100;
            Value.TUNNEL_W.min = 1;
            Value.TUNNEL_H.min = 1;
            Value.TUNNEL_H.def = 2;
            Value.TUNNEL_DEPTH.def = 3;
            Value.TUNNEL_DEPTH.min = 1;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Mode {
        DIRECTION{

            public String toString() {
                return "wands.modes.direction";
            }

            @Override
            public WandMode get_mode() {
                return new DirectionMode();
            }

            @Override
            public boolean can_target_air() {
                return false;
            }

            @Override
            public int n_clicks() {
                return 1;
            }
        }
        ,
        ROW_COL{

            public String toString() {
                return "wands.modes.row_col";
            }

            @Override
            public WandMode get_mode() {
                return new RowColMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 1;
            }
        }
        ,
        FILL{

            public String toString() {
                return "wands.modes.fill";
            }

            @Override
            public WandMode get_mode() {
                return new FillMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 2;
            }
        }
        ,
        AREA{

            public String toString() {
                return "wands.modes.area";
            }

            @Override
            public WandMode get_mode() {
                return new AreaMode();
            }

            @Override
            public boolean can_target_air() {
                return false;
            }

            @Override
            public int n_clicks() {
                return 1;
            }
        }
        ,
        GRID{

            public String toString() {
                return "wands.modes.grid";
            }

            @Override
            public WandMode get_mode() {
                return new GridMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 1;
            }
        }
        ,
        LINE{

            public String toString() {
                return "wands.modes.line";
            }

            @Override
            public WandMode get_mode() {
                return new LineMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 2;
            }
        }
        ,
        CIRCLE{

            public String toString() {
                return "wands.modes.circle";
            }

            @Override
            public WandMode get_mode() {
                return new CircleMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 2;
            }
        }
        ,
        COPY{

            public String toString() {
                return "wands.modes.copy";
            }

            @Override
            public WandMode get_mode() {
                return new CopyMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 2;
            }
        }
        ,
        PASTE{

            public String toString() {
                return "wands.modes.paste";
            }

            @Override
            public WandMode get_mode() {
                return new PasteMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 1;
            }
        }
        ,
        TUNNEL{

            public String toString() {
                return "wands.modes.tunnel";
            }

            @Override
            public WandMode get_mode() {
                return new TunnelMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 1;
            }
        }
        ,
        VEIN{

            public String toString() {
                return "wands.modes.vein";
            }

            @Override
            public WandMode get_mode() {
                return new VeinMode();
            }

            @Override
            public boolean can_target_air() {
                return false;
            }

            @Override
            public int n_clicks() {
                return 1;
            }
        }
        ,
        BLAST{

            public String toString() {
                return "wands.modes.blast";
            }

            @Override
            public WandMode get_mode() {
                return new BlastMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 1;
            }
        };


        public abstract WandMode get_mode();

        public abstract boolean can_target_air();

        public abstract int n_clicks();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Orientation {
        ROW{

            public String toString() {
                return "wands.orientation.row";
            }
        }
        ,
        COL{

            public String toString() {
                return "wands.orientation.col";
            }
        };

    }

    public static enum Plane {
        XZ,
        XY,
        YZ;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Action {
        PLACE{

            public String toString() {
                return "wands.action.place";
            }
        }
        ,
        REPLACE{

            public String toString() {
                return "wands.action.replace";
            }
        }
        ,
        DESTROY{

            public String toString() {
                return "wands.action.destroy";
            }
        }
        ,
        USE{

            public String toString() {
                return "wands.action.use";
            }
        };

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum StateMode {
        CLONE{

            public String toString() {
                return "wands.state_mode.clone";
            }
        }
        ,
        APPLY{

            public String toString() {
                return "wands.state_mode.apply";
            }
        }
        ,
        TARGET{

            public String toString() {
                return "wands.state_mode.target";
            }
        };

    }

    public static enum MirrorAxis {
        NONE,
        LEFT_RIGHT,
        FRONT_BACK;

    }
}

