/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import org.betterx.bclib.api.v2.generator.BCLibNetherBiomeSource;
import org.betterx.bclib.api.v2.generator.config.MapBuilderFunction;
import org.betterx.bclib.api.v2.generator.map.hex.HexBiomeMap;
import org.betterx.bclib.api.v2.generator.map.square.SquareBiomeMap;
import org.betterx.worlds.together.biomesource.config.BiomeSourceConfig;
import org.jetbrains.annotations.NotNull;

public class BCLNetherBiomeSourceConfig
implements BiomeSourceConfig<BCLibNetherBiomeSource> {
    public static final BCLNetherBiomeSourceConfig VANILLA = new BCLNetherBiomeSourceConfig(NetherBiomeMapType.VANILLA, 256, 86, false, false);
    public static final BCLNetherBiomeSourceConfig MINECRAFT_17 = new BCLNetherBiomeSourceConfig(NetherBiomeMapType.SQUARE, 256, 86, true, false);
    public static final BCLNetherBiomeSourceConfig MINECRAFT_18 = new BCLNetherBiomeSourceConfig(NetherBiomeMapType.HEX, BCLNetherBiomeSourceConfig.MINECRAFT_17.biomeSize, BCLNetherBiomeSourceConfig.MINECRAFT_17.biomeSizeVertical, BCLNetherBiomeSourceConfig.MINECRAFT_17.useVerticalBiomes, BCLNetherBiomeSourceConfig.MINECRAFT_17.amplified);
    public static final BCLNetherBiomeSourceConfig MINECRAFT_18_LARGE = new BCLNetherBiomeSourceConfig(NetherBiomeMapType.HEX, BCLNetherBiomeSourceConfig.MINECRAFT_18.biomeSize * 4, BCLNetherBiomeSourceConfig.MINECRAFT_18.biomeSizeVertical * 2, BCLNetherBiomeSourceConfig.MINECRAFT_18.useVerticalBiomes, BCLNetherBiomeSourceConfig.MINECRAFT_17.amplified);
    public static final BCLNetherBiomeSourceConfig MINECRAFT_18_AMPLIFIED = new BCLNetherBiomeSourceConfig(NetherBiomeMapType.HEX, BCLNetherBiomeSourceConfig.MINECRAFT_18.biomeSize, 128, true, true);
    public static final BCLNetherBiomeSourceConfig DEFAULT = MINECRAFT_18;
    public static final Codec<BCLNetherBiomeSourceConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NetherBiomeMapType.CODEC.fieldOf("map_type").orElse((Object)BCLNetherBiomeSourceConfig.DEFAULT.mapVersion).forGetter(o -> o.mapVersion), (App)Codec.INT.fieldOf("biome_size").orElse((Object)BCLNetherBiomeSourceConfig.DEFAULT.biomeSize).forGetter(o -> o.biomeSize), (App)Codec.INT.fieldOf("biome_size_vertical").orElse((Object)BCLNetherBiomeSourceConfig.DEFAULT.biomeSizeVertical).forGetter(o -> o.biomeSizeVertical), (App)Codec.BOOL.fieldOf("use_vertical_biomes").orElse((Object)BCLNetherBiomeSourceConfig.DEFAULT.useVerticalBiomes).forGetter(o -> o.useVerticalBiomes), (App)Codec.BOOL.fieldOf("amplified").orElse((Object)BCLNetherBiomeSourceConfig.DEFAULT.amplified).forGetter(o -> o.amplified)).apply((Applicative)instance, BCLNetherBiomeSourceConfig::new));
    @NotNull
    public final NetherBiomeMapType mapVersion;
    public final int biomeSize;
    public final int biomeSizeVertical;
    public final boolean useVerticalBiomes;
    public final boolean amplified;

    public BCLNetherBiomeSourceConfig(@NotNull NetherBiomeMapType mapVersion, int biomeSize, int biomeSizeVertical, boolean useVerticalBiomes, boolean amplified) {
        this.mapVersion = mapVersion;
        this.biomeSize = class_3532.method_15340((int)biomeSize, (int)1, (int)8192);
        this.biomeSizeVertical = class_3532.method_15340((int)biomeSizeVertical, (int)1, (int)8192);
        this.useVerticalBiomes = useVerticalBiomes;
        this.amplified = amplified;
    }

    public String toString() {
        return "BCLibNetherBiomeSourceConfig{mapVersion=" + this.mapVersion + ", useVerticalBiomes=" + this.useVerticalBiomes + ", amplified=" + this.amplified + ", biomeSize=" + this.biomeSize + ", biomeSizeVertical=" + this.biomeSizeVertical + "}";
    }

    @Override
    public boolean couldSetWithoutRepair(BiomeSourceConfig<?> input) {
        if (input instanceof BCLNetherBiomeSourceConfig) {
            BCLNetherBiomeSourceConfig cfg = (BCLNetherBiomeSourceConfig)input;
            return this.mapVersion == cfg.mapVersion;
        }
        return false;
    }

    @Override
    public boolean sameConfig(BiomeSourceConfig<?> input) {
        return this.equals(input);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BCLNetherBiomeSourceConfig)) {
            return false;
        }
        BCLNetherBiomeSourceConfig that = (BCLNetherBiomeSourceConfig)o;
        return this.mapVersion == that.mapVersion;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mapVersion});
    }

    public static enum NetherBiomeMapType implements class_3542
    {
        VANILLA("vanilla", (seed, biomeSize, picker) -> new HexBiomeMap(seed, biomeSize, picker)),
        SQUARE("square", (seed, biomeSize, picker) -> new SquareBiomeMap(seed, biomeSize, picker)),
        HEX("hex", (seed, biomeSize, picker) -> new HexBiomeMap(seed, biomeSize, picker));

        public static final Codec<NetherBiomeMapType> CODEC;
        public final String name;
        public final MapBuilderFunction mapBuilder;

        private NetherBiomeMapType(String name, MapBuilderFunction mapBuilder) {
            this.name = name;
            this.mapBuilder = mapBuilder;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(NetherBiomeMapType::values);
        }
    }
}

