/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.biomes;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.biome.v1.NetherBiomes;
import net.fabricmc.fabric.api.biome.v1.TheEndBiomes;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2841;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5483;
import net.minecraft.class_6012;
import net.minecraft.class_6544;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6908;
import net.minecraft.class_7522;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.InternalBiomeAPI;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeature;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.bclib.mixin.common.BiomeGenerationSettingsAccessor;
import org.betterx.bclib.mixin.common.MobSpawnSettingsAccessor;
import org.betterx.bclib.util.CollectionsUtil;
import org.betterx.worlds.together.tag.v3.CommonBiomeTags;
import org.betterx.worlds.together.tag.v3.TagManager;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiomeAPI {
    public static final BCLBiome THE_END = InternalBiomeAPI.wrapBiome((class_5321<class_1959>)class_1972.field_9411, InternalBiomeAPI.OTHER_END_CENTER);
    public static final BCLBiome NETHER_WASTES_BIOME = InternalBiomeAPI.wrapBiome((class_5321<class_1959>)class_1972.field_9461, InternalBiomeAPI.OTHER_NETHER);
    public static final BCLBiome CRIMSON_FOREST_BIOME = InternalBiomeAPI.wrapBiome((class_5321<class_1959>)class_1972.field_22077, InternalBiomeAPI.OTHER_NETHER);
    public static final BCLBiome WARPED_FOREST_BIOME = InternalBiomeAPI.wrapBiome((class_5321<class_1959>)class_1972.field_22075, InternalBiomeAPI.OTHER_NETHER);
    public static final BCLBiome SOUL_SAND_VALLEY_BIOME = InternalBiomeAPI.wrapBiome((class_5321<class_1959>)class_1972.field_22076, InternalBiomeAPI.OTHER_NETHER);
    public static final BCLBiome BASALT_DELTAS_BIOME = InternalBiomeAPI.wrapBiome((class_5321<class_1959>)class_1972.field_23859, InternalBiomeAPI.OTHER_NETHER);
    public static final BCLBiome END_MIDLANDS = InternalBiomeAPI.wrapBiome((class_5321<class_1959>)class_1972.field_9447, 0.5f, InternalBiomeAPI.OTHER_END_LAND);
    public static final BCLBiome END_HIGHLANDS = InternalBiomeAPI.wrapBiome((class_5321<class_1959>)class_1972.field_9442, END_MIDLANDS, 8, 0.5f, InternalBiomeAPI.OTHER_END_LAND);
    public static final BCLBiome END_BARRENS = InternalBiomeAPI.wrapBiome((class_5321<class_1959>)class_1972.field_9465, InternalBiomeAPI.OTHER_END_BARRENS);
    public static final BCLBiome SMALL_END_ISLANDS = InternalBiomeAPI.wrapBiome((class_5321<class_1959>)class_1972.field_9457, InternalBiomeAPI.OTHER_END_VOID);

    static BCLBiome registerBuiltinBiomeAndOverrideIntendedDimension(class_7891<class_1959> bootstrapContext, BCLBiome bclbiome, BiomeType dim) {
        bclbiome._setIntendedType(dim);
        return BiomeAPI.registerBiome(bootstrapContext, bclbiome);
    }

    static BCLBiome registerBiome(class_7891<class_1959> bootstrapContext, BCLBiome bclbiome) {
        class_7871 registryOrNull = bootstrapContext.method_46799(class_7924.field_41236);
        if (registryOrNull != null && bclbiome._hasBiomeToRegister() && !registryOrNull.method_46746(bclbiome.getBiomeKey()).map(v -> v.method_40227()).orElse(false).booleanValue()) {
            bootstrapContext.method_46838(bclbiome.getBiomeKey(), (Object)bclbiome._getBiomeToRegister());
            BCLBiomeRegistry.registerForDatagen(bclbiome);
        }
        return BiomeAPI.finishBiomeRegistration(bclbiome);
    }

    static BCLBiome finishBiomeRegistration(BCLBiome bclbiome) {
        BiomeType dim = bclbiome.getIntendedType();
        if (dim != null && dim.is(BiomeType.NETHER)) {
            TagManager.BIOMES.add((class_6862<class_1959>)class_6908.field_36518, bclbiome.getBiomeKey());
        } else if (dim != null && dim.is(BiomeType.END)) {
            TagManager.BIOMES.add((class_6862<class_1959>)class_6908.field_37394, bclbiome.getBiomeKey());
            if (dim.is(BiomeType.END_VOID)) {
                TagManager.BIOMES.add(CommonBiomeTags.IS_SMALL_END_ISLAND, bclbiome.getBiomeKey());
            } else if (dim.is(BiomeType.END_BARRENS)) {
                TagManager.BIOMES.add(CommonBiomeTags.IS_END_BARRENS, bclbiome.getBiomeKey());
            } else if (dim.is(BiomeType.END_LAND)) {
                TagManager.BIOMES.add(CommonBiomeTags.IS_END_HIGHLAND, bclbiome.getBiomeKey());
            } else if (dim.is(BiomeType.END_CENTER)) {
                TagManager.BIOMES.add(CommonBiomeTags.IS_END_CENTER, bclbiome.getBiomeKey());
            }
        }
        bclbiome.afterRegistration();
        return bclbiome;
    }

    static BCLBiome registerSubBiome(class_7891<class_1959> bootstrapContext, BCLBiome parent, BCLBiome subBiome) {
        return BiomeAPI.registerSubBiome(bootstrapContext, parent, subBiome, parent.getIntendedType());
    }

    static BCLBiome registerSubBiome(class_7891<class_1959> bootstrapContext, BCLBiome parent, BCLBiome subBiome, BiomeType dim) {
        BiomeAPI.registerBuiltinBiomeAndOverrideIntendedDimension(bootstrapContext, subBiome, dim);
        parent.addSubBiome(subBiome);
        return subBiome;
    }

    static BCLBiome registerEndLandBiome(class_7891<class_1959> bootstrapContext, BCLBiome biome) {
        BiomeAPI.registerBuiltinBiomeAndOverrideIntendedDimension(bootstrapContext, biome, BiomeType.BCL_END_LAND);
        float weight = biome.settings.getGenChance();
        class_5321<class_1959> key = biome.getBiomeKey();
        if (biome.isEdgeBiome()) {
            class_5321<class_1959> parentKey = biome.getParentBiome().getBiomeKey();
            TheEndBiomes.addMidlandsBiome(parentKey, key, (double)weight);
        } else {
            TheEndBiomes.addHighlandsBiome(key, (double)weight);
        }
        return biome;
    }

    static BCLBiome registerEndVoidBiome(class_7891<class_1959> bootstrapContext, BCLBiome biome) {
        BiomeAPI.registerBuiltinBiomeAndOverrideIntendedDimension(bootstrapContext, biome, BiomeType.BCL_END_VOID);
        float weight = biome.settings.getGenChance();
        class_5321<class_1959> key = biome.getBiomeKey();
        if (!biome.isEdgeBiome()) {
            TheEndBiomes.addSmallIslandsBiome(key, (double)weight);
        }
        return biome;
    }

    static BCLBiome registerEndCenterBiome(class_7891<class_1959> bootstrapContext, BCLBiome biome) {
        BiomeAPI.registerBuiltinBiomeAndOverrideIntendedDimension(bootstrapContext, biome, BiomeType.BCL_END_CENTER);
        float weight = biome.settings.getGenChance();
        class_5321<class_1959> key = biome.getBiomeKey();
        if (!biome.isEdgeBiome()) {
            TheEndBiomes.addMainIslandBiome(key, (double)weight);
        }
        return biome;
    }

    static BCLBiome registerEndBarrensBiome(class_7891<class_1959> bootstrapContext, BCLBiome highlandBiome, BCLBiome biome) {
        BiomeAPI.registerBuiltinBiomeAndOverrideIntendedDimension(bootstrapContext, biome, BiomeType.BCL_END_BARRENS);
        float weight = biome.settings.getGenChance();
        class_5321<class_1959> key = biome.getBiomeKey();
        if (!biome.isEdgeBiome()) {
            class_5321<class_1959> parentKey = highlandBiome.getBiomeKey();
            TheEndBiomes.addBarrensBiome(parentKey, key, (double)weight);
        }
        return biome;
    }

    static BCLBiome registerNetherBiome(class_7891<class_1959> bootstrapContext, BCLBiome bclBiome) {
        BiomeAPI.registerBuiltinBiomeAndOverrideIntendedDimension(bootstrapContext, bclBiome, BiomeType.BCL_NETHER);
        class_5321<class_1959> key = bclBiome.getBiomeKey();
        if (!bclBiome.isEdgeBiome()) {
            bclBiome.forEachClimateParameter(p -> NetherBiomes.addNetherBiome((class_5321)key, (class_6544.class_4762)p));
        }
        return bclBiome;
    }

    public static BCLBiome getRenderBiome(class_1959 biome) {
        class_5455 acc;
        BCLBiome endBiome = InternalBiomeAPI.CLIENT.get(biome);
        if (endBiome == null && (acc = WorldBootstrap.getLastRegistryAccessOrElseBuiltin()) != null) {
            class_2378<BCLBiome> reg = BCLBiomeRegistry.registryOrNull();
            class_2960 id = acc.method_30530(class_7924.field_41236).method_10221((Object)biome);
            endBiome = BCLBiomeRegistry.getBiomeOrEmpty(id, reg);
            InternalBiomeAPI.CLIENT.put(biome, endBiome);
        }
        return endBiome;
    }

    @Nullable
    public static class_5321 getBiomeKey(class_1959 biome) {
        Optional key;
        if (InternalBiomeAPI.biomeRegistry != null && (key = InternalBiomeAPI.biomeRegistry.method_29113((Object)biome)).isPresent()) {
            return (class_5321)key.get();
        }
        return null;
    }

    public static class_2960 getBiomeID(class_1959 biome) {
        class_5321 key;
        class_2960 id = null;
        if (InternalBiomeAPI.biomeRegistry != null) {
            id = InternalBiomeAPI.biomeRegistry.method_10221((Object)biome);
        }
        if (id == null && (key = BiomeAPI.getBiomeKey(biome)) != null) {
            id = key.method_29177();
        }
        if (id == null) {
            BCLib.LOGGER.error("Unable to get ID for " + biome + ". Falling back to empty Biome...");
            id = BCLBiomeRegistry.EMPTY_BIOME.getID();
        }
        return id;
    }

    public static class_2960 getBiomeID(class_6880<class_1959> biome) {
        return biome.method_40230().map(h -> h.method_29177()).orElse(null);
    }

    @Nullable
    public static BCLBiome getBiome(class_2960 biomeID) {
        return BCLBiomeRegistry.getBiomeOrNull(biomeID, BCLBiomeRegistry.registryOrNull());
    }

    @Nullable
    public static BCLBiome getBiome(class_1959 biome) {
        return BiomeAPI.getBiome(BiomeAPI.getBiomeID(biome));
    }

    @Nullable
    public static BCLBiome getBiome(class_6880<class_1959> biome) {
        return BiomeAPI.getBiome(BiomeAPI.getBiomeID(biome));
    }

    public static class_6880<class_1959> getFromRegistry(class_2960 biomeID) {
        class_2378 reg;
        Optional holder;
        if (InternalBiomeAPI.biomeRegistry != null && (holder = InternalBiomeAPI.biomeRegistry.method_40264(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)biomeID))).isPresent()) {
            return (class_6880)holder.get();
        }
        if (WorldBootstrap.getLastRegistryAccess() != null && (reg = WorldBootstrap.getLastRegistryAccess().method_30530(class_7924.field_41236)).method_10250(biomeID)) {
            return reg.method_40290(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)biomeID));
        }
        return null;
    }

    public static boolean wasRegisteredAs(class_2960 biomeID, BiomeType dim) {
        if (BCLBiomeRegistry.isEmptyBiome(biomeID)) {
            return false;
        }
        BCLBiome res = BCLBiomeRegistry.getBiomeOrEmpty(biomeID, BCLBiomeRegistry.registryOrNull());
        if (res == null) {
            return false;
        }
        return res.getIntendedType().is(dim);
    }

    public static boolean wasRegisteredAsNetherBiome(class_2960 biomeID) {
        return BiomeAPI.wasRegisteredAs(biomeID, BiomeType.NETHER);
    }

    public static boolean wasRegisteredAsEndBiome(class_2960 biomeID) {
        return BiomeAPI.wasRegisteredAs(biomeID, BiomeType.END);
    }

    public static boolean wasRegisteredAsEndLandBiome(class_2960 biomeID) {
        return BiomeAPI.wasRegisteredAs(biomeID, BiomeType.END_LAND);
    }

    public static boolean wasRegisteredAsEndVoidBiome(class_2960 biomeID) {
        return BiomeAPI.wasRegisteredAs(biomeID, BiomeType.END_VOID);
    }

    public static boolean wasRegisteredAsEndCenterBiome(class_2960 biomeID) {
        return BiomeAPI.wasRegisteredAs(biomeID, BiomeType.END_CENTER);
    }

    public static boolean wasRegisteredAsEndBarrensBiome(class_2960 biomeID) {
        return BiomeAPI.wasRegisteredAs(biomeID, BiomeType.END_BARRENS);
    }

    public static void registerBiomeModification(class_5321<class_5363> dimensionID, BiConsumer<class_2960, class_6880<class_1959>> modification) {
        List modifications = InternalBiomeAPI.MODIFICATIONS.computeIfAbsent(dimensionID, k -> Lists.newArrayList());
        modifications.add(modification);
    }

    public static void registerOverworldBiomeModification(BiConsumer<class_2960, class_6880<class_1959>> modification) {
        BiomeAPI.registerBiomeModification((class_5321<class_5363>)class_5363.field_25412, modification);
    }

    public static void registerNetherBiomeModification(BiConsumer<class_2960, class_6880<class_1959>> modification) {
        BiomeAPI.registerBiomeModification((class_5321<class_5363>)class_5363.field_25413, modification);
    }

    public static void registerEndBiomeModification(BiConsumer<class_2960, class_6880<class_1959>> modification) {
        BiomeAPI.registerBiomeModification((class_5321<class_5363>)class_5363.field_25414, modification);
    }

    public static void onFinishingBiomeTags(class_5321 dimensionID, BiConsumer<class_2960, class_6880<class_1959>> modification) {
        List modifications = InternalBiomeAPI.TAG_ADDERS.computeIfAbsent(dimensionID, k -> Lists.newArrayList());
        modifications.add(modification);
    }

    public static void onFinishingNetherBiomeTags(BiConsumer<class_2960, class_6880<class_1959>> modification) {
        BiomeAPI.onFinishingBiomeTags(class_1937.field_25180, modification);
    }

    public static void onFinishingEndBiomeTags(BiConsumer<class_2960, class_6880<class_1959>> modification) {
        BiomeAPI.onFinishingBiomeTags(class_1937.field_25181, modification);
    }

    public static void addBiomeFeature(class_6880<class_1959> biome, BCLFeature feature) {
        BiomeAPI.addBiomeFeature(biome, feature.getDecoration(), feature.getPlacedFeature());
    }

    public static void addBiomeFeature(class_6880<class_1959> biome, class_2893.class_2895 step, class_6880<class_6796> ... featureList) {
        BiomeAPI.addBiomeFeature(biome, step, List.of(featureList));
    }

    private static void addBiomeFeature(class_6880<class_1959> biome, class_2893.class_2895 step, List<class_6880<class_6796>> additionalFeatures) {
        BiomeGenerationSettingsAccessor accessor = (BiomeGenerationSettingsAccessor)((class_1959)biome.comp_349()).method_30970();
        List<class_6885<class_6796>> allFeatures = CollectionsUtil.getMutable(accessor.bclib_getFeatures());
        List<class_6880<class_6796>> features = BiomeAPI.getFeaturesListCopy(allFeatures, step);
        for (class_6880<class_6796> feature : additionalFeatures) {
            if (features.contains(feature)) continue;
            features.add(feature);
        }
        allFeatures.set(step.ordinal(), (class_6885<class_6796>)class_6885.method_40242(features));
        com.google.common.base.Supplier flowerFeatures = Suppliers.memoize(() -> (List)allFeatures.stream().flatMap(class_6885::method_40239).map(class_6880::comp_349).flatMap(class_6796::method_39643).filter(configuredFeature -> configuredFeature.comp_332() == class_3031.field_21219).collect(ImmutableList.toImmutableList()));
        com.google.common.base.Supplier featureSet = Suppliers.memoize(() -> allFeatures.stream().flatMap(class_6885::method_40239).map(class_6880::comp_349).collect(Collectors.toSet()));
        accessor.bclib_setFeatures(allFeatures);
        accessor.bclib_setFeatureSet((Supplier<Set<class_6796>>)featureSet);
        accessor.bclib_setFlowerFeatures((Supplier<List<class_2975<?, ?>>>)flowerFeatures);
    }

    public static <M extends class_1308> void addBiomeMobSpawn(class_6880<class_1959> biome, class_1299<M> entityType, int weight, int minGroupCount, int maxGroupCount) {
        class_1311 category = entityType.method_5891();
        MobSpawnSettingsAccessor accessor = (MobSpawnSettingsAccessor)((class_1959)biome.comp_349()).method_30966();
        Map<class_1311, class_6012<class_5483.class_1964>> spawners = CollectionsUtil.getMutable(accessor.bcl_getSpawners());
        ArrayList mobs = spawners.containsKey(category) ? CollectionsUtil.getMutable(spawners.get(category).method_34994()) : Lists.newArrayList();
        mobs.add(new class_5483.class_1964(entityType, weight, minGroupCount, maxGroupCount));
        spawners.put(category, (class_6012<class_5483.class_1964>)class_6012.method_34988((List)mobs));
        accessor.bcl_setSpawners(spawners);
    }

    public static Optional<class_2680> findTopMaterial(class_5281 world, class_2338 pos) {
        return BiomeAPI.findTopMaterial(BiomeAPI.getBiome((class_6880<class_1959>)world.method_23753(pos)));
    }

    public static Optional<class_2680> findTopMaterial(class_6880<class_1959> biome) {
        return BiomeAPI.findTopMaterial(BiomeAPI.getBiome((class_1959)biome.comp_349()));
    }

    public static Optional<class_2680> findTopMaterial(class_1959 biome) {
        return BiomeAPI.findTopMaterial(BiomeAPI.getBiome(biome));
    }

    public static Optional<class_2680> findTopMaterial(BCLBiome biome) {
        if (biome instanceof SurfaceMaterialProvider) {
            SurfaceMaterialProvider smp = (SurfaceMaterialProvider)((Object)biome);
            return Optional.of(smp.getTopMaterial());
        }
        return Optional.empty();
    }

    public static Optional<class_2680> findUnderMaterial(class_6880<class_1959> biome) {
        return BiomeAPI.findUnderMaterial(BiomeAPI.getBiome((class_1959)biome.comp_349()));
    }

    public static Optional<class_2680> findUnderMaterial(BCLBiome biome) {
        if (biome instanceof SurfaceMaterialProvider) {
            SurfaceMaterialProvider smp = (SurfaceMaterialProvider)((Object)biome);
            return Optional.of(smp.getUnderMaterial());
        }
        return Optional.empty();
    }

    public static void setBiome(class_2791 chunk, class_2338 pos, class_6880<class_1959> biome) {
        int sectionY = pos.method_10264() - chunk.method_31607() >> 4;
        class_7522 biomes = chunk.method_38259(sectionY).method_38294();
        if (biomes instanceof class_2841) {
            class_2841 palette = (class_2841)biomes;
            palette.method_35321((pos.method_10263() & 0xF) >> 2, (pos.method_10264() & 0xF) >> 2, (pos.method_10260() & 0xF) >> 2, biome);
        } else {
            BCLib.LOGGER.warning("Unable to change Biome at " + pos, new Object[0]);
        }
    }

    public static void setBiome(class_1936 level, class_2338 pos, class_6880<class_1959> biome) {
        class_2791 chunk = level.method_22350(pos);
        BiomeAPI.setBiome(chunk, pos, biome);
    }

    private static List<class_6880<class_6796>> getFeaturesListCopy(List<class_6885<class_6796>> features, class_2893.class_2895 step) {
        return BiomeAPI.getFeaturesListCopy(features, step.ordinal());
    }

    private static List<class_6880<class_6796>> getFeaturesListCopy(List<class_6885<class_6796>> features, int index) {
        while (features.size() <= index) {
            features.add((class_6885<class_6796>)class_6885.method_40242((List)Lists.newArrayList()));
        }
        return features.get(index).method_40239().collect(Collectors.toList());
    }

    public static List<BCLBiome> getAllBiomes(BiomeType type) {
        ArrayList<BCLBiome> res = new ArrayList<BCLBiome>();
        class_5455 access = WorldBootstrap.getLastRegistryAccess();
        class_2378 reg = access == null ? BCLBiomeRegistry.BUILTIN_BCL_BIOMES : access.method_30530(BCLBiomeRegistry.BCL_BIOMES_REGISTRY);
        for (Map.Entry e : reg.method_29722()) {
            if (!((BCLBiome)e.getValue()).getIntendedType().is(type)) continue;
            res.add((BCLBiome)e.getValue());
        }
        return res;
    }

    public static class BiomeType {
        public static final Codec<BiomeType> DIRECT_CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)Codec.STRING.fieldOf("name").orElse((Object)"undefined").forGetter(o -> o.name)).apply((Applicative)instance, BiomeType::create));
        public static final Codec<BiomeType> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)Codec.STRING.fieldOf("name").orElse((Object)"undefined").forGetter(o -> o.name), (App)Codec.STRING.fieldOf("parent").orElse((Object)"none").forGetter(o -> o.parentOrNull == null ? "none" : o.parentOrNull.name)).apply((Applicative)instance, BiomeType::create));
        private static final Map<String, BiomeType> KNOWN_TYPES = new HashMap<String, BiomeType>();
        public static final BiomeType NONE = new BiomeType("NONE");
        public static final BiomeType OVERWORLD = new BiomeType("OVERWORLD");
        public static final BiomeType NETHER = new BiomeType("NETHER");
        public static final BiomeType BCL_NETHER = new BiomeType("BCL_NETHER", NETHER, (biome, ignored) -> {
            class_5321<class_1959> key = biome.getBiomeKey();
            if (!biome.isEdgeBiome()) {
                biome.forEachClimateParameter(p -> NetherBiomes.addNetherBiome((class_5321)key, (class_6544.class_4762)p));
            }
        });
        public static final BiomeType END = new BiomeType("END");
        public static final BiomeType END_IGNORE = new BiomeType("END_IGNORE", END);
        public static final BiomeType END_LAND = new BiomeType("END_LAND", END);
        public static final BiomeType END_VOID = new BiomeType("END_VOID", END);
        public static final BiomeType END_CENTER = new BiomeType("END_CENTER", END);
        public static final BiomeType END_BARRENS = new BiomeType("END_BARRENS", END);
        public static final BiomeType BCL_END_LAND = new BiomeType("BCL_END_LAND", END_LAND, (biome, ignored) -> {
            float weight = biome.settings.getGenChance();
            class_5321<class_1959> key = biome.getBiomeKey();
            if (biome.isEdgeBiome()) {
                class_5321<class_1959> parentKey = biome.getParentBiome().getBiomeKey();
                TheEndBiomes.addMidlandsBiome(parentKey, key, (double)weight);
            } else {
                TheEndBiomes.addHighlandsBiome(key, (double)weight);
            }
        });
        public static final BiomeType BCL_END_VOID = new BiomeType("BCL_END_VOID", END_VOID, (biome, ignored) -> {
            float weight = biome.settings.getGenChance();
            class_5321<class_1959> key = biome.getBiomeKey();
            if (!biome.isEdgeBiome()) {
                TheEndBiomes.addSmallIslandsBiome(key, (double)weight);
            }
        });
        public static final BiomeType BCL_END_CENTER = new BiomeType("BCL_END_CENTER", END_CENTER, (biome, ignored) -> {
            float weight = biome.settings.getGenChance();
            class_5321<class_1959> key = biome.getBiomeKey();
            if (!biome.isEdgeBiome()) {
                TheEndBiomes.addMainIslandBiome(key, (double)weight);
            }
        });
        public static final BiomeType BCL_END_BARRENS = new BiomeType("BCL_END_BARRENS", END_BARRENS, (biome, highlandBiome) -> {
            float weight = biome.settings.getGenChance();
            class_5321<class_1959> key = biome.getBiomeKey();
            if (!biome.isEdgeBiome()) {
                class_5321<class_1959> parentKey = highlandBiome.getBiomeKey();
                TheEndBiomes.addBarrensBiome(parentKey, key, (double)weight);
            }
        });
        public final BiomeType parentOrNull;
        private final String name;
        final ExtraRegisterTaks extraRegisterTask;

        public static BiomeType getMainBiomeTypeForDimension(class_5321<class_5363> key) {
            if (key.equals((Object)class_5363.field_25414)) {
                return END_LAND;
            }
            if (key.equals((Object)class_5363.field_25413)) {
                return NETHER;
            }
            if (key.equals((Object)class_5363.field_25412)) {
                return OVERWORLD;
            }
            return null;
        }

        private static BiomeType create(String name, String parentOrNull) {
            BiomeType parent;
            BiomeType known = KNOWN_TYPES.get(name);
            BiomeType biomeType = parent = parentOrNull == null || "none".equals(parentOrNull) ? null : KNOWN_TYPES.get(parentOrNull);
            if (known != null) {
                if (known.parentOrNull != parent) {
                    BCLib.LOGGER.warning("BiomeType " + name + " was deserialized with parent " + parent + " but already has " + known.parentOrNull, new Object[0]);
                }
                return known;
            }
            return new BiomeType(name, parent);
        }

        static BiomeType create(String name) {
            BiomeType known = KNOWN_TYPES.get(name);
            if (known != null) {
                return known;
            }
            return NONE;
        }

        public BiomeType(String name) {
            this(name, null);
        }

        public BiomeType(String name, BiomeType parentOrNull) {
            this(name, parentOrNull, (b, a) -> {});
        }

        public BiomeType(String name, BiomeType parentOrNull, ExtraRegisterTaks extraRegisterTask) {
            this.parentOrNull = parentOrNull;
            this.name = name;
            this.extraRegisterTask = extraRegisterTask;
            KNOWN_TYPES.put(name, this);
        }

        public boolean is(BiomeType d) {
            if (d == this) {
                return true;
            }
            if (this.parentOrNull != null) {
                return this.parentOrNull.is(d);
            }
            return false;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            Object str = this.name;
            if (this.parentOrNull != null) {
                str = (String)str + " -> " + this.parentOrNull;
            }
            return str;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BiomeType biomeType = (BiomeType)o;
            return this.name.equals(biomeType.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        @FunctionalInterface
        static interface ExtraRegisterTaks {
            public void register(@NotNull BCLBiome var1, @Nullable BCLBiome var2);
        }
    }
}

