/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.tag.v3;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3497;
import net.minecraft.class_3503;
import net.minecraft.class_3505;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.interfaces.TriConsumer;
import org.betterx.bclib.util.Pair;
import org.betterx.worlds.together.WorldsTogether;

public class TagRegistry<T> {
    boolean isFrozen = false;
    public final String directory;
    private final Map<class_6862<T>, Set<class_3497>> tags = Maps.newConcurrentMap();
    public final class_5321<? extends class_2378<T>> registryKey;
    private final Function<T, class_2960> locationProvider;

    private TagRegistry(class_5321<? extends class_2378<T>> registry, String directory, Function<T, class_2960> locationProvider) {
        this.registryKey = registry;
        this.directory = directory;
        this.locationProvider = locationProvider;
    }

    protected void initializeTag(class_6862<T> tag) {
        this.getSetForTag(tag);
    }

    public Set<class_3497> getSetForTag(class_6862<T> tag) {
        if (tag == null) {
            return new HashSet<class_3497>();
        }
        return this.tags.computeIfAbsent(tag, k -> Sets.newHashSet());
    }

    public class_6862<T> makeTag(String modId, String name) {
        return this.makeTag(new class_2960(modId, name));
    }

    public class_6862<T> makeTag(class_2960 id) {
        return this.creatTagKey(id);
    }

    protected class_6862<T> creatTagKey(class_2960 id) {
        class_6862 tag = class_6862.method_40092(this.registryKey, (class_2960)id);
        this.initializeTag(tag);
        return tag;
    }

    public class_6862<T> makeCommonTag(String name) {
        return this.creatTagKey(new class_2960("c", name));
    }

    public class_6862<T> makeTogetherTag(String name) {
        return this.creatTagKey(WorldsTogether.makeID(name));
    }

    public void addUntyped(class_6862<T> tagID, class_2960 ... elements) {
        if (this.isFrozen) {
            WorldsTogether.LOGGER.warning("Adding Tag " + tagID + " after the API was frozen.", new Object[0]);
        }
        Set<class_3497> set = this.getSetForTag(tagID);
        for (class_2960 id : elements) {
            if (id == null) continue;
            set.add(class_3497.method_43937((class_2960)id));
        }
    }

    public void addUntyped(class_2960 element, class_6862<T> ... tagIDs) {
        for (class_6862<T> tagID : tagIDs) {
            this.addUntyped(tagID, element);
        }
    }

    public void addOtherTags(class_6862<T> tagID, class_6862<T> ... tags) {
        this.addOtherTags(tagID, false, tags);
    }

    public void addOptionalOtherTags(class_6862<T> tagID, class_6862<T> ... tags) {
        this.addOtherTags(tagID, true, tags);
    }

    void addOtherTags(class_6862<T> tagID, boolean optional, class_6862<T> ... tags) {
        if (this.isFrozen) {
            WorldsTogether.LOGGER.warning("Adding Tag " + tagID + " after the API was frozen.", new Object[0]);
        }
        Set<class_3497> set = this.getSetForTag(tagID);
        for (class_6862<T> tag : tags) {
            class_2960 id = tag.comp_327();
            if (id == null) continue;
            set.add(optional ? class_3497.method_43947((class_2960)id) : class_3497.method_43945((class_2960)id));
        }
    }

    protected void add(class_6862<T> tagID, T ... elements) {
        this.add(tagID, false, elements);
    }

    protected void addOptional(class_6862<T> tagID, T ... elements) {
        this.add(tagID, true, elements);
    }

    protected void add(class_6862<T> tagID, boolean optional, T ... elements) {
        if (this.isFrozen) {
            WorldsTogether.LOGGER.warning("Adding Tag " + tagID + " after the API was frozen.", new Object[0]);
        }
        Set<class_3497> set = this.getSetForTag(tagID);
        for (T element : elements) {
            class_2960 id = this.locationProvider.apply(element);
            for (class_3497 tagEntry : set) {
                if (tagEntry.method_43936().comp_814() || !tagEntry.method_43936().comp_813().equals((Object)id)) continue;
                id = null;
                break;
            }
            if (id == null) continue;
            set.add(optional ? class_3497.method_43942((class_2960)id) : class_3497.method_43937((class_2960)id));
        }
    }

    protected boolean contains(class_6862<T> tagID, T element) {
        Set<class_3497> set = this.getSetForTag(tagID);
        class_2960 id = this.locationProvider.apply(element);
        if (id != null) {
            for (class_3497 entry : set) {
                if (entry.method_43936().comp_814() || !id.equals((Object)entry.method_43936().comp_813())) continue;
                return true;
            }
        }
        return false;
    }

    protected void add(T element, class_6862<T> ... tagIDs) {
        for (class_6862<T> tagID : tagIDs) {
            this.add(tagID, element);
        }
    }

    public void forEach(BiConsumer<class_2960, Set<class_3497>> consumer) {
        this.tags.forEach((? super K a, ? super V b) -> consumer.accept(a.comp_327(), (Set<class_3497>)b));
    }

    public void forEachTag(TriConsumer<class_6862<T>, List<class_2960>, List<class_6862<T>>> consumer) {
        this.forEachTag(consumer, null);
    }

    public void forEachTag(TriConsumer<class_6862<T>, List<class_2960>, List<class_6862<T>>> consumer, BiPredicate<class_6862<T>, class_2960> allow) {
        this.tags.forEach((? super K tag, ? super V set) -> {
            LinkedList locations = new LinkedList();
            LinkedList tags = new LinkedList();
            set.forEach((? super T e) -> {
                class_5699.class_7476 t = e.method_43936();
                if (allow == null || allow.test((class_6862<T>)tag, t.comp_813())) {
                    if (t.comp_814()) {
                        tags.add(class_6862.method_40092(this.registryKey, (class_2960)t.comp_813()));
                    } else {
                        locations.add(t.comp_813());
                    }
                }
            });
            consumer.accept((class_6862<T>)tag, locations, tags);
        });
    }

    public void forEachEntry(TriConsumer<class_6862<T>, List<Pair<class_2960, class_3497>>, List<Pair<class_6862<T>, class_3497>>> consumer, BiPredicate<class_6862<T>, class_2960> allow) {
        this.tags.forEach((? super K tag, ? super V set) -> {
            LinkedList locations = new LinkedList();
            LinkedList tags = new LinkedList();
            set.forEach((? super T e) -> {
                class_5699.class_7476 t = e.method_43936();
                if (allow == null || allow.test((class_6862<T>)tag, t.comp_813())) {
                    if (t.comp_814()) {
                        tags.add(new Pair<class_6862, class_3497>(class_6862.method_40092(this.registryKey, (class_2960)t.comp_813()), (class_3497)e));
                    } else {
                        locations.add(new Pair<class_2960, class_3497>(t.comp_813(), (class_3497)e));
                    }
                }
            });
            consumer.accept((class_6862<T>)tag, locations, tags);
        });
    }

    public void apply(Map<class_2960, List<class_3503.class_5145>> tagsMap) {
        if (BCLib.isDatagen()) {
            this.forEach((id, ids) -> TagRegistry.apply(id, tagsMap.computeIfAbsent((class_2960)id, key -> Lists.newArrayList()), ids));
        } else {
            this.tags.clear();
        }
    }

    private static List<class_3503.class_5145> apply(class_2960 id, List<class_3503.class_5145> builder, Set<class_3497> ids) {
        ids.forEach((? super T value) -> builder.add(new class_3503.class_5145(value, "worlds_together")));
        return builder;
    }

    public static class UnTyped<T>
    extends TagRegistry<T> {
        UnTyped(class_5321<? extends class_2378<T>> registry, String directory) {
            super(registry, directory, t -> {
                throw new RuntimeException("Using Untyped TagType with Type-Dependant access. ");
            });
        }
    }

    public static class Items
    extends RegistryBacked<class_1792> {
        Items() {
            super(class_7923.field_41178);
        }

        @SafeVarargs
        public final void add(class_6862<class_1792> tagID, class_1935 ... elements) {
            for (class_1935 element : elements) {
                this.add(tagID, element.method_8389());
            }
        }

        @SafeVarargs
        public final void addOptional(class_6862<class_1792> tagID, class_1935 ... elements) {
            for (class_1935 element : elements) {
                this.addOptional(tagID, element.method_8389());
            }
        }

        @Override
        @SafeVarargs
        public final void add(class_1935 element, class_6862<class_1792> ... tagIDs) {
            super.add(element.method_8389(), tagIDs);
        }
    }

    public static class Biomes
    extends Simple<class_1959> {
        Biomes(String directory, Function<class_1959, class_2960> locationProvider) {
            super(class_7924.field_41236, directory, locationProvider);
        }

        public void add(class_6862<class_1959> tagID, class_5321<class_1959> ... elements) {
            this.add(tagID, false, elements);
        }

        public void addOptional(class_6862<class_1959> tagID, class_5321<class_1959> ... elements) {
            this.add(tagID, true, elements);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(class_6862<class_1959> tagID, boolean optional, class_5321<class_1959> ... elements) {
            if (this.isFrozen) {
                WorldsTogether.LOGGER.warning("Adding Tag " + tagID + " after the API was frozen.", new Object[0]);
            }
            Biomes biomes = this;
            synchronized (biomes) {
                Set<class_3497> set = this.getSetForTag(tagID);
                for (class_5321<class_1959> element : elements) {
                    class_2960 id = element.method_29177();
                    for (class_3497 tagEntry : set) {
                        if (tagEntry.method_43936().comp_814() || !tagEntry.method_43936().comp_813().equals((Object)id)) continue;
                        id = null;
                        break;
                    }
                    if (id == null) continue;
                    set.add(optional ? class_3497.method_43942((class_2960)id) : class_3497.method_43937((class_2960)id));
                }
            }
        }

        public class_6862<class_1959> makeStructureTag(String modID, String name) {
            return this.makeTag(modID, "has_structure/" + name);
        }

        @Override
        public void apply(Map<class_2960, List<class_3503.class_5145>> tagsMap) {
            super.apply(tagsMap);
        }
    }

    public static class Simple<T>
    extends TagRegistry<T> {
        Simple(class_5321<? extends class_2378<T>> registry, String directory, Function<T, class_2960> locationProvider) {
            super(registry, directory, locationProvider);
        }

        @Override
        @SafeVarargs
        public final void add(class_6862<T> tagID, T ... elements) {
            super.add(tagID, elements);
        }

        @Override
        @SafeVarargs
        public final void addOptional(class_6862<T> tagID, T ... elements) {
            super.addOptional(tagID, elements);
        }

        @Override
        @SafeVarargs
        public final void add(T element, class_6862<T> ... tagIDs) {
            super.add(element, tagIDs);
        }

        @Override
        public final boolean contains(class_6862<T> tagID, T element) {
            return super.contains(tagID, element);
        }
    }

    public static class RegistryBacked<T>
    extends Simple<T> {
        private final class_7922<T> registry;

        RegistryBacked(class_7922<T> registry) {
            super(registry.method_30517(), class_3505.method_40099((class_5321)registry.method_30517()), element -> {
                class_2960 id = registry.method_10221(element);
                if (id != registry.method_10137()) {
                    return id;
                }
                return null;
            });
            this.registry = registry;
        }

        @Override
        public class_6862<T> makeTag(class_2960 id) {
            class_6862 tag = this.registry.method_40273().filter(tagKey -> tagKey.comp_327().equals((Object)id)).findAny().orElse(class_6862.method_40092((class_5321)this.registry.method_30517(), (class_2960)id));
            this.initializeTag(tag);
            return tag;
        }
    }
}

