/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.background.backgrounds.image;

import de.keksuccino.fancymenu.customization.background.MenuBackgroundBuilder;
import de.keksuccino.fancymenu.customization.background.SerializedMenuBackground;
import de.keksuccino.fancymenu.customization.background.backgrounds.image.ImageMenuBackground;
import de.keksuccino.fancymenu.customization.background.backgrounds.image.ImageMenuBackgroundConfigScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageMenuBackgroundBuilder
extends MenuBackgroundBuilder<ImageMenuBackground> {
    public ImageMenuBackgroundBuilder() {
        super("image");
    }

    @Override
    public void buildNewOrEditInstance(class_437 currentScreen, @Nullable ImageMenuBackground backgroundToEdit, @NotNull Consumer<ImageMenuBackground> backgroundConsumer) {
        ImageMenuBackground back;
        ImageMenuBackground imageMenuBackground = back = backgroundToEdit != null ? (ImageMenuBackground)backgroundToEdit.copy() : null;
        if (back == null) {
            back = new ImageMenuBackground(this);
        }
        ImageMenuBackgroundConfigScreen s = new ImageMenuBackgroundConfigScreen(back, background -> {
            if (background != null) {
                backgroundConsumer.accept((ImageMenuBackground)background);
            } else {
                backgroundConsumer.accept(backgroundToEdit);
            }
            class_310.method_1551().method_1507(currentScreen);
        });
        class_310.method_1551().method_1507((class_437)s);
    }

    @Override
    public ImageMenuBackground deserializeBackground(SerializedMenuBackground serializedMenuBackground) {
        ImageMenuBackground b = new ImageMenuBackground(this);
        b.textureSupplier = SerializationUtils.deserializeImageResourceSupplier(serializedMenuBackground.getValue("image_path"));
        String slide = serializedMenuBackground.getValue("slide");
        if (slide != null && slide.equals("true")) {
            b.slideLeftRight = true;
        }
        b.fallbackTextureSupplier = SerializationUtils.deserializeImageResourceSupplier(serializedMenuBackground.getValue("fallback_path"));
        if (b.fallbackTextureSupplier == null) {
            b.fallbackTextureSupplier = SerializationUtils.deserializeImageResourceSupplier(serializedMenuBackground.getValue("web_image_fallback_path"));
        }
        b.repeat = SerializationUtils.deserializeBoolean(b.repeat, serializedMenuBackground.getValue("repeat_texture"));
        return b;
    }

    @Override
    public SerializedMenuBackground serializedBackground(ImageMenuBackground background) {
        SerializedMenuBackground serialized = new SerializedMenuBackground();
        if (background.textureSupplier != null) {
            serialized.putProperty("image_path", background.textureSupplier.getSourceWithPrefix());
        }
        serialized.putProperty("slide", "" + background.slideLeftRight);
        serialized.putProperty("repeat_texture", "" + background.repeat);
        if (background.fallbackTextureSupplier != null) {
            serialized.putProperty("fallback_path", background.fallbackTextureSupplier.getSourceWithPrefix());
        }
        return serialized;
    }

    @Override
    @NotNull
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"fancymenu.background.image");
    }

    @Override
    @Nullable
    public class_2561[] getDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.background.image.desc", new String[0]);
    }
}

