/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.bcc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.wuffs.bcc.Constants;
import dev.wuffs.bcc.ModConfig;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    static Path configFile = FabricLoader.getInstance().getConfigDir().resolve("bcc.json");

    public static boolean create() {
        Constants.LOG.warn("Config file not found, creating default config");
        try {
            Files.write(configFile, new GsonBuilder().setPrettyPrinting().create().toJson((Object)new ModConfig()).getBytes(), StandardOpenOption.CREATE);
            return true;
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to create config file", (Throwable)e);
            return false;
        }
    }

    public static ModConfig load() {
        boolean didCreate;
        if (!Files.exists(configFile, new LinkOption[0]) && !(didCreate = Config.create())) {
            return null;
        }
        try {
            Constants.LOG.info("Loading config file");
            return (ModConfig)new Gson().fromJson((Reader)Files.newBufferedReader(configFile), ModConfig.class);
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to read config file", (Throwable)e);
            return null;
        }
    }
}

