/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.client.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.isxander.debugify.Debugify;
import dev.isxander.debugify.fixes.BugFixData;
import java.net.ConnectException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class BugFixDescriptionCache {
    private static final Path file = FabricLoader.getInstance().getConfigDir().resolve("debugify-descriptions.json");
    private static final Gson gson = new Gson();
    private final Map<String, String> descriptionHolder = new HashMap<String, String>();
    private final String url = "https://bugs.mojang.com/rest/api/2/issue/%s";

    public void cacheDescriptions() {
        Debugify.LOGGER.info("Connecting to 'bugs.mojang.com' to cache bug descriptions!");
        CompletableFuture.runAsync(() -> {
            HttpClient client = HttpClient.newHttpClient();
            boolean givenUp = false;
            for (BugFixData bugData : Debugify.CONFIG.getBugFixes().keySet()) {
                String id = bugData.bugId();
                int attempts = 0;
                boolean success = true;
                do {
                    try {
                        if (attempts >= 2) {
                            Debugify.LOGGER.error("Giving up trying to cache bug descriptions. Consecutive network failures.");
                            givenUp = true;
                            break;
                        }
                        ++attempts;
                        HttpRequest request = HttpRequest.newBuilder(new URI(String.format("https://bugs.mojang.com/rest/api/2/issue/%s", id))).build();
                        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                        if (response.statusCode() != 200) {
                            Debugify.LOGGER.error("Description Cache: {} - {}", (Object)response.statusCode(), (Object)response.body());
                            continue;
                        }
                        JsonObject json = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
                        JsonObject fields = json.getAsJsonObject("fields");
                        String summary = fields.get("summary").getAsString();
                        this.descriptionHolder.put(id, summary);
                        success = true;
                    }
                    catch (ConnectException e) {
                        Debugify.LOGGER.error("Couldn't connect to `bugs.mojang.com`", (Throwable)e);
                        success = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        success = false;
                    }
                } while (!success);
                if (!givenUp) continue;
                break;
            }
        }).thenAccept(returnVal -> this.save());
    }

    public void save() {
        try {
            Files.deleteIfExists(file);
            JsonObject json = new JsonObject();
            this.descriptionHolder.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
            Files.createFile(file, new FileAttribute[0]);
            Files.writeString(file, (CharSequence)gson.toJson((JsonElement)json), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean load() {
        Debugify.LOGGER.info("Loading Description Cache");
        if (!Files.exists(file, new LinkOption[0])) {
            return false;
        }
        try {
            String jsonString = Files.readString(file);
            JsonObject json = (JsonObject)gson.fromJson(jsonString, JsonObject.class);
            Map<String, String> loadedDescriptions = json.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, String>((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (loadedDescriptions.values().stream().anyMatch(desc -> desc.contains("\n"))) {
                Debugify.LOGGER.warn("Outdated description cache format, re-caching!");
                this.cacheDescriptions();
                return true;
            }
            this.descriptionHolder.putAll(loadedDescriptions);
        }
        catch (Exception e) {
            Debugify.LOGGER.error("Couldn't load description cache!");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String get(String id) {
        return this.descriptionHolder.get(id);
    }

    public boolean has(String id) {
        return this.descriptionHolder.containsKey(id);
    }
}

