/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mixin.accessor.CuboidAccessor;
import traben.entity_model_features.mixin.accessor.ModelPartAccessor;
import traben.entity_model_features.models.EMFModelPart;
import traben.entity_model_features.models.jem_objects.EMFBoxData;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.utils.EMFUtils;

@Environment(value=EnvType.CLIENT)
public class EMFModelPartCustom
extends EMFModelPart {
    public final String partToBeAttached;
    public final String id;
    public final boolean attach;

    public EMFModelPartCustom(EMFPartData emfPartData, int variant, @Nullable String part, String id) {
        super(EMFModelPartCustom.getCuboidsFromData(emfPartData), EMFModelPartCustom.getChildrenFromData(emfPartData, variant));
        this.attach = emfPartData.attach;
        this.partToBeAttached = part;
        this.id = id;
        this.textureOverride = emfPartData.customTexture;
        this.field_37938 = emfPartData.scale;
        this.field_37939 = emfPartData.scale;
        this.field_37940 = emfPartData.scale;
        this.field_3657 = emfPartData.translate[0];
        this.field_3656 = emfPartData.translate[1];
        this.field_3655 = emfPartData.translate[2];
        this.field_3654 = emfPartData.rotate[0];
        this.field_3675 = emfPartData.rotate[1];
        this.field_3674 = emfPartData.rotate[2];
        this.method_41918(this.method_32084());
        if (EMFConfig.getConfig().logModelCreationData) {
            System.out.println(" > > EMF custom part made: " + emfPartData.id);
        }
    }

    private static List<class_630.class_628> getCuboidsFromData(EMFPartData emfPartData) {
        return EMFModelPartCustom.createCuboidsFromBoxDataV3(emfPartData);
    }

    private static Map<String, class_630> getChildrenFromData(EMFPartData emfPartData, int variant) {
        HashMap<String, class_630> emfChildren = new HashMap<String, class_630>();
        for (EMFPartData sub : emfPartData.submodels) {
            String idUnique = EMFUtils.getIdUnique(emfChildren.keySet(), sub.id);
            emfChildren.put(idUnique, new EMFModelPartCustom(sub, variant, null, idUnique));
        }
        return emfChildren;
    }

    private static List<class_630.class_628> createCuboidsFromBoxDataV3(EMFPartData emfPartData) {
        LinkedList<class_630.class_628> emfCuboids = new LinkedList<class_630.class_628>();
        if (emfPartData.boxes.length > 0) {
            try {
                for (EMFBoxData box : emfPartData.boxes) {
                    EMFCuboid cube = box.textureOffset.length == 2 ? new EMFCuboid(emfPartData, box.textureOffset[0], box.textureOffset[1], box.coordinates[0], box.coordinates[1], box.coordinates[2], box.coordinates[3], box.coordinates[4], box.coordinates[5], box.sizeAdd, box.sizeAdd, box.sizeAdd, emfPartData.textureSize[0], emfPartData.textureSize[1], emfPartData.mirrorTexture.contains("u"), emfPartData.mirrorTexture.contains("v")) : new EMFCuboid(emfPartData, box.uvDown, box.uvUp, box.uvNorth, box.uvSouth, box.uvWest, box.uvEast, box.coordinates[0], box.coordinates[1], box.coordinates[2], box.coordinates[3], box.coordinates[4], box.coordinates[5], box.sizeAdd, box.sizeAdd, box.sizeAdd, emfPartData.textureSize[0], emfPartData.textureSize[1], emfPartData.mirrorTexture.contains("u"), emfPartData.mirrorTexture.contains("v"));
                    emfCuboids.add(cube);
                }
            }
            catch (Exception e) {
                EMFUtils.EMFModMessage("cuboid construction broke: " + e, false);
            }
        }
        return emfCuboids;
    }

    @Override
    public String toString() {
        return "EMFModelPartCustom{partToBeAttached='" + this.partToBeAttached + "', id='" + this.id + "', attach=" + this.attach + "}";
    }

    @Override
    void primaryRender(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        switch (EMFConfig.getConfig().renderModeChoice) {
            case NORMAL: {
                super.primaryRender(matrices, vertices, light, overlay, red, green, blue, alpha);
                break;
            }
            case GREEN: {
                float flash = (float)Math.abs(Math.sin((double)System.currentTimeMillis() / 1000.0));
                super.primaryRender(matrices, vertices, light, overlay, flash, green, flash, alpha);
                break;
            }
            case LINES: {
                if (!this.field_3665 || ((ModelPartAccessor)((Object)this)).getCuboids().isEmpty() && this.getChildrenEMF().isEmpty()) break;
                matrices.method_22903();
                this.method_22703(matrices);
                if (!this.field_38456) {
                    for (class_630.class_628 cuboid : ((ModelPartAccessor)((Object)this)).getCuboids()) {
                        class_238 box = new class_238((double)(cuboid.field_3645 / 16.0f), (double)(cuboid.field_3644 / 16.0f), (double)(cuboid.field_3643 / 16.0f), (double)(cuboid.field_3648 / 16.0f), (double)(cuboid.field_3647 / 16.0f), (double)(cuboid.field_3646 / 16.0f));
                        class_761.method_22982((class_4587)matrices, (class_4588)class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23594()), (class_238)box, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                }
                for (class_630 modelPart : this.getChildrenEMF().values()) {
                    modelPart.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha);
                }
                matrices.method_22909();
                break;
            }
        }
    }

    public void method_22699(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        this.primaryRender(matrices, vertices, light, overlay, red, green, blue, alpha);
    }

    @Override
    class_630 getVanillaModelPartsOfCurrentState() {
        HashMap<String, class_630> children = new HashMap<String, class_630>();
        for (Map.Entry<String, class_630> child : this.getChildrenEMF().entrySet()) {
            class_630 class_6302 = child.getValue();
            if (!(class_6302 instanceof EMFModelPartCustom)) continue;
            EMFModelPartCustom emf = (EMFModelPartCustom)class_6302;
            children.put(child.getKey(), emf.getVanillaModelPartsOfCurrentState());
        }
        class_630 part = new class_630(((ModelPartAccessor)((Object)this)).getCuboids(), children);
        part.method_41918(this.method_41921());
        part.field_3654 = this.field_3654;
        part.field_3674 = this.field_3674;
        part.field_3675 = this.field_3675;
        part.field_3655 = this.field_3655;
        part.field_3656 = this.field_3656;
        part.field_3657 = this.field_3657;
        part.field_37938 = this.field_37938;
        part.field_37939 = this.field_37939;
        part.field_37940 = this.field_37940;
        return part;
    }

    @Environment(value=EnvType.CLIENT)
    public static class EMFCuboid
    extends class_630.class_628 {
        private final class_630.class_593[] sidesEMF;

        public EMFCuboid(EMFPartData selfModelData, float textureU, float textureV, float cubeX, float cubeY, float cubeZ, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, float textureWidth, float textureHeight, boolean mirrorU, boolean mirrorV) {
            ArrayList<class_630.class_593> sides;
            block25: {
                float r;
                float q;
                float o;
                float n;
                class_630.class_618 vertex8;
                class_630.class_618 vertex7;
                class_630.class_618 vertex6;
                class_630.class_618 vertex5;
                block24: {
                    float l;
                    class_630.class_618 vertex4;
                    class_630.class_618 vertex3;
                    class_630.class_618 vertex2;
                    class_630.class_618 vertex;
                    block23: {
                        float k;
                        block22: {
                            float j;
                            block21: {
                                float p;
                                float m;
                                block20: {
                                    super((int)textureU, (int)textureV, cubeX, cubeY, cubeZ, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, false, textureWidth, textureHeight, (Set)new HashSet<class_2350>(){
                                        {
                                            this.addAll(List.of(class_2350.values()));
                                        }
                                    });
                                    CuboidAccessor accessor = (CuboidAccessor)((Object)this);
                                    accessor.setMinX(cubeX);
                                    accessor.setMinY(cubeY);
                                    accessor.setMinZ(cubeZ);
                                    accessor.setMaxX(cubeX + sizeX);
                                    accessor.setMaxY(cubeY + sizeY);
                                    accessor.setMaxZ(cubeZ + sizeZ);
                                    sides = new ArrayList<class_630.class_593>();
                                    float cubeX2 = cubeX + sizeX;
                                    float cubeY2 = cubeY + sizeY;
                                    float cubeZ2 = cubeZ + sizeZ;
                                    vertex = new class_630.class_618(cubeX -= extraX, cubeY -= extraY, cubeZ -= extraZ, 0.0f, 0.0f);
                                    vertex2 = new class_630.class_618(cubeX2 += extraX, cubeY, cubeZ, 0.0f, 8.0f);
                                    vertex3 = new class_630.class_618(cubeX2, cubeY2 += extraY, cubeZ, 8.0f, 8.0f);
                                    vertex4 = new class_630.class_618(cubeX, cubeY2, cubeZ, 8.0f, 0.0f);
                                    vertex5 = new class_630.class_618(cubeX, cubeY, cubeZ2 += extraZ, 0.0f, 0.0f);
                                    vertex6 = new class_630.class_618(cubeX2, cubeY, cubeZ2, 0.0f, 8.0f);
                                    vertex7 = new class_630.class_618(cubeX2, cubeY2, cubeZ2, 8.0f, 8.0f);
                                    vertex8 = new class_630.class_618(cubeX, cubeY2, cubeZ2, 8.0f, 0.0f);
                                    j = textureU;
                                    k = textureU + sizeZ;
                                    l = textureU + sizeZ + sizeX;
                                    m = textureU + sizeZ + sizeX + sizeX;
                                    n = textureU + sizeZ + sizeX + sizeZ;
                                    o = textureU + sizeZ + sizeX + sizeZ + sizeX;
                                    p = textureV;
                                    q = textureV + sizeZ;
                                    r = textureV + sizeZ + sizeY;
                                    try {
                                        class_630.class_618[] class_618Array;
                                        if (mirrorV) {
                                            class_630.class_618[] class_618Array2 = new class_630.class_618[4];
                                            class_618Array2[0] = vertex3;
                                            class_618Array2[1] = vertex4;
                                            class_618Array2[2] = vertex8;
                                            class_618Array = class_618Array2;
                                            class_618Array2[3] = vertex7;
                                        } else {
                                            class_630.class_618[] class_618Array3 = new class_630.class_618[4];
                                            class_618Array3[0] = vertex6;
                                            class_618Array3[1] = vertex5;
                                            class_618Array3[2] = vertex;
                                            class_618Array = class_618Array3;
                                            class_618Array3[3] = vertex2;
                                        }
                                        sides.add(new class_630.class_593(class_618Array, mirrorU ? l : k, mirrorV ? q : p, mirrorU ? k : l, mirrorV ? p : q, textureWidth, textureHeight, false, mirrorV ? class_2350.field_11036 : class_2350.field_11033));
                                    }
                                    catch (Exception e) {
                                        if (!EMFConfig.getConfig().logModelCreationData) break block20;
                                        EMFUtils.EMFModMessage("uv-dwn failed for " + selfModelData.id);
                                    }
                                }
                                try {
                                    class_630.class_618[] class_618Array;
                                    if (mirrorV) {
                                        class_630.class_618[] class_618Array4 = new class_630.class_618[4];
                                        class_618Array4[0] = vertex6;
                                        class_618Array4[1] = vertex5;
                                        class_618Array4[2] = vertex;
                                        class_618Array = class_618Array4;
                                        class_618Array4[3] = vertex2;
                                    } else {
                                        class_630.class_618[] class_618Array5 = new class_630.class_618[4];
                                        class_618Array5[0] = vertex3;
                                        class_618Array5[1] = vertex4;
                                        class_618Array5[2] = vertex8;
                                        class_618Array = class_618Array5;
                                        class_618Array5[3] = vertex7;
                                    }
                                    sides.add(new class_630.class_593(class_618Array, mirrorU ? m : l, mirrorV ? p : q, mirrorU ? l : m, mirrorV ? q : p, textureWidth, textureHeight, false, mirrorV ? class_2350.field_11033 : class_2350.field_11036));
                                }
                                catch (Exception e) {
                                    if (!EMFConfig.getConfig().logModelCreationData) break block21;
                                    EMFUtils.EMFModMessage("uv-up failed for " + selfModelData.id);
                                }
                            }
                            try {
                                class_630.class_618[] class_618Array;
                                if (mirrorU) {
                                    class_630.class_618[] class_618Array6 = new class_630.class_618[4];
                                    class_618Array6[0] = vertex6;
                                    class_618Array6[1] = vertex2;
                                    class_618Array6[2] = vertex3;
                                    class_618Array = class_618Array6;
                                    class_618Array6[3] = vertex7;
                                } else {
                                    class_630.class_618[] class_618Array7 = new class_630.class_618[4];
                                    class_618Array7[0] = vertex;
                                    class_618Array7[1] = vertex5;
                                    class_618Array7[2] = vertex8;
                                    class_618Array = class_618Array7;
                                    class_618Array7[3] = vertex4;
                                }
                                sides.add(new class_630.class_593(class_618Array, mirrorU ? k : j, mirrorV ? r : q, mirrorU ? j : k, mirrorV ? q : r, textureWidth, textureHeight, false, mirrorU ? class_2350.field_11034 : class_2350.field_11039));
                            }
                            catch (Exception e) {
                                if (!EMFConfig.getConfig().logModelCreationData) break block22;
                                EMFUtils.EMFModMessage("uv-west failed for " + selfModelData.id);
                            }
                        }
                        try {
                            sides.add(new class_630.class_593(new class_630.class_618[]{vertex2, vertex, vertex4, vertex3}, mirrorU ? l : k, mirrorV ? r : q, mirrorU ? k : l, mirrorV ? q : r, textureWidth, textureHeight, false, class_2350.field_11043));
                        }
                        catch (Exception e) {
                            if (!EMFConfig.getConfig().logModelCreationData) break block23;
                            EMFUtils.EMFModMessage("uv-nrth failed for " + selfModelData.id);
                        }
                    }
                    try {
                        class_630.class_618[] class_618Array;
                        if (mirrorU) {
                            class_630.class_618[] class_618Array8 = new class_630.class_618[4];
                            class_618Array8[0] = vertex;
                            class_618Array8[1] = vertex5;
                            class_618Array8[2] = vertex8;
                            class_618Array = class_618Array8;
                            class_618Array8[3] = vertex4;
                        } else {
                            class_630.class_618[] class_618Array9 = new class_630.class_618[4];
                            class_618Array9[0] = vertex6;
                            class_618Array9[1] = vertex2;
                            class_618Array9[2] = vertex3;
                            class_618Array = class_618Array9;
                            class_618Array9[3] = vertex7;
                        }
                        sides.add(new class_630.class_593(class_618Array, mirrorU ? n : l, mirrorV ? r : q, mirrorU ? l : n, mirrorV ? q : r, textureWidth, textureHeight, false, mirrorU ? class_2350.field_11039 : class_2350.field_11034));
                    }
                    catch (Exception e) {
                        if (!EMFConfig.getConfig().logModelCreationData) break block24;
                        EMFUtils.EMFModMessage("uv-east failed for " + selfModelData.id);
                    }
                }
                try {
                    sides.add(new class_630.class_593(new class_630.class_618[]{vertex5, vertex6, vertex7, vertex8}, mirrorU ? o : n, mirrorV ? r : q, mirrorU ? n : o, mirrorV ? q : r, textureWidth, textureHeight, false, class_2350.field_11035));
                }
                catch (Exception e) {
                    if (!EMFConfig.getConfig().logModelCreationData) break block25;
                    EMFUtils.EMFModMessage("uv-sth failed for " + selfModelData.id);
                }
            }
            this.sidesEMF = sides.toArray(new class_630.class_593[0]);
            ((CuboidAccessor)((Object)this)).setSides(this.sidesEMF);
        }

        public EMFCuboid(EMFPartData selfModelData, float[] uvDown, float[] uvUp, float[] uvNorth, float[] uvSouth, float[] uvWest, float[] uvEast, float cubeX, float cubeY, float cubeZ, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, float textureWidth, float textureHeight, boolean mirrorU, boolean mirrorV) {
            ArrayList<class_630.class_593> sides;
            block25: {
                class_630.class_618 vertex8;
                class_630.class_618 vertex7;
                class_630.class_618 vertex6;
                class_630.class_618 vertex5;
                block24: {
                    class_630.class_618 vertex4;
                    class_630.class_618 vertex3;
                    class_630.class_618 vertex2;
                    class_630.class_618 vertex;
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    super(0, 0, cubeX, cubeY, cubeZ, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, false, textureWidth, textureHeight, (Set)new HashSet<class_2350>(){
                                        {
                                            this.addAll(List.of(class_2350.values()));
                                        }
                                    });
                                    CuboidAccessor accessor = (CuboidAccessor)((Object)this);
                                    accessor.setMinX(cubeX);
                                    accessor.setMinY(cubeY);
                                    accessor.setMinZ(cubeZ);
                                    accessor.setMaxX(cubeX + sizeX);
                                    accessor.setMaxY(cubeY + sizeY);
                                    accessor.setMaxZ(cubeZ + sizeZ);
                                    sides = new ArrayList<class_630.class_593>();
                                    float cubeX2 = cubeX + sizeX;
                                    float cubeY2 = cubeY + sizeY;
                                    float cubeZ2 = cubeZ + sizeZ;
                                    vertex = new class_630.class_618(cubeX -= extraX, cubeY -= extraY, cubeZ -= extraZ, 0.0f, 0.0f);
                                    vertex2 = new class_630.class_618(cubeX2 += extraX, cubeY, cubeZ, 0.0f, 8.0f);
                                    vertex3 = new class_630.class_618(cubeX2, cubeY2 += extraY, cubeZ, 8.0f, 8.0f);
                                    vertex4 = new class_630.class_618(cubeX, cubeY2, cubeZ, 8.0f, 0.0f);
                                    vertex5 = new class_630.class_618(cubeX, cubeY, cubeZ2 += extraZ, 0.0f, 0.0f);
                                    vertex6 = new class_630.class_618(cubeX2, cubeY, cubeZ2, 0.0f, 8.0f);
                                    vertex7 = new class_630.class_618(cubeX2, cubeY2, cubeZ2, 8.0f, 8.0f);
                                    vertex8 = new class_630.class_618(cubeX, cubeY2, cubeZ2, 8.0f, 0.0f);
                                    try {
                                        class_630.class_618[] class_618Array;
                                        if (mirrorV) {
                                            class_630.class_618[] class_618Array2 = new class_630.class_618[4];
                                            class_618Array2[0] = vertex8;
                                            class_618Array2[1] = vertex7;
                                            class_618Array2[2] = vertex3;
                                            class_618Array = class_618Array2;
                                            class_618Array2[3] = vertex4;
                                        } else {
                                            class_630.class_618[] class_618Array3 = new class_630.class_618[4];
                                            class_618Array3[0] = vertex;
                                            class_618Array3[1] = vertex2;
                                            class_618Array3[2] = vertex6;
                                            class_618Array = class_618Array3;
                                            class_618Array3[3] = vertex5;
                                        }
                                        sides.add(new class_630.class_593(class_618Array, mirrorU ? uvUp[2] : uvUp[0], mirrorV ? uvUp[3] : uvUp[1], mirrorU ? uvUp[0] : uvUp[2], mirrorV ? uvUp[1] : uvUp[3], textureWidth, textureHeight, false, mirrorV ? class_2350.field_11036 : class_2350.field_11033));
                                    }
                                    catch (Exception e) {
                                        if (!EMFConfig.getConfig().logModelCreationData) break block20;
                                        EMFUtils.EMFModMessage("uv-up failed for " + selfModelData.id);
                                    }
                                }
                                try {
                                    class_630.class_618[] class_618Array;
                                    if (mirrorV) {
                                        class_630.class_618[] class_618Array4 = new class_630.class_618[4];
                                        class_618Array4[0] = vertex;
                                        class_618Array4[1] = vertex2;
                                        class_618Array4[2] = vertex6;
                                        class_618Array = class_618Array4;
                                        class_618Array4[3] = vertex5;
                                    } else {
                                        class_630.class_618[] class_618Array5 = new class_630.class_618[4];
                                        class_618Array5[0] = vertex8;
                                        class_618Array5[1] = vertex7;
                                        class_618Array5[2] = vertex3;
                                        class_618Array = class_618Array5;
                                        class_618Array5[3] = vertex4;
                                    }
                                    sides.add(new class_630.class_593(class_618Array, mirrorU ? uvDown[2] : uvDown[0], mirrorV ? uvDown[3] : uvDown[1], mirrorU ? uvDown[0] : uvDown[2], mirrorV ? uvDown[1] : uvDown[3], textureWidth, textureHeight, false, mirrorV ? class_2350.field_11033 : class_2350.field_11036));
                                }
                                catch (Exception e) {
                                    if (!EMFConfig.getConfig().logModelCreationData) break block21;
                                    EMFUtils.EMFModMessage("uv-down failed for " + selfModelData.id);
                                }
                            }
                            try {
                                class_630.class_618[] class_618Array;
                                if (mirrorU) {
                                    class_630.class_618[] class_618Array6 = new class_630.class_618[4];
                                    class_618Array6[0] = vertex;
                                    class_618Array6[1] = vertex5;
                                    class_618Array6[2] = vertex8;
                                    class_618Array = class_618Array6;
                                    class_618Array6[3] = vertex4;
                                } else {
                                    class_630.class_618[] class_618Array7 = new class_630.class_618[4];
                                    class_618Array7[0] = vertex6;
                                    class_618Array7[1] = vertex2;
                                    class_618Array7[2] = vertex3;
                                    class_618Array = class_618Array7;
                                    class_618Array7[3] = vertex7;
                                }
                                sides.add(new class_630.class_593(class_618Array, mirrorU ? uvWest[2] : uvWest[0], mirrorV ? uvWest[3] : uvWest[1], mirrorU ? uvWest[0] : uvWest[2], mirrorV ? uvWest[1] : uvWest[3], textureWidth, textureHeight, false, mirrorU ? class_2350.field_11039 : class_2350.field_11034));
                            }
                            catch (Exception e) {
                                if (!EMFConfig.getConfig().logModelCreationData) break block22;
                                EMFUtils.EMFModMessage("uv-west failed for " + selfModelData.id);
                            }
                        }
                        try {
                            sides.add(new class_630.class_593(new class_630.class_618[]{vertex2, vertex, vertex4, vertex3}, mirrorU ? uvNorth[2] : uvNorth[0], mirrorV ? uvNorth[3] : uvNorth[1], mirrorU ? uvNorth[0] : uvNorth[2], mirrorV ? uvNorth[1] : uvNorth[3], textureWidth, textureHeight, false, class_2350.field_11043));
                        }
                        catch (Exception e) {
                            if (!EMFConfig.getConfig().logModelCreationData) break block23;
                            EMFUtils.EMFModMessage("uv-north failed for " + selfModelData.id);
                        }
                    }
                    try {
                        class_630.class_618[] class_618Array;
                        if (mirrorU) {
                            class_630.class_618[] class_618Array8 = new class_630.class_618[4];
                            class_618Array8[0] = vertex6;
                            class_618Array8[1] = vertex2;
                            class_618Array8[2] = vertex3;
                            class_618Array = class_618Array8;
                            class_618Array8[3] = vertex7;
                        } else {
                            class_630.class_618[] class_618Array9 = new class_630.class_618[4];
                            class_618Array9[0] = vertex;
                            class_618Array9[1] = vertex5;
                            class_618Array9[2] = vertex8;
                            class_618Array = class_618Array9;
                            class_618Array9[3] = vertex4;
                        }
                        sides.add(new class_630.class_593(class_618Array, mirrorU ? uvEast[2] : uvEast[0], mirrorV ? uvEast[3] : uvEast[1], mirrorU ? uvEast[0] : uvEast[2], mirrorV ? uvEast[1] : uvEast[3], textureWidth, textureHeight, false, mirrorU ? class_2350.field_11034 : class_2350.field_11039));
                    }
                    catch (Exception e) {
                        if (!EMFConfig.getConfig().logModelCreationData) break block24;
                        EMFUtils.EMFModMessage("uv-east failed for " + selfModelData.id);
                    }
                }
                try {
                    sides.add(new class_630.class_593(new class_630.class_618[]{vertex5, vertex6, vertex7, vertex8}, mirrorU ? uvSouth[2] : uvSouth[0], mirrorV ? uvSouth[3] : uvSouth[1], mirrorU ? uvSouth[0] : uvSouth[2], mirrorV ? uvSouth[1] : uvSouth[3], textureWidth, textureHeight, false, class_2350.field_11035));
                }
                catch (Exception e) {
                    if (!EMFConfig.getConfig().logModelCreationData) break block25;
                    EMFUtils.EMFModMessage("uv-south failed for " + selfModelData.id);
                }
            }
            this.sidesEMF = sides.toArray(new class_630.class_593[0]);
            ((CuboidAccessor)((Object)this)).setSides(this.sidesEMF);
        }
    }
}

