/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.mixin.accessor.ModelPartAccessor;
import traben.entity_model_features.models.EMFModelPart;

public abstract class EMFModelPartWithState
extends EMFModelPart {
    public final Int2ObjectOpenHashMap<EMFModelState> allKnownStateVariants = new Int2ObjectOpenHashMap();
    public int currentModelVariantState = 0;
    Map<String, class_630> vanillaChildren = new HashMap<String, class_630>();
    Consumer<EMFModelPartWithState> startOfRenderRunnable = null;
    EMFModelPart.Animator tryAnimate = new EMFModelPart.Animator();

    public EMFModelPartWithState(List<class_630.class_628> cuboids, Map<String, class_630> children) {
        super(cuboids, children);
    }

    void receiveStartOfRenderRunnable(Consumer<EMFModelPartWithState> run) {
        this.startOfRenderRunnable = run;
        this.getChildrenEMF().values().forEach(child -> {
            if (child instanceof EMFModelPartWithState) {
                EMFModelPartWithState emf = (EMFModelPartWithState)((Object)child);
                emf.receiveStartOfRenderRunnable(run);
            }
        });
    }

    public void method_22699(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (this.startOfRenderRunnable != null) {
            this.startOfRenderRunnable.accept(this);
        }
        if (this.tryAnimate != null) {
            this.tryAnimate.run();
        }
        this.primaryRender(matrices, vertices, light, overlay, red, green, blue, alpha);
    }

    EMFModelState getCurrentState() {
        return new EMFModelState(this.method_41921(), ((ModelPartAccessor)((Object)this)).getCuboids(), this.getChildrenEMF(), this.field_37938, this.field_37939, this.field_37940, this.field_3665, this.field_38456, this.textureOverride, this.tryAnimate);
    }

    EMFModelState getStateOf(class_630 modelPart) {
        if (modelPart instanceof EMFModelPartWithState) {
            EMFModelPartWithState emf = (EMFModelPartWithState)modelPart;
            return new EMFModelState(modelPart.method_41921(), ((ModelPartAccessor)modelPart).getCuboids(), emf.getChildrenEMF(), modelPart.field_37938, modelPart.field_37939, modelPart.field_37940, modelPart.field_3665, modelPart.field_38456, emf.textureOverride, emf.tryAnimate);
        }
        return new EMFModelState(modelPart.method_41921(), ((ModelPartAccessor)modelPart).getCuboids(), new HashMap<String, class_630>(), modelPart.field_37938, modelPart.field_37939, modelPart.field_37940, modelPart.field_3665, modelPart.field_38456, null, new EMFModelPart.Animator());
    }

    void setFromState(EMFModelState newState) {
        this.method_41918(newState.defaultTransform());
        this.method_32085(this.method_41921());
        ((ModelPartAccessor)((Object)this)).setCuboids(newState.cuboids());
        ((ModelPartAccessor)((Object)this)).setChildren(newState.variantChildren());
        this.field_37938 = newState.xScale();
        this.field_37939 = newState.yScale();
        this.field_37940 = newState.zScale();
        this.field_3665 = newState.visible();
        this.field_38456 = newState.hidden();
        this.textureOverride = newState.texture();
        this.tryAnimate = newState.animation();
    }

    void setFromStateVariant(EMFModelState newState, @Nullable EMFModelState oldState) {
        class_5603 oldDefault = this.method_41921();
        this.method_41918(newState.defaultTransform());
        this.setTransformOnlyChangingDefaults(this.method_41921(), oldDefault);
        ((ModelPartAccessor)((Object)this)).setCuboids(newState.cuboids());
        ((ModelPartAccessor)((Object)this)).setChildren(newState.variantChildren());
        if (oldState == null || this.field_37938 == oldState.xScale()) {
            this.field_37938 = newState.xScale();
        }
        if (oldState == null || this.field_37939 == oldState.yScale()) {
            this.field_37939 = newState.yScale();
        }
        if (oldState == null || this.field_37940 == oldState.zScale()) {
            this.field_37940 = newState.zScale();
        }
        if (oldState == null || this.field_3665 == oldState.visible()) {
            this.field_3665 = newState.visible();
        }
        if (oldState == null || this.field_38456 == oldState.hidden()) {
            this.field_38456 = newState.hidden();
        }
        this.textureOverride = newState.texture();
        this.tryAnimate = newState.animation();
    }

    public void setTransformOnlyChangingDefaults(class_5603 newDefault, class_5603 oldDefault) {
        if (this.field_3657 == oldDefault.field_27702) {
            this.field_3657 = newDefault.field_27702;
        }
        if (this.field_3656 == oldDefault.field_27703) {
            this.field_3656 = newDefault.field_27703;
        }
        if (this.field_3655 == oldDefault.field_27702) {
            this.field_3655 = newDefault.field_27704;
        }
        if (this.field_3654 == oldDefault.field_27705) {
            this.field_3654 = newDefault.field_27705;
        }
        if (this.field_3675 == oldDefault.field_27706) {
            this.field_3675 = newDefault.field_27706;
        }
        if (this.field_3674 == oldDefault.field_27707) {
            this.field_3674 = newDefault.field_27707;
        }
    }

    public void setVariantStateTo(int newVariantState) {
        if (this.currentModelVariantState != newVariantState) {
            this.currentModelVariantState = newVariantState;
            if (this.allKnownStateVariants.containsKey(newVariantState)) {
                this.setFromStateVariant((EMFModelState)this.allKnownStateVariants.get(newVariantState), (EMFModelState)this.allKnownStateVariants.get(this.currentModelVariantState));
            }
            for (class_630 part : this.getChildrenEMF().values()) {
                if (!(part instanceof EMFModelPartWithState)) continue;
                EMFModelPartWithState p3 = (EMFModelPartWithState)part;
                p3.setVariantStateTo(newVariantState);
            }
        }
    }

    record EMFModelState(class_5603 defaultTransform, List<class_630.class_628> cuboids, Map<String, class_630> variantChildren, float xScale, float yScale, float zScale, boolean visible, boolean hidden, class_2960 texture, EMFModelPart.Animator animation) {
        public static EMFModelState copy(EMFModelState copyFrom) {
            class_5603 trans = copyFrom.defaultTransform();
            EMFModelPart.Animator animator = new EMFModelPart.Animator();
            animator.setAnimation(copyFrom.animation().getAnimation());
            return new EMFModelState(class_5603.method_32091((float)trans.field_27702, (float)trans.field_27703, (float)trans.field_27704, (float)trans.field_27705, (float)trans.field_27706, (float)trans.field_27707), new ArrayList<class_630.class_628>(copyFrom.cuboids()), new HashMap<String, class_630>(copyFrom.variantChildren()), copyFrom.xScale(), copyFrom.yScale(), copyFrom.zScale(), copyFrom.visible(), copyFrom.hidden(), copyFrom.texture(), animator);
        }
    }
}

