/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1451;
import net.minecraft.class_1453;
import net.minecraft.class_1493;
import net.minecraft.class_1676;
import net.minecraft.class_1690;
import net.minecraft.class_1695;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4019;
import net.minecraft.class_5354;
import net.minecraft.class_7134;
import net.minecraft.class_922;
import traben.entity_model_features.mixin.accessor.EntityRenderDispatcherAccessor;
import traben.entity_model_features.mixin.accessor.MinecraftClientAccessor;
import traben.entity_model_features.utils.EMFBlockEntityWrapper;
import traben.entity_model_features.utils.EMFEntity;
import traben.entity_model_features.utils.EMFEntityWrapper;
import traben.entity_model_features.utils.EMFManager;
import traben.entity_texture_features.texture_features.ETFManager;

public class EMFAnimationHelper {
    private static final Object2IntOpenHashMap<UUID> knownHighestAngerTimeByUUID = new Object2IntOpenHashMap<UUID>(){
        {
            this.defaultReturnValue(0);
        }
    };
    private static EMFEntity emfEntity = null;
    private static float shadowSize = Float.NaN;
    private static float shadowOpacity = Float.NaN;
    private static float leashX = Float.NaN;
    private static float leashY = Float.NaN;
    private static float leashZ = Float.NaN;
    private static float shadowX = Float.NaN;
    private static float shadowZ = Float.NaN;
    private static float limbAngle = Float.NaN;
    private static float limbDistance = Float.NaN;
    private static float headYaw = Float.NaN;
    private static float headPitch = Float.NaN;
    private static float tickDelta = 0.0f;
    private static int ruleIndex = 0;
    private static float dimension = Float.NaN;
    private static boolean onShoulder = false;

    private EMFAnimationHelper() {
    }

    public static void setCurrentEntity(class_1297 entityIn) {
        EMFAnimationHelper.resetForNewEntity();
        ++EMFManager.getInstance().entityRenderCount;
        emfEntity = entityIn == null ? null : new EMFEntityWrapper(entityIn);
    }

    public static void setCurrentBlockEntity(class_2586 entityIn) {
        EMFAnimationHelper.resetForNewEntity();
        ++EMFManager.getInstance().entityRenderCount;
        emfEntity = entityIn == null ? null : new EMFBlockEntityWrapper(entityIn);
    }

    public static void resetForNewEntity() {
        dimension = Float.NaN;
        limbAngle = Float.NaN;
        limbDistance = Float.NaN;
        headYaw = Float.NaN;
        headPitch = Float.NaN;
        tickDelta = class_310.method_1551().method_1493() ? ((MinecraftClientAccessor)class_310.method_1551()).getPausedTickDelta() : class_310.method_1551().method_1488();
        ruleIndex = 0;
        shadowSize = Float.NaN;
        shadowOpacity = Float.NaN;
        leashX = 0.0f;
        leashY = 0.0f;
        leashZ = 0.0f;
        shadowX = 0.0f;
        shadowZ = 0.0f;
        onShoulder = false;
    }

    public static float getRuleIndex() {
        if (emfEntity == null) {
            return 0.0f;
        }
        Integer index = (Integer)ETFManager.getInstance().LAST_MET_RULE_INDEX.get((Object)emfEntity.getUuid());
        return index == null ? 0.0f : (float)index.intValue();
    }

    public static EMFEntity getEMFEntity() {
        return emfEntity;
    }

    public static float getDimension() {
        if (Float.isNaN(dimension)) {
            class_2960 id;
            dimension = emfEntity == null || emfEntity.getWorld() == null ? 0.0f : ((id = emfEntity.getWorld().method_44013().method_29177()).equals((Object)class_7134.field_37671) ? -1.0f : (id.equals((Object)class_7134.field_37672) ? 1.0f : 0.0f));
        }
        return dimension;
    }

    public static float getPlayerX() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)class_3532.method_16436((double)tickDelta, (double)class_310.method_1551().field_1724.field_6014, (double)class_310.method_1551().field_1724.method_23317());
    }

    public static float getPlayerY() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)class_3532.method_16436((double)tickDelta, (double)class_310.method_1551().field_1724.field_6036, (double)class_310.method_1551().field_1724.method_23318());
    }

    public static float getPlayerZ() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)class_3532.method_16436((double)tickDelta, (double)class_310.method_1551().field_1724.field_5969, (double)class_310.method_1551().field_1724.method_23321());
    }

    public static float getPlayerRX() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)Math.toRadians(class_3532.method_17821((float)tickDelta, (float)class_310.method_1551().field_1724.field_6004, (float)class_310.method_1551().field_1724.method_36455()));
    }

    public static float getPlayerRY() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)Math.toRadians(class_3532.method_17821((float)tickDelta, (float)class_310.method_1551().field_1724.field_5982, (float)class_310.method_1551().field_1724.method_36454()));
    }

    public static float getEntityX() {
        return emfEntity == null ? 0.0f : (float)class_3532.method_16436((double)EMFAnimationHelper.getTickDelta(), (double)emfEntity.prevX(), (double)emfEntity.getX());
    }

    public static float getEntityY() {
        return emfEntity == null ? 0.0f : (float)class_3532.method_16436((double)EMFAnimationHelper.getTickDelta(), (double)emfEntity.prevY(), (double)emfEntity.getY());
    }

    public static float getEntityZ() {
        return emfEntity == null ? 0.0f : (float)class_3532.method_16436((double)EMFAnimationHelper.getTickDelta(), (double)emfEntity.prevZ(), (double)emfEntity.getZ());
    }

    public static float getEntityRX() {
        return emfEntity == null ? 0.0f : (float)Math.toRadians(class_3532.method_17821((float)tickDelta, (float)emfEntity.prevPitch(), (float)emfEntity.getPitch()));
    }

    public static float getEntityRY() {
        if (emfEntity == null) {
            return 0.0f;
        }
        class_1309 alive = emfEntity.getLiving();
        return alive != null ? (float)Math.toRadians(class_3532.method_17821((float)tickDelta, (float)alive.field_6220, (float)alive.method_43078())) : (emfEntity.entity() != null ? (float)Math.toRadians(class_3532.method_17821((float)tickDelta, (float)EMFAnimationHelper.emfEntity.entity().field_5982, (float)emfEntity.entity().method_36454())) : 0.0f);
    }

    public static float getTime() {
        if (emfEntity == null || emfEntity.getWorld() == null) {
            return 0.0f + tickDelta;
        }
        long upTimeInTicks = emfEntity.getWorld().method_8510();
        return EMFAnimationHelper.constrainedFloat(upTimeInTicks, 720720) + tickDelta;
    }

    public static float getDayTime() {
        if (emfEntity == null || emfEntity.getWorld() == null) {
            return 0.0f + tickDelta;
        }
        return EMFAnimationHelper.constrainedFloat(emfEntity.getWorld().method_8532(), 24000) + tickDelta;
    }

    public static float getDayCount() {
        if (emfEntity == null || emfEntity.getWorld() == null) {
            return 0.0f + tickDelta;
        }
        return (float)(emfEntity.getWorld().method_8532() / 24000L) + tickDelta;
    }

    public static float getHealth() {
        if (emfEntity == null) {
            return 0.0f;
        }
        class_1309 alive = emfEntity.getLiving();
        return alive != null ? alive.method_6032() : 1.0f;
    }

    public static float getDeathTime() {
        if (emfEntity == null) {
            return 0.0f;
        }
        class_1309 alive = emfEntity.getLiving();
        return alive != null ? (float)alive.field_6213 : 0.0f;
    }

    public static float getAngerTime() {
        if (emfEntity == null) {
            return 0.0f;
        }
        class_1309 alive = emfEntity.getLiving();
        if (!(alive instanceof class_5354)) {
            return 0.0f;
        }
        float currentKnownHighest = knownHighestAngerTimeByUUID.getInt((Object)emfEntity.getUuid());
        int angerTime = ((class_5354)alive).method_29507();
        if (angerTime <= 0) {
            knownHighestAngerTimeByUUID.put((Object)emfEntity.getUuid(), 0);
            return 0.0f;
        }
        if ((float)angerTime > currentKnownHighest) {
            knownHighestAngerTimeByUUID.put((Object)emfEntity.getUuid(), angerTime);
        }
        return (float)angerTime - tickDelta;
    }

    public static float getAngerTimeStart() {
        if (emfEntity == null) {
            return 0.0f;
        }
        class_1309 alive = emfEntity.getLiving();
        return !(alive instanceof class_5354) ? 0.0f : (float)knownHighestAngerTimeByUUID.getInt((Object)alive.method_5667());
    }

    public static float getMaxHealth() {
        if (emfEntity == null) {
            return 1.0f;
        }
        class_1309 alive = emfEntity.getLiving();
        return alive != null ? alive.method_6063() : 1.0f;
    }

    public static float getId() {
        return emfEntity == null ? 0.0f : (float)emfEntity.getUuid().hashCode();
    }

    public static float getHurtTime() {
        if (emfEntity == null) {
            return 0.0f;
        }
        class_1309 alive = emfEntity.getLiving();
        return alive != null ? (alive.field_6235 > 0 ? (float)alive.field_6235 - tickDelta : 0.0f) : 0.0f;
    }

    public static boolean isInWater() {
        return emfEntity != null && emfEntity.isTouchingWater();
    }

    public static boolean isBurning() {
        return emfEntity != null && emfEntity.isOnFire();
    }

    public static boolean isRiding() {
        return emfEntity != null && emfEntity.hasVehicle();
    }

    public static boolean isChild() {
        if (emfEntity == null) {
            return false;
        }
        class_1309 alive = emfEntity.getLiving();
        return alive != null && alive.method_6109();
    }

    public static boolean isOnGround() {
        return emfEntity != null && emfEntity.isOnGround();
    }

    public static boolean isClimbing() {
        if (emfEntity == null) {
            return false;
        }
        class_1309 alive = emfEntity.getLiving();
        return alive != null && alive.method_6101();
    }

    public static boolean isAlive() {
        if (emfEntity == null) {
            return false;
        }
        return emfEntity.isAlive();
    }

    public static boolean isAggressive() {
        if (emfEntity == null) {
            return false;
        }
        class_1297 entity = emfEntity.entity();
        return entity instanceof class_1308 && ((class_1308)entity).method_6510();
    }

    public static boolean isGlowing() {
        return emfEntity != null && emfEntity.isGlowing();
    }

    public static boolean isHurt() {
        if (emfEntity == null) {
            return false;
        }
        class_1309 alive = emfEntity.getLiving();
        return alive != null && alive.field_6235 > 0;
    }

    public static boolean isInHand() {
        return false;
    }

    public static boolean isInItemFrame() {
        return false;
    }

    public static boolean isInGround() {
        class_1676 proj;
        if (emfEntity == null) {
            return false;
        }
        class_1297 entity = emfEntity.entity();
        return entity instanceof class_1676 && (proj = (class_1676)entity).method_5757();
    }

    public static boolean isInGui() {
        return class_310.method_1551().field_1755 != null && !((EntityRenderDispatcherAccessor)class_310.method_1551().method_1561()).isRenderShadows();
    }

    public static boolean isInLava() {
        return emfEntity != null && emfEntity.isInLava();
    }

    public static boolean isInvisible() {
        return emfEntity != null && emfEntity.isInvisible();
    }

    public static boolean isOnHead() {
        return false;
    }

    public static boolean isOnShoulder() {
        return onShoulder;
    }

    public static void setCurrentEntityOnShoulder() {
        onShoulder = true;
    }

    public static boolean isRidden() {
        return emfEntity != null && emfEntity.hasPassengers();
    }

    public static boolean isSitting() {
        class_1493 wolf;
        class_1451 cat;
        class_1453 parrot;
        class_4019 fox;
        class_1321 tame;
        if (emfEntity == null) {
            return false;
        }
        class_1309 alive = emfEntity.getLiving();
        return alive != null && (alive instanceof class_1321 && (tame = (class_1321)alive).method_6172() || alive instanceof class_4019 && (fox = (class_4019)alive).method_18272() || alive instanceof class_1453 && (parrot = (class_1453)alive).method_6172() || alive instanceof class_1451 && (cat = (class_1451)alive).method_6172() || alive instanceof class_1493 && (wolf = (class_1493)alive).method_6172());
    }

    public static boolean isSneaking() {
        return emfEntity != null && emfEntity.isSneaking();
    }

    public static boolean isSprinting() {
        return emfEntity != null && emfEntity.isSprinting();
    }

    public static boolean isTamed() {
        class_1321 tame;
        if (emfEntity == null) {
            return false;
        }
        class_1309 alive = emfEntity.getLiving();
        return alive instanceof class_1321 && (tame = (class_1321)alive).method_6181();
    }

    public static boolean isWet() {
        return emfEntity != null && emfEntity.isWet();
    }

    public static float getSwingProgress() {
        if (emfEntity == null) {
            return 0.0f;
        }
        class_1309 alive = emfEntity.getLiving();
        return alive != null ? alive.method_6055(tickDelta) : 0.0f;
    }

    public static float getAge() {
        if (emfEntity == null) {
            return 0.0f + tickDelta;
        }
        return EMFAnimationHelper.constrainedFloat(emfEntity.age(), 24000) + tickDelta;
    }

    private static float constrainedFloat(float value, int constraint) {
        return value >= (float)constraint ? value % (float)constraint : value;
    }

    private static float constrainedFloat(float value) {
        return EMFAnimationHelper.constrainedFloat(value, 24000);
    }

    private static float constrainedFloat(long value, int constraint) {
        return value >= (long)constraint ? value % (long)constraint : value;
    }

    private static float constrainedFloat(long value) {
        return EMFAnimationHelper.constrainedFloat(value, 24000);
    }

    private static float constrainedFloat(int value, int constraint) {
        return value >= constraint ? value % constraint : value;
    }

    private static float constrainedFloat(int value) {
        return EMFAnimationHelper.constrainedFloat(value, 24000);
    }

    public static float getFrameTime() {
        return class_310.method_1551().method_1534() / 20.0f;
    }

    public static float getLimbAngle() {
        if (emfEntity == null) {
            return 0.0f;
        }
        if (Float.isNaN(limbAngle)) {
            EMFAnimationHelper.doLimbValues();
        }
        return limbAngle;
    }

    public static void setLimbAngle(float limbAngle) {
        EMFAnimationHelper.limbAngle = limbAngle;
    }

    public static float getLimbDistance() {
        if (emfEntity == null) {
            return 0.0f;
        }
        if (Float.isNaN(limbDistance)) {
            EMFAnimationHelper.doLimbValues();
        }
        return limbDistance == Float.MIN_VALUE ? 0.0f : limbDistance;
    }

    public static void setLimbDistance(float limbDistance) {
        EMFAnimationHelper.limbDistance = limbDistance;
    }

    private static void doLimbValues() {
        float o = 0.0f;
        float n = 0.0f;
        class_1309 alive = emfEntity.getLiving();
        if (!emfEntity.hasVehicle() && alive != null) {
            o = alive.field_42108.method_48572(tickDelta);
            n = alive.field_42108.method_48570(tickDelta);
            if (alive.method_6109()) {
                o *= 3.0f;
            }
            if (n > 1.0f) {
                n = 1.0f;
            }
        } else if (emfEntity.entity() instanceof class_1695) {
            n = 1.0f;
            o = -(EMFAnimationHelper.getEntityX() + EMFAnimationHelper.getEntityZ());
        } else {
            class_1297 class_12972 = emfEntity.entity();
            if (class_12972 instanceof class_1690) {
                class_1690 boat = (class_1690)class_12972;
                n = 1.0f;
                o = Math.max(boat.method_7551(1, tickDelta), boat.method_7551(0, tickDelta));
            }
        }
        limbDistance = n;
        limbAngle = o;
    }

    public static float getHeadYaw() {
        if (emfEntity == null) {
            return 0.0f;
        }
        if (Float.isNaN(headYaw)) {
            EMFAnimationHelper.doHeadValues();
        }
        return headYaw;
    }

    public static void setHeadYaw(float headYaw) {
        EMFAnimationHelper.headYaw = headYaw;
    }

    public static float getHeadPitch() {
        if (emfEntity == null) {
            return 0.0f;
        }
        if (Float.isNaN(headPitch)) {
            EMFAnimationHelper.doHeadValues();
        }
        return headPitch;
    }

    public static void setHeadPitch(float headPitch) {
        EMFAnimationHelper.headPitch = headPitch;
    }

    private static void doHeadValues() {
        class_1309 livingEntity = emfEntity.getLiving();
        if (livingEntity != null) {
            class_1297 class_12972;
            float h = class_3532.method_17821((float)tickDelta, (float)livingEntity.field_6220, (float)livingEntity.field_6283);
            float j = class_3532.method_17821((float)tickDelta, (float)livingEntity.field_6259, (float)livingEntity.field_6241);
            float k = j - h;
            if (livingEntity.method_5765() && (class_12972 = livingEntity.method_5854()) instanceof class_1309) {
                class_1309 livingEntity2 = (class_1309)class_12972;
                h = class_3532.method_17821((float)tickDelta, (float)livingEntity2.field_6220, (float)livingEntity2.field_6283);
                k = j - h;
                float l = class_3532.method_15393((float)k);
                if (l < -85.0f) {
                    l = -85.0f;
                }
                if (l >= 85.0f) {
                    l = 85.0f;
                }
                h = j - l;
                if (l * l > 2500.0f) {
                    h += l * 0.2f;
                }
                k = j - h;
            }
            float m = class_3532.method_16439((float)tickDelta, (float)livingEntity.field_6004, (float)livingEntity.method_36455());
            if (class_922.method_38563((class_1309)livingEntity)) {
                m *= -1.0f;
                k *= -1.0f;
            }
            headPitch = m;
            if (k > 180.0f || k < -180.0f) {
                float normalizedAngle = k % 360.0f;
                if (normalizedAngle > 180.0f) {
                    normalizedAngle -= 360.0f;
                } else if (normalizedAngle < -180.0f) {
                    normalizedAngle += 360.0f;
                }
                headYaw = normalizedAngle;
            } else {
                headYaw = k;
            }
        } else {
            headPitch = 0.0f;
            headYaw = 0.0f;
        }
    }

    public static float getTickDelta() {
        return tickDelta;
    }

    public static float getMoveForward() {
        if (emfEntity == null) {
            return 0.0f;
        }
        double lookDir = Math.toRadians(90.0f - emfEntity.getYaw());
        class_243 velocity = emfEntity.getVelocity();
        double x = velocity.field_1352;
        double y = velocity.field_1350;
        double newX = x * Math.cos(lookDir) - y * Math.sin(lookDir);
        return EMFAnimationHelper.processMove(newX, x, y);
    }

    public static float getMoveStrafe() {
        if (emfEntity == null) {
            return 0.0f;
        }
        double lookDir = Math.toRadians(90.0f - emfEntity.getYaw());
        class_243 velocity = emfEntity.getVelocity();
        double x = velocity.field_1352;
        double y = velocity.field_1350;
        double newY = x * Math.sin(lookDir) + y * Math.cos(lookDir);
        return EMFAnimationHelper.processMove(newY, x, y);
    }

    private static float processMove(double value, double x, double y) {
        double totalMovementVector = Math.sqrt(x * x + y * y);
        if (totalMovementVector == 0.0) {
            return 0.0f;
        }
        return (float)(-(value / totalMovementVector));
    }

    public static float getShadowSize() {
        return shadowSize;
    }

    public static void setShadowSize(float shadowSize) {
        EMFAnimationHelper.shadowSize = shadowSize;
    }

    public static float getShadowOpacity() {
        return shadowOpacity;
    }

    public static void setShadowOpacity(float shadowOpacity) {
        EMFAnimationHelper.shadowOpacity = shadowOpacity;
    }

    public static float getLeashX() {
        return leashX;
    }

    public static void setLeashX(float leashX) {
        EMFAnimationHelper.leashX = leashX;
    }

    public static float getLeashY() {
        return leashY;
    }

    public static void setLeashY(float leashY) {
        EMFAnimationHelper.leashY = leashY;
    }

    public static float getLeashZ() {
        return leashZ;
    }

    public static void setLeashZ(float leashZ) {
        EMFAnimationHelper.leashZ = leashZ;
    }

    public static float getShadowX() {
        return shadowX;
    }

    public static void setShadowX(float shadowX) {
        EMFAnimationHelper.shadowX = shadowX;
    }

    public static float getShadowZ() {
        return shadowZ;
    }

    public static void setShadowZ(float shadowZ) {
        EMFAnimationHelper.shadowZ = shadowZ;
    }
}

