/*
 * Decompiled with CFR 0.152.
 */
package fr.hugman.promenade;

import com.terraformersmc.terraform.boat.api.TerraformBoatType;
import fr.hugman.dawn.block.SignBlocks;
import fr.hugman.dawn.client.ClientRegistrar;
import fr.hugman.promenade.client.PromenadeEntityModelLayers;
import fr.hugman.promenade.client.render.entity.CapybaraRenderer;
import fr.hugman.promenade.client.render.entity.DuckRenderer;
import fr.hugman.promenade.client.render.entity.LushCreeperRenderer;
import fr.hugman.promenade.client.render.entity.SunkenSkeletonRenderer;
import fr.hugman.promenade.particle.FloatingParticle;
import fr.hugman.promenade.registry.content.AmaranthContent;
import fr.hugman.promenade.registry.content.AnimalContent;
import fr.hugman.promenade.registry.content.FoodContent;
import fr.hugman.promenade.registry.content.GlaglaglaContent;
import fr.hugman.promenade.registry.content.MapleContent;
import fr.hugman.promenade.registry.content.MonsterContent;
import fr.hugman.promenade.registry.content.SakuraContent;
import fr.hugman.promenade.registry.content.TropicalContent;
import fr.hugman.promenade.registry.content.VanillaPilesContent;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1163;
import net.minecraft.class_1747;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2396;
import net.minecraft.class_2680;
import net.minecraft.class_322;

@Environment(value=EnvType.CLIENT)
public class PromenadeClient
implements ClientModInitializer {
    private static final int SAP_MAPLE_COLOR = 10931465;
    private static final int PALM_COLOR = 8237614;

    public void onInitializeClient() {
        PromenadeEntityModelLayers.init();
        PromenadeClient.registerRenderLayers();
        PromenadeClient.registerBlockColors();
        PromenadeClient.registerItemColors();
        PromenadeClient.registerEntityRenderers();
        ParticleFactoryRegistry.getInstance().register((class_2396)SakuraContent.BLUSH_SAKURA_BLOSSOM, FloatingParticle.BlossomFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SakuraContent.COTTON_SAKURA_BLOSSOM, FloatingParticle.BlossomFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)MapleContent.MAPLE_LEAF, FloatingParticle.MapleLeafFactory::new);
        ClientRegistrar.add((SignBlocks)SakuraContent.SAKURA_SIGNS);
        ClientRegistrar.add((TerraformBoatType)SakuraContent.SAKURA_BOAT_TYPE);
        ClientRegistrar.add((SignBlocks)MapleContent.MAPLE_SIGNS);
        ClientRegistrar.add((TerraformBoatType)MapleContent.MAPLE_BOAT_TYPE);
        ClientRegistrar.add((SignBlocks)TropicalContent.PALM_SIGNS);
        ClientRegistrar.add((TerraformBoatType)TropicalContent.PALM_BOAT_TYPE);
        ClientRegistrar.add((SignBlocks)AmaranthContent.DARK_AMARANTH_SIGNS);
    }

    public static void registerRenderLayers() {
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.OAK_LEAF_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.SPRUCE_LEAF_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.BIRCH_LEAF_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.JUNGLE_LEAF_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.ACACIA_LEAF_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.DARK_OAK_LEAF_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.MANGROVE_LEAF_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.AZALEA_LEAF_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.FLOWERING_AZALEA_LEAF_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.DANDELION_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.POPPY_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.BLUE_ORCHID_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.ALLIUM_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.AZURE_BLUET_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.RED_TULIP_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.ORANGE_TULIP_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.WHITE_TULIP_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.PINK_TULIP_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.OXEYE_DAISY_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.CORNFLOWER_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.LILY_OF_THE_VALLEY_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(VanillaPilesContent.WITHER_ROSE_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(SakuraContent.SAKURA_DOOR, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(SakuraContent.SAKURA_TRAPDOOR, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(SakuraContent.BLUSH_SAKURA_BLOSSOMS, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(SakuraContent.BLUSH_SAKURA_SAPLING, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(SakuraContent.POTTED_BLUSH_SAKURA_SAPLING, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(SakuraContent.BLUSH_SAKURA_BLOSSOM_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(SakuraContent.COTTON_SAKURA_SAPLING, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(SakuraContent.POTTED_COTTON_SAKURA_SAPLING, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(SakuraContent.COTTON_SAKURA_BLOSSOMS, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(SakuraContent.COTTON_SAKURA_BLOSSOM_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.MAPLE_DOOR, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.MAPLE_TRAPDOOR, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.VERMILION_MAPLE_SAPLING, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.POTTED_VERMILION_MAPLE_SAPLING, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.VERMILION_MAPLE_LEAVES, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.VERMILION_MAPLE_LEAF_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.VERMILION_CARPETED_GRASS_BLOCK, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.FULVOUS_MAPLE_SAPLING, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.POTTED_FULVOUS_MAPLE_SAPLING, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.FULVOUS_MAPLE_LEAVES, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.FULVOUS_MAPLE_LEAF_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.FULVOUS_CARPETED_GRASS_BLOCK, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.MIKADO_MAPLE_SAPLING, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.POTTED_MIKADO_MAPLE_SAPLING, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.MIKADO_MAPLE_LEAVES, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.MIKADO_MAPLE_LEAF_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.MIKADO_CARPETED_GRASS_BLOCK, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.SAP_MAPLE_SAPLING, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.POTTED_SAP_MAPLE_SAPLING, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.SAP_MAPLE_LEAVES, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MapleContent.SAP_MAPLE_LEAF_PILE, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(TropicalContent.PALM_DOOR, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(TropicalContent.PALM_TRAPDOOR, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(TropicalContent.PALM_SAPLING, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(TropicalContent.POTTED_PALM_SAPLING, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(TropicalContent.PALM_LEAVES, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(TropicalContent.PALM_HANGING_LEAVES, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(TropicalContent.PALM_LEAF_PILE, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(AmaranthContent.DARK_AMARANTH_DOOR, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(AmaranthContent.DARK_AMARANTH_TRAPDOOR, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(AmaranthContent.DARK_AMARANTH_ROOTS, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(AmaranthContent.DARK_AMARANTH_FUNGUS, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(AmaranthContent.POTTED_DARK_AMARANTH_FUNGUS, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(FoodContent.BLUEBERRY_BUSH, class_1921.method_23581());
    }

    private static void registerBlockColors() {
        ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> 8237614, (Object[])new class_2248[]{TropicalContent.PALM_LEAVES, TropicalContent.PALM_HANGING_LEAVES, TropicalContent.PALM_LEAF_PILE});
        ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> pos != null && world != null ? class_1163.method_4966((class_1920)world, (class_2338)pos) : class_1926.method_8341(), (Object[])new class_2248[]{VanillaPilesContent.OAK_LEAF_PILE, VanillaPilesContent.JUNGLE_LEAF_PILE, VanillaPilesContent.ACACIA_LEAF_PILE, VanillaPilesContent.DARK_OAK_LEAF_PILE, VanillaPilesContent.MANGROVE_LEAF_PILE, MapleContent.SAP_MAPLE_LEAVES, MapleContent.SAP_MAPLE_LEAF_PILE});
        ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> class_1926.method_8342(), (Object[])new class_2248[]{VanillaPilesContent.SPRUCE_LEAF_PILE, GlaglaglaContent.SNOWY_SPRUCE_LEAVES});
        ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> class_1926.method_8343(), (Object[])new class_2248[]{VanillaPilesContent.BIRCH_LEAF_PILE});
        ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return class_1933.method_8377((double)0.5, (double)1.0);
            }
            return class_1163.method_4962((class_1920)world, (class_2338)pos);
        }, (Object[])new class_2248[]{MapleContent.VERMILION_CARPETED_GRASS_BLOCK, MapleContent.FULVOUS_CARPETED_GRASS_BLOCK, MapleContent.MIKADO_CARPETED_GRASS_BLOCK});
    }

    private static void registerItemColors() {
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> 8237614, (Object[])new class_1935[]{TropicalContent.PALM_LEAVES, TropicalContent.PALM_HANGING_LEAVES, TropicalContent.PALM_LEAF_PILE});
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            class_2248 block = ((class_1747)stack.method_7909()).method_7711();
            class_2680 blockState = block.method_9564();
            return ((class_322)ColorProviderRegistry.BLOCK.get((Object)block)).getColor(blockState, null, null, tintIndex);
        }, (Object[])new class_1935[]{VanillaPilesContent.OAK_LEAF_PILE, VanillaPilesContent.SPRUCE_LEAF_PILE, VanillaPilesContent.BIRCH_LEAF_PILE, VanillaPilesContent.JUNGLE_LEAF_PILE, VanillaPilesContent.ACACIA_LEAF_PILE, VanillaPilesContent.DARK_OAK_LEAF_PILE, MapleContent.VERMILION_CARPETED_GRASS_BLOCK, MapleContent.FULVOUS_CARPETED_GRASS_BLOCK, MapleContent.MIKADO_CARPETED_GRASS_BLOCK, GlaglaglaContent.SNOWY_SPRUCE_LEAVES});
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> class_1926.method_43717(), (Object[])new class_1935[]{VanillaPilesContent.MANGROVE_LEAF_PILE});
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> 10931465, (Object[])new class_1935[]{MapleContent.SAP_MAPLE_LEAVES, MapleContent.SAP_MAPLE_LEAF_PILE});
    }

    public static void registerEntityRenderers() {
        EntityRendererRegistry.register(AnimalContent.CAPYBARA, CapybaraRenderer::new);
        EntityRendererRegistry.register(AnimalContent.DUCK, DuckRenderer::new);
        EntityRendererRegistry.register(MonsterContent.LUSH_CREEPER, LushCreeperRenderer::new);
        EntityRendererRegistry.register(MonsterContent.SUNKEN_SKELETON, SunkenSkeletonRenderer::new);
    }
}

