/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.terminal;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.MEStorage;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.localization.PlayerMessages;
import appeng.helpers.WirelessTerminalMenuHost;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.menu.ISubMenu;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import de.mari_023.ae2wtlib.AE2wtlibConfig;
import de.mari_023.ae2wtlib.Platform;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import java.util.function.BiConsumer;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public abstract class WTMenuHost
extends WirelessTerminalMenuHost
implements InternalInventoryHost,
ISegmentedInventory {
    private final AppEngInternalInventory singularityInventory = new AppEngInternalInventory((InternalInventoryHost)this, 1);
    private final AppEngInternalInventory viewCellInventory = new AppEngInternalInventory((InternalInventoryHost)this, 5);
    private boolean rangeCheck;
    private final IGrid targetGrid;
    private IActionHost quantumBridge;
    private IUpgradeInventory upgradeInventory;
    public static final class_2960 INV_SINGULARITY = new class_2960("ae2wtlib", "singularity");

    public WTMenuHost(class_1657 player, @Nullable Integer inventorySlot, class_1799 is, BiConsumer<class_1657, ISubMenu> returnToMainMenu) {
        super(player, inventorySlot, is, returnToMainMenu);
        this.upgradeInventory = UpgradeInventories.forItem((class_1799)is, (int)WUTHandler.getUpgradeCardCount(), this::updateUpgrades);
        this.targetGrid = ((WirelessTerminalItem)is.method_7909()).getLinkedGrid(is, player.method_37908(), null);
    }

    public void updateUpgrades(class_1799 stack, IUpgradeInventory upgrades) {
        this.upgradeInventory = upgrades;
    }

    protected void readFromNbt() {
        class_2487 tag = this.getItemStack().method_7948();
        this.viewCellInventory.readFromNBT(tag, "viewcells");
        this.singularityInventory.readFromNBT(tag, "singularity");
    }

    public void saveChanges() {
        class_2487 tag = this.getItemStack().method_7948();
        this.viewCellInventory.writeToNBT(tag, "viewcells");
        this.singularityInventory.writeToNBT(tag, "singularity");
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        this.saveChanges();
    }

    @Nullable
    public IGridNode getActionableNode() {
        if (this.isQuantumLinked() && !this.getPlayer().method_37908().method_8608()) {
            return this.quantumBridge.getActionableNode();
        }
        return super.getActionableNode();
    }

    @Nullable
    public MEStorage getInventory() {
        IGridNode node = this.getActionableNode();
        if (node == null) {
            return null;
        }
        return node.getGrid().getStorageService().getInventory();
    }

    public boolean rangeCheck() {
        this.rangeCheck = super.rangeCheck();
        return this.isQuantumLinked() || this.rangeCheck;
    }

    public boolean isQuantumLinked() {
        long frequency = ItemWT.getQEFrequency(this.getItemStack(), this.singularityInventory);
        if (this.quantumBridge == null) {
            this.quantumBridge = ItemWT.getQuantumBridge(this.getItemStack(), this.getPlayer().method_37908(), this.singularityInventory, this.upgradeInventory);
            if (this.quantumBridge == null) {
                return false;
            }
        } else {
            IActionHost iActionHost = this.quantumBridge;
            if (iActionHost instanceof QuantumCluster) {
                QuantumCluster quantumCluster = (QuantumCluster)iActionHost;
                if (quantumCluster.getCenter() == null) {
                    return false;
                }
                long frequencyOther = quantumCluster.getCenter().getQEFrequency();
                if (frequencyOther != frequency && frequencyOther != -frequency && ItemWT.findQuantumBridge(this.getPlayer().method_37908(), frequency) == null) {
                    return false;
                }
            } else if (ItemWT.findQuantumBridge(this.getPlayer().method_37908(), frequency) == null) {
                return false;
            }
        }
        if (this.quantumBridge.getActionableNode() == null) {
            return false;
        }
        return (this.quantumBridge.getActionableNode().getGrid() == this.targetGrid || this.targetGrid == null) && this.targetGrid.getEnergyService().isNetworkPowered();
    }

    public AppEngInternalInventory getViewCellStorage() {
        return this.viewCellInventory;
    }

    protected void setPowerDrainPerTick(double powerDrainPerTick) {
        if (this.rangeCheck) {
            super.setPowerDrainPerTick(powerDrainPerTick);
        } else {
            super.setPowerDrainPerTick(AE2wtlibConfig.INSTANCE.getOutOfRangePower());
        }
    }

    public boolean drainPower() {
        this.recharge();
        if (!super.drainPower()) {
            this.getPlayer().method_7353((class_2561)PlayerMessages.DeviceNotPowered.text(), true);
            return false;
        }
        this.recharge();
        return true;
    }

    private void recharge() {
        if (this.quantumBridge == null) {
            return;
        }
        class_1792 class_17922 = this.getItemStack().method_7909();
        if (class_17922 instanceof AEBasePoweredItem) {
            double networkMax;
            AEBasePoweredItem item = (AEBasePoweredItem)class_17922;
            double currentPower = item.getAECurrentPower(this.getItemStack());
            double maxPower = item.getAEMaxPower(this.getItemStack());
            double missing = maxPower - currentPower;
            if (this.getActionableNode() == null || missing <= 0.0) {
                return;
            }
            IEnergyService energyService = this.getActionableNode().getGrid().getEnergyService();
            double networkCurrent = energyService.getStoredPower();
            double safePower = networkCurrent - (networkMax = energyService.getMaxStoredPower()) / 2.0;
            if (safePower > 0.0) {
                double toMove = Math.min(missing, safePower);
                double extracted = energyService.extractAEPower(toMove, Actionable.MODULATE, PowerMultiplier.ONE);
                item.injectAEPower(this.getItemStack(), extracted, Actionable.MODULATE);
            } else {
                double networkMissing = networkMax / 2.0 - networkCurrent;
                double available = Math.min(0.0, maxPower / 2.0 - currentPower);
                double toMove = -Math.min(networkMissing, available);
                double extracted = item.extractAEPower(this.getItemStack(), toMove, Actionable.MODULATE);
                energyService.injectPower(extracted, Actionable.MODULATE);
            }
        }
    }

    @Nullable
    public InternalInventory getSubInventory(class_2960 id) {
        if (id.equals((Object)INV_SINGULARITY)) {
            return this.singularityInventory;
        }
        return null;
    }

    public boolean stillValid() {
        return this.ensureItemStillInSlot();
    }

    protected boolean ensureItemStillInSlot() {
        if (this.getSlot() != null) {
            return super.ensureItemStillInSlot();
        }
        return Platform.isStillPresentTrinkets(this.getPlayer(), this.getItemStack());
    }
}

