/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.registry;

import io.github.jamalam360.jamlib.JamLib;
import io.github.jamalam360.jamlib.registry.JamLibContentRegistry;
import io.github.jamalam360.jamlib.registry.annotation.ContentRegistry;
import io.github.jamalam360.jamlib.registry.annotation.WithIdentifier;
import io.github.jamalam360.jamlib.registry.annotation.WithoutBlockItem;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1535;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2582;
import net.minecraft.class_2591;
import net.minecraft.class_2806;
import net.minecraft.class_2939;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3414;
import net.minecraft.class_3448;
import net.minecraft.class_3611;
import net.minecraft.class_3773;
import net.minecraft.class_3816;
import net.minecraft.class_3825;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4140;
import net.minecraft.class_4149;
import net.minecraft.class_4158;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_4648;
import net.minecraft.class_4652;
import net.minecraft.class_4663;
import net.minecraft.class_4995;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5142;
import net.minecraft.class_5202;
import net.minecraft.class_5321;
import net.minecraft.class_5338;
import net.minecraft.class_5342;
import net.minecraft.class_5650;
import net.minecraft.class_5657;
import net.minecraft.class_5669;
import net.minecraft.class_5712;
import net.minecraft.class_5717;
import net.minecraft.class_5864;
import net.minecraft.class_6018;
import net.minecraft.class_6123;
import net.minecraft.class_6798;
import net.minecraft.class_6875;
import net.minecraft.class_7106;
import net.minecraft.class_7151;
import net.minecraft.class_7375;
import net.minecraft.class_7388;
import net.minecraft.class_7444;
import net.minecraft.class_7923;

public class JamLibRegistry {
    private static final Map<Class<?>, class_2378<?>> REGISTRIES = new HashMap();
    private static final Map<class_5321<class_1761>, List<class_1792>> ITEM_GROUP_REGISTRATION_QUEUE = new HashMap<class_5321<class_1761>, List<class_1792>>();

    public static void addRegistry(Class<?> type, class_2378<?> registry) {
        REGISTRIES.put(type, registry);
    }

    public static void register(Class<?> ... registries) {
        for (Class<?> clazz : registries) {
            JamLibRegistry.register(clazz);
        }
    }

    public static void register(Class<?> registry) {
        if (!registry.isAnnotationPresent(ContentRegistry.class)) {
            JamLib.LOGGER.warn("@ContentRegistry annotation not present on registry class", registry.getName());
            return;
        }
        String modId = registry.getAnnotation(ContentRegistry.class).value();
        JamLibContentRegistry jlcr = null;
        if (JamLibContentRegistry.class.isAssignableFrom(registry)) {
            try {
                jlcr = (JamLibContentRegistry)registry.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                JamLib.LOGGER.warn("Couldn't create instance of registry", registry.getName(), ", some features will not be available");
            }
        }
        block8: for (Field f : registry.getFields()) {
            if (!f.canAccess(null)) {
                JamLib.LOGGER.warn("Cannot access field", f.getName(), "in registry class", registry.getName());
                continue;
            }
            Class<?> fClass = f.getType();
            Object fObj = null;
            try {
                fObj = f.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            class_2960 fId = JamLibRegistry.getIdentifier(modId, f);
            for (Map.Entry<Class<?>, class_2378<?>> e : REGISTRIES.entrySet()) {
                if (!e.getKey().isAssignableFrom(fClass)) continue;
                class_2378.method_10230(e.getValue(), (class_2960)fId, (Object)fObj);
                break;
            }
            if (jlcr != null && class_1792.class.isAssignableFrom(fClass)) {
                class_5321<class_1761> group = jlcr.getItemGroup((class_1792)fObj);
                if (group == null) continue;
                List l = ITEM_GROUP_REGISTRATION_QUEUE.getOrDefault(group, new ArrayList());
                l.add((class_1792)fObj);
                ITEM_GROUP_REGISTRATION_QUEUE.put(group, l);
            }
            if (class_2248.class.isAssignableFrom(fClass) && jlcr != null && !f.isAnnotationPresent(WithoutBlockItem.class)) {
                class_1792 item = jlcr.createBlockItem((class_2248)fObj);
                if (item == null) continue;
                class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)fId, (Object)item);
                class_5321<class_1761> group = jlcr.getItemGroup(item);
                if (group == null) continue;
                List l = ITEM_GROUP_REGISTRATION_QUEUE.getOrDefault(group, new ArrayList());
                l.add(item);
                ITEM_GROUP_REGISTRATION_QUEUE.put(group, l);
            }
            if (!class_1299.class.isAssignableFrom(fClass)) continue;
            Class<?> entityClass = null;
            try {
                entityClass = Class.forName(((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0].getTypeName());
            }
            catch (ClassNotFoundException e) {
                JamLib.LOGGER.warn("Encountered error registering entity attributes. This should absolutely be reported. Reflection was a mistake...");
                JamLib.LOGGER.warn(e.toString());
            }
            if (entityClass == null) continue;
            for (Method method : entityClass.getMethods()) {
                if (method.getDeclaringClass() != entityClass || !Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 0 || method.getReturnType() != class_5132.class_5133.class) continue;
                JamLib.DEV_LOGGER.info("Registering entity attributes for", entityClass.getName(), "automatically");
                try {
                    FabricDefaultAttributeRegistry.register((class_1299)((class_1299)fObj), (class_5132.class_5133)((class_5132.class_5133)method.invoke(null, new Object[0])));
                }
                catch (Exception e) {
                    JamLib.LOGGER.warn("Failed to register entity attributes for", entityClass.getName());
                    JamLib.LOGGER.warn(e.toString());
                }
                continue block8;
            }
        }
        for (class_5321 class_53212 : ITEM_GROUP_REGISTRATION_QUEUE.keySet()) {
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_53212).register(content -> {
                for (class_1792 item : ITEM_GROUP_REGISTRATION_QUEUE.get(group)) {
                    content.method_45420(item.method_7854());
                }
            });
        }
    }

    private static class_2960 getIdentifier(String modId, Field f) {
        String path = f.isAnnotationPresent(WithIdentifier.class) ? f.getAnnotation(WithIdentifier.class).value() : f.getName().toLowerCase(Locale.ROOT);
        return new class_2960(modId, path);
    }

    static {
        JamLibRegistry.addRegistry(class_5712.class, class_7923.field_41171);
        JamLibRegistry.addRegistry(class_3414.class, class_7923.field_41172);
        JamLibRegistry.addRegistry(class_3611.class, class_7923.field_41173);
        JamLibRegistry.addRegistry(class_1291.class, class_7923.field_41174);
        JamLibRegistry.addRegistry(class_2248.class, class_7923.field_41175);
        JamLibRegistry.addRegistry(class_1887.class, class_7923.field_41176);
        JamLibRegistry.addRegistry(class_1299.class, class_7923.field_41177);
        JamLibRegistry.addRegistry(class_1792.class, class_7923.field_41178);
        JamLibRegistry.addRegistry(class_1842.class, class_7923.field_41179);
        JamLibRegistry.addRegistry(class_2396.class, class_7923.field_41180);
        JamLibRegistry.addRegistry(class_2591.class, class_7923.field_41181);
        JamLibRegistry.addRegistry(class_1535.class, class_7923.field_41182);
        JamLibRegistry.addRegistry(class_2960.class, class_7923.field_41183);
        JamLibRegistry.addRegistry(class_2806.class, class_7923.field_41184);
        JamLibRegistry.addRegistry(class_3825.class, class_7923.field_41185);
        JamLibRegistry.addRegistry(class_4995.class, class_7923.field_41186);
        JamLibRegistry.addRegistry(class_3917.class, class_7923.field_41187);
        JamLibRegistry.addRegistry(class_3956.class, class_7923.field_41188);
        JamLibRegistry.addRegistry(class_1865.class, class_7923.field_41189);
        JamLibRegistry.addRegistry(class_5134.class, class_7923.field_41190);
        JamLibRegistry.addRegistry(class_5717.class, class_7923.field_41191);
        JamLibRegistry.addRegistry(class_2314.class, class_7923.field_41192);
        JamLibRegistry.addRegistry(class_3448.class, class_7923.field_41193);
        JamLibRegistry.addRegistry(class_3854.class, class_7923.field_41194);
        JamLibRegistry.addRegistry(class_3852.class, class_7923.field_41195);
        JamLibRegistry.addRegistry(class_4158.class, class_7923.field_41128);
        JamLibRegistry.addRegistry(class_4140.class, class_7923.field_41129);
        JamLibRegistry.addRegistry(class_4149.class, class_7923.field_41130);
        JamLibRegistry.addRegistry(class_4170.class, class_7923.field_41131);
        JamLibRegistry.addRegistry(class_4168.class, class_7923.field_41132);
        JamLibRegistry.addRegistry(class_5338.class, class_7923.field_41133);
        JamLibRegistry.addRegistry(class_5342.class, class_7923.field_41135);
        JamLibRegistry.addRegistry(class_5657.class, class_7923.field_41136);
        JamLibRegistry.addRegistry(class_5650.class, class_7923.field_41137);
        JamLibRegistry.addRegistry(class_5669.class, class_7923.field_41138);
        JamLibRegistry.addRegistry(class_5864.class, class_7923.field_41139);
        JamLibRegistry.addRegistry(class_6018.class, class_7923.field_41140);
        JamLibRegistry.addRegistry(class_6123.class, class_7923.field_41141);
        JamLibRegistry.addRegistry(class_2939.class, class_7923.field_41143);
        JamLibRegistry.addRegistry(class_3031.class, class_7923.field_41144);
        JamLibRegistry.addRegistry(class_6875.class, class_7923.field_41145);
        JamLibRegistry.addRegistry(class_3773.class, class_7923.field_41146);
        JamLibRegistry.addRegistry(class_7151.class, class_7923.field_41147);
        JamLibRegistry.addRegistry(class_6798.class, class_7923.field_41148);
        JamLibRegistry.addRegistry(class_4652.class, class_7923.field_41149);
        JamLibRegistry.addRegistry(class_4648.class, class_7923.field_41150);
        JamLibRegistry.addRegistry(class_5142.class, class_7923.field_41151);
        JamLibRegistry.addRegistry(class_7388.class, class_7923.field_41152);
        JamLibRegistry.addRegistry(class_4663.class, class_7923.field_41153);
        JamLibRegistry.addRegistry(class_5202.class, class_7923.field_41155);
        JamLibRegistry.addRegistry(class_4663.class, class_7923.field_41153);
        JamLibRegistry.addRegistry(class_3816.class, class_7923.field_41162);
        JamLibRegistry.addRegistry(class_7375.class, class_7923.field_41163);
        JamLibRegistry.addRegistry(class_7106.class, class_7923.field_41164);
        JamLibRegistry.addRegistry(class_2582.class, class_7923.field_41165);
        JamLibRegistry.addRegistry(class_7444.class, class_7923.field_41166);
    }
}

