/*
 * Decompiled with CFR 0.152.
 */
package net.wizards.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.spell_engine.api.item.ItemConfig;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_engine.api.loot.LootConfig;
import net.wizards.item.Armors;
import net.wizards.item.Weapons;

public class Default {
    public static final ItemConfig itemConfig = new ItemConfig();
    public static final LootConfig lootConfig;
    public static final StructurePoolConfig villageConfig;

    @SafeVarargs
    private static <T> List<T> joinLists(List<T> ... lists) {
        return Arrays.stream(lists).flatMap(Collection::stream).collect(Collectors.toList());
    }

    static {
        for (Weapon.Entry weapon : Weapons.entries) {
            Default.itemConfig.weapons.put(weapon.name(), weapon.defaults());
        }
        for (Armor.Entry armorSet : Armors.entries) {
            Default.itemConfig.armor_sets.put(armorSet.name(), armorSet.defaults());
        }
        lootConfig = new LootConfig();
        Default.lootConfig.item_groups.put("wands_tier_0", new LootConfig.ItemGroup(List.of(Weapons.noviceWand.id().toString()), 0.25f, 0.0f, 1).chance(0.3f));
        Default.lootConfig.item_groups.put("wands_tier_1", new LootConfig.ItemGroup(List.of(Weapons.arcaneWand.id().toString(), Weapons.fireWand.id().toString(), Weapons.frostWand.id().toString()), 0.4f, 0.0f, 1).chance(0.3f));
        String staves_tier_1 = "staves_tier_1";
        Default.lootConfig.item_groups.put(staves_tier_1, new LootConfig.ItemGroup(List.of(Weapons.wizardStaff.id().toString()), 1).chance(0.3f));
        String staves_tier_2 = "staves_tier_2";
        Default.lootConfig.item_groups.put(staves_tier_2, new LootConfig.ItemGroup(List.of(Weapons.arcaneStaff.id().toString(), Weapons.fireStaff.id().toString(), Weapons.frostStaff.id().toString()), 1).chance(0.3f));
        Default.lootConfig.item_groups.put("staves_tier_1_enchanted", new LootConfig.ItemGroup(new ArrayList(((LootConfig.ItemGroup)Default.lootConfig.item_groups.get((Object)staves_tier_1)).ids), 1).chance(0.3f).enchant());
        Default.lootConfig.item_groups.put("staves_tier_2_enchanted", new LootConfig.ItemGroup(new ArrayList(((LootConfig.ItemGroup)Default.lootConfig.item_groups.get((Object)staves_tier_2)).ids), 1).chance(0.3f).enchant());
        String robes_tier_1 = "robes_tier_1";
        Default.lootConfig.item_groups.put(robes_tier_1, new LootConfig.ItemGroup(Default.joinLists(Armors.wizardRobeSet.idStrings()), 1).chance(0.25f));
        Default.lootConfig.item_groups.put("robes_tier_1_enchanted", new LootConfig.ItemGroup(new ArrayList(((LootConfig.ItemGroup)Default.lootConfig.item_groups.get((Object)robes_tier_1)).ids), 1).chance(0.25f).enchant());
        String robes_tier_2 = "robes_tier_2";
        Default.lootConfig.item_groups.put(robes_tier_2, new LootConfig.ItemGroup(Default.joinLists(Armors.arcaneRobeSet.idStrings(), Armors.fireRobeSet.idStrings(), Armors.frostRobeSet.idStrings()), 1).chance(0.5f));
        Default.lootConfig.item_groups.put("robes_tier_2_enchanted", new LootConfig.ItemGroup(new ArrayList(((LootConfig.ItemGroup)Default.lootConfig.item_groups.get((Object)robes_tier_2)).ids), 1).chance(0.5f).enchant());
        List.of("minecraft:chests/abandoned_mineshaft", "minecraft:chests/igloo_chest", "minecraft:chests/shipwreck_supply", "minecraft:chests/jungle_temple").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("wands_tier_0")));
        List.of("minecraft:chests/desert_pyramid", "minecraft:chests/bastion_bridge", "minecraft:chests/jungle_temple", "minecraft:chests/pillager_outpost", "minecraft:chests/simple_dungeon", "minecraft:chests/stronghold_crossing").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("wands_tier_1", "staves_tier_1")));
        List.of("minecraft:chests/shipwreck_treasure").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("robes_tier_1")));
        List.of("minecraft:chests/stronghold_library", "minecraft:chests/underwater_ruin_big", "minecraft:chests/woodland_mansion").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("staves_tier_1_enchanted", "robes_tier_1_enchanted")));
        List.of("minecraft:chests/bastion_other", "minecraft:chests/nether_bridge", "minecraft:chests/underwater_ruin_small").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("staves_tier_2")));
        List.of("minecraft:chests/end_city_treasure", "minecraft:chests/bastion_treasure", "minecraft:chests/ancient_city", "minecraft:chests/stronghold_library").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("staves_tier_2_enchanted", "robes_tier_2")));
        villageConfig = new StructurePoolConfig();
        int limit = 1;
        Default.villageConfig.entries.addAll(List.of(new StructurePoolConfig.Entry("minecraft:village/desert/houses", new ArrayList<StructurePoolConfig.Entry.Structure>(Arrays.asList(new StructurePoolConfig.Entry.Structure("wizards:village/desert/wizard_tower", 1, limit), new StructurePoolConfig.Entry.Structure("wizards:village/desert/wizard_tower_2", 3, limit)))), new StructurePoolConfig.Entry("minecraft:village/savanna/houses", "wizards:village/savanna/wizard_tower", 3, limit), new StructurePoolConfig.Entry("minecraft:village/plains/houses", "wizards:village/plains/wizard_tower", 3, limit), new StructurePoolConfig.Entry("minecraft:village/taiga/houses", "wizards:village/taiga/wizard_tower", 3, limit), new StructurePoolConfig.Entry("minecraft:village/snowy/houses", new ArrayList<StructurePoolConfig.Entry.Structure>(Arrays.asList(new StructurePoolConfig.Entry.Structure("wizards:village/snowy/wizard_tower", 1, limit), new StructurePoolConfig.Entry.Structure("wizards:village/snowy/wizard_tower_2", 3, limit))))));
    }
}

